/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ws;

import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.ws.CertificatesDialog;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.net.ssl.X509TrustManager;
import javax.swing.SwingUtilities;

public class IReportTrustManager
implements X509TrustManager {
    public static final String TRUSTED_CERTIFICATE_FINGERPRINTS = "trustedCertificateFingerprints";
    private List<String> temporaryCertificates = new ArrayList<String>();
    private List<String> trustedCertificates = new ArrayList<String>();
    private boolean storingFingerprints = false;
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    public IReportTrustManager() {
        this.reloadTrustedCertificates();
        JasperServerManager.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent evt) {
                if (!IReportTrustManager.this.isStoringFingerprints() && evt.getKey().equals(IReportTrustManager.TRUSTED_CERTIFICATE_FINGERPRINTS)) {
                    IReportTrustManager.this.reloadTrustedCertificates();
                }
            }
        });
    }

    private void reloadTrustedCertificates() {
        this.trustedCertificates.clear();
        this.temporaryCertificates.clear();
        String trustedSites = JasperServerManager.getPreferences().get(TRUSTED_CERTIFICATE_FINGERPRINTS, "");
        String[] fingerprints = trustedSites.split(":");
        this.trustedCertificates.addAll(Arrays.asList(fingerprints));
    }

    private void saveCertificates() {
        String trustedCertificateFingerprints = "";
        for (String s : this.trustedCertificates) {
            trustedCertificateFingerprints = trustedCertificateFingerprints + s + ":";
        }
        this.setStoringFingerprints(true);
        JasperServerManager.getPreferences().put(TRUSTED_CERTIFICATE_FINGERPRINTS, trustedCertificateFingerprints);
        this.setStoringFingerprints(false);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        MessageDigest md5;
        MessageDigest sha1;
        if (chain == null || chain.length == 0) {
            throw new CertificateException("No certificate sent by the server");
        }
        try {
            sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CertificateException("Unable to instance the SHA1 Algorithm!");
        }
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CertificateException("Unable to instance the MD5 Algorithm!");
        }
        StringBuffer certsText = new StringBuffer();
        ArrayList<String> currentCertificates = new ArrayList<String>();
        for (int i = 0; i < chain.length; ++i) {
            X509Certificate cert = chain[i];
            String digest = IReportTrustManager.toHexString(sha1.digest());
            if (this.isTrusted(digest)) {
                return;
            }
            if (i == 0) {
                currentCertificates.add(digest);
            }
            certsText.append(" " + (i + 1) + " Subject " + cert.getSubjectDN() + "\n");
            certsText.append("   Issuer  " + cert.getIssuerDN() + "\n");
            sha1.update(cert.getEncoded());
            certsText.append("   sha1    " + digest + "\n");
            md5.update(cert.getEncoded());
            certsText.append("   md5     " + IReportTrustManager.toHexString(md5.digest()) + "\n\n");
        }
        final CertificatesDialog dialog = new CertificatesDialog(Misc.getMainFrame(), true);
        dialog.setCertsText(certsText.toString());
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    dialog.setVisible(true);
                }
            });
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        if (dialog.getDialogResult() == 0) {
            if (dialog.getAnswer() == 0) {
                this.trustedCertificates.addAll(currentCertificates);
                this.saveCertificates();
                return;
            }
            if (dialog.getAnswer() == 1) {
                this.temporaryCertificates.addAll(currentCertificates);
                return;
            }
        }
        throw new CertificateException("Untrusted certificate");
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int n : bytes) {
            sb.append(HEXDIGITS[(n &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[n & 0xF]);
            sb.append(' ');
        }
        return sb.toString();
    }

    public boolean isStoringFingerprints() {
        return this.storingFingerprints;
    }

    public void setStoringFingerprints(boolean storingFingerprints) {
        this.storingFingerprints = storingFingerprints;
    }

    private boolean isTrusted(String fingerprint) {
        for (String s : this.trustedCertificates) {
            if (s == null || !s.equals(fingerprint)) continue;
            return true;
        }
        for (String s : this.temporaryCertificates) {
            if (s == null || !s.equals(fingerprint)) continue;
            return true;
        }
        return false;
    }
}

