/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.InvalidClassFormatException;

public final class LocalVariableTypeTableEntry {
    int startPC;
    int length;
    String name;
    String signature;
    int index;

    static LocalVariableTypeTableEntry[] loadLocalVariableTypeTable(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        LocalVariableTypeTableEntry[] localVariableTypeTableEntryArray = new LocalVariableTypeTableEntry[n];
        for (int i = 0; i < n; ++i) {
            localVariableTypeTableEntryArray[i] = new LocalVariableTypeTableEntry(dataInputStream, constantPool);
        }
        return localVariableTypeTableEntryArray;
    }

    LocalVariableTypeTableEntry(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this.loadLocalVariableEntry(dataInputStream, constantPool);
    }

    private void loadLocalVariableEntry(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this.startPC = dataInputStream.readUnsignedShort();
        this.length = dataInputStream.readUnsignedShort();
        CPEntry cPEntry = constantPool.get(dataInputStream.readUnsignedShort());
        if (!(cPEntry instanceof CPUTF8Info)) {
            throw new InvalidClassFormatException();
        }
        CPUTF8Info cPUTF8Info = (CPUTF8Info)cPEntry;
        this.name = cPUTF8Info.getName();
        cPEntry = constantPool.get(dataInputStream.readUnsignedShort());
        if (!(cPEntry instanceof CPUTF8Info)) {
            throw new InvalidClassFormatException();
        }
        cPUTF8Info = (CPUTF8Info)cPEntry;
        this.signature = cPUTF8Info.getName();
        this.index = dataInputStream.readUnsignedShort();
    }

    public final int getStartPC() {
        return this.startPC;
    }

    public final int getLength() {
        return this.length;
    }

    public final String getName() {
        return this.name;
    }

    public final String getSignature() {
        return this.signature;
    }

    public final int getIndex() {
        return this.index;
    }
}

