/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUtil {
    protected static final Set<PersistenceProvider> providers = new HashSet<PersistenceProvider>();
    private static PersistenceProvider preferredProvider;
    private static final Pattern nonCommentPattern;

    public static boolean isLoaded(Object object) {
        Boolean result;
        Object emf = null;
        if (providers.size() == 0) {
            PersistenceUtil.findAllProviders();
        }
        if (preferredProvider != null && (result = null) != null) {
            return result;
        }
        for (PersistenceProvider provider : providers) {
            Boolean result2 = null;
            if (result2 == null) continue;
            preferredProvider = provider;
            return result2;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findAllProviders() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = loader.getResources("META-INF/services/" + PersistenceProvider.class.getName());
            HashSet<String> names = new HashSet<String>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream is = url.openStream();
                try {
                    names.addAll(PersistenceUtil.providerNamesFromReader(new BufferedReader(new InputStreamReader(is))));
                }
                finally {
                    is.close();
                }
            }
            for (String s : names) {
                Class<?> providerClass = loader.loadClass(s);
                providers.add((PersistenceProvider)providerClass.newInstance());
            }
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        catch (InstantiationException e) {
            throw new PersistenceException(e);
        }
        catch (IllegalAccessException e) {
            throw new PersistenceException(e);
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceException(e);
        }
    }

    private static Set<String> providerNamesFromReader(BufferedReader reader) throws IOException {
        String line;
        HashSet<String> names = new HashSet<String>();
        while ((line = reader.readLine()) != null) {
            Matcher m = nonCommentPattern.matcher(line = line.trim());
            if (!m.find()) continue;
            names.add(m.group().trim());
        }
        return names;
    }

    static {
        nonCommentPattern = Pattern.compile("^([^#]+)");
    }
}

