/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.dimensiontree.elements;

import javax.swing.ImageIcon;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.dimensiontree.elements.PopUpActions;
import rex.metadata.QueryElement;
import rex.metadata.ServerMetadata;
import rex.utils.DOM;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;
import rex.xmla.XMLAObjectsFactory;

public class LevelElement
implements DimensionTreeElement,
QueryElement,
LanguageChangedListener {
    private String catalogName;
    private String schemaName;
    private String cubeName;
    private String dimensionUniqueName;
    private String hierarchyUniqueName;
    private String levelName;
    private String levelUniqueName;
    private String levelGuid;
    private String levelCaption;
    private int levelNumber;
    private int levelCardinality;
    private int levelType;
    private String description;
    private int customRollupSettings;
    private int levelUniqueSettings;
    private boolean levelIsVisible;
    private String levelOrderingProperty;
    private int levelDbtype;
    private String levelMasterUniqueName;
    private String levelNameSqlColumnName;
    private String levelKeySqlColumnName;
    private String levelUniqueNameSqlColumnName;
    private boolean nodeEnabled;
    private XMLADiscoverRestrictions restrictions;
    private XMLADiscoverProperties properties;
    private ServerMetadata parent;
    static int LEVEL_CARDINALITY_NOT_INITIALIZED = -1;
    static ImageIcon[] icon = new ImageIcon[]{S.getAppIcon("level_1.gif"), S.getAppIcon("level_2.gif"), S.getAppIcon("level_3.gif"), S.getAppIcon("level_4.gif"), S.getAppIcon("level_5.gif"), S.getAppIcon("level_6.gif"), S.getAppIcon("level_7.gif"), S.getAppIcon("level_8.gif"), S.getAppIcon("level_9.gif"), S.getAppIcon("level_10.gif")};

    public LevelElement(ServerMetadata svm, Node rowNode, XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties) {
        I18n.addOnLanguageChangedListener(this);
        this.restrictions = XMLAObjectsFactory.newXMLADiscoverRestrictions();
        this.restrictions.setCatalog(_restrictions.getCatalog());
        this.restrictions.setCubeName(_restrictions.getCubeName());
        this.properties = _properties;
        this.levelCardinality = LEVEL_CARDINALITY_NOT_INITIALIZED;
        this.parent = svm;
        this.nodeEnabled = true;
        NodeList nl = rowNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            if (nl.item(i).getNodeName().equals("CATALOG_NAME")) {
                this.catalogName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("CUBE_NAME")) {
                this.cubeName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DIMENSION_UNIQUE_NAME")) {
                this.dimensionUniqueName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("HIERARCHY_UNIQUE_NAME")) {
                this.hierarchyUniqueName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("LEVEL_NAME")) {
                this.levelName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("LEVEL_UNIQUE_NAME")) {
                this.levelUniqueName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("LEVEL_NUMBER")) {
                this.levelNumber = Integer.parseInt(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equals("LEVEL_CAPTION")) {
                this.levelCaption = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (!nl.item(i).getNodeName().equals("LEVEL_CARDINALITY")) continue;
            this.levelCardinality = Integer.parseInt(DOM.getTextFromDOMElement(nl.item(i)));
        }
        if (!this.levelUniqueName.startsWith("[Measures]")) {
            this.restrictions.setLevelUniqueName(this.levelUniqueName);
        }
    }

    @Override
    public DimensionTreeElement[] getChildren(boolean noMatterWhat) {
        DimensionTreeElement[] list = null;
        if (this.levelUniqueName.startsWith("[Measures]")) {
            list = this.parent.getMeasuresList(this.restrictions, this.properties);
        } else if (noMatterWhat && (this.parent.getExpandAllLevels() || this.levelNumber < 1)) {
            list = this.parent.getDimensionTreeMembersList(this.restrictions, this.properties);
        }
        if (list != null) {
            this.levelCardinality = list.length;
        }
        return list;
    }

    @Override
    public String toString() {
        if (this.levelName == null) {
            return I18n.getString("toolTip.notInitialized");
        }
        return this.levelName;
    }

    @Override
    public ImageIcon getIcon() {
        return icon[this.levelNumber];
    }

    @Override
    public String getToolTip() {
        if (this.levelName == null) {
            return I18n.getString("toolTip.notInitialized");
        }
        return "<html>" + I18n.getString("toolTip.levelUniqueName") + this.levelUniqueName + "<br>" + I18n.getString("toolTip.dimensionUniqueName") + this.dimensionUniqueName + "<br>" + I18n.getString("toolTip.hierarchyUniqueName") + this.hierarchyUniqueName + "<br>" + I18n.getString("toolTip.childrenCount") + this.getChildrenCount() + "</html>";
    }

    @Override
    public String[] getPopUpActionList() {
        if (this.isEnabled()) {
            return new String[]{PopUpActions.SEND_TO_COLUMNS, PopUpActions.SEND_TO_ROWS, PopUpActions.SEND_TO_PAGES};
        }
        return null;
    }

    @Override
    public String getUniqueName() {
        return this.levelUniqueName;
    }

    @Override
    public String getCaption() {
        return this.levelCaption;
    }

    @Override
    public String getQueryMembersExpression() {
        return this.levelUniqueName + ".Members";
    }

    @Override
    public boolean isEnabled() {
        return this.nodeEnabled;
    }

    @Override
    public void setEnabled(boolean newValue) {
        this.nodeEnabled = newValue;
    }

    @Override
    public String getHierarchyUniqueName() {
        return this.hierarchyUniqueName;
    }

    @Override
    public String getDimensionUniqueName() {
        return this.dimensionUniqueName;
    }

    public boolean isMeasure() {
        return false;
    }

    @Override
    public int getChildrenCount() {
        if (this.levelCardinality == LEVEL_CARDINALITY_NOT_INITIALIZED) {
            return 2;
        }
        return this.levelCardinality;
    }

    @Override
    public ServerMetadata getServerMetadata() {
        return this.parent;
    }

    @Override
    public XMLADiscoverRestrictions getRestrictions() {
        return this.restrictions;
    }

    @Override
    public XMLADiscoverProperties getProperties() {
        return this.properties;
    }

    @Override
    public void languageChanged(LanguageChangedEvent evt) {
        PopUpActions.popUpCaptions.put(PopUpActions.FLATTEN_DIMENSIONS, I18n.getString("menu.flattenDims"));
        PopUpActions.popUpCaptions.put(PopUpActions.GROUP_HIERARCHIES_BY_DIMENSION, I18n.getString("menu.groupDim"));
        PopUpActions.popUpCaptions.put(PopUpActions.SEND_TO_ROWS, I18n.getString("menu.sendToRows"));
        PopUpActions.popUpCaptions.put(PopUpActions.SEND_TO_COLUMNS, I18n.getString("menu.sendToCols"));
        PopUpActions.popUpCaptions.put(PopUpActions.SEND_TO_MEASURES, I18n.getString("menu.sendToMeasures"));
        PopUpActions.popUpCaptions.put(PopUpActions.SEND_TO_PAGES, I18n.getString("menu.sendToPages"));
    }

    @Override
    public void removeLanguageListener() {
        I18n.removeOnLanguageChangedListener(this);
    }
}

