/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor.mdxbuilder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.EOFException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rex.graphics.mdxeditor.MdxEditor;
import rex.graphics.mdxeditor.mdxbuilder.CanSaveAndResumeState;
import rex.graphics.mdxeditor.mdxbuilder.HandlesMdxEditorSettings;
import rex.graphics.mdxeditor.mdxbuilder.MdxBuilderListener;
import rex.graphics.mdxeditor.mdxbuilder.MdxBuilderToolbar;
import rex.graphics.mdxeditor.mdxbuilder.dnd.MdBuilderTreeDropListener;
import rex.graphics.mdxeditor.mdxbuilder.nodes.DefaultMBTAxisNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.DefaultMBTNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTFromNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTPopUpActions;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTRootNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTWhereNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTWithMembersNode;
import rex.utils.AppColors;
import rex.utils.I18n;

public class MdxBuilderTree
extends JPanel
implements CanSaveAndResumeState {
    JTree tree;
    private MdxBuilderListener listener;
    DefaultMutableTreeNode root;
    protected DefaultTreeModel treeModel;
    JPopupMenu popup;
    private String cubeName;
    private MdxBuilderToolbar toolbar;
    public static String OPEN_MDX_GENERATED_EXPRESSION_TAG = "-- **********  < Mdx generated with MdxBuilder > **********";
    public static String CLOSE_MDX_GENERATED_EXPRESSION_TAG = "-- ********** </ Mdx generated with MdxBuilder > **********";

    public MdxBuilderTree(MdxBuilderListener _listener, HandlesMdxEditorSettings settingsHandler, String _cubeName) {
        this(settingsHandler, _cubeName);
        this.listener = _listener;
    }

    public MdxBuilderTree(HandlesMdxEditorSettings settingsHandler, String _cubeName) {
        this.cubeName = _cubeName;
        this.root = new DefaultMutableTreeNode(new MBTRootNode());
        this.buildFunctionList(this.root);
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        DropTarget dt = new DropTarget(this.tree, new MdBuilderTreeDropListener(this));
        this.tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        JScrollPane treeView = new JScrollPane(this.tree);
        treeView.setPreferredSize(new Dimension(200, 600));
        treeView.setMaximumSize(new Dimension(800, 600));
        this.toolbar = new MdxBuilderToolbar(this, settingsHandler);
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolbar, "North");
        this.add((Component)treeView, "Center");
        MdxBuilderTreeRenderer renderer = new MdxBuilderTreeRenderer(null, null);
        this.tree.setCellRenderer(renderer);
        this.popup = new JPopupMenu();
        this.tree.addMouseListener(new PopupListener());
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public void saveState(OutputStream memStream) {
        this.saveQueryStream(memStream);
    }

    @Override
    public void resumeState(InputStream memStream) {
        this.loadQueryStream(memStream);
    }

    @Override
    public void clearState() {
        this.toolbar.actionToBePerformed();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            ((DefaultMBTNode)((DefaultMutableTreeNode)this.root.getChildAt(i)).getUserObject()).removeAllChildrenFromTheTree((DefaultMutableTreeNode)this.root.getChildAt(i), (DefaultTreeModel)this.tree.getModel());
            ((DefaultTreeModel)this.tree.getModel()).nodeChanged(this.root.getChildAt(i));
        }
        this.tree.repaint();
        this.listener.mdxChanged(this.getMdx());
    }

    protected void saveQueryStream(OutputStream stream) {
        try {
            ObjectOutputStream s = new ObjectOutputStream(stream);
            MBTNode r = (MBTNode)this.root.getUserObject();
            MBTNode[] children = r.getMdxBuilderTreeNodes();
            for (int i = 0; children != null && i < children.length; ++i) {
                this.saveNode(s, children[i]);
            }
            Enumeration<TreePath> enumt = this.tree.getExpandedDescendants(new TreePath(this.root.getPath()));
            while (enumt != null && enumt.hasMoreElements()) {
                TreePath n = enumt.nextElement();
                s.writeObject(n);
            }
            s.flush();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, I18n.getString("msgText.errSave"), I18n.getString("msgTitle.saveQuery"), 0);
            return;
        }
    }

    private void saveNode(ObjectOutputStream s, MBTNode parent) {
        try {
            s.writeObject(parent);
        }
        catch (Exception e) {
            // empty catch block
        }
        MBTNode[] children = parent.getMdxBuilderTreeNodes();
        for (int i = 0; children != null && i < children.length; ++i) {
            this.saveNode(s, children[i]);
        }
    }

    protected void loadQueryStream(InputStream memStream) {
        ArrayList<Object> expandedPaths = new ArrayList<Object>();
        try {
            ObjectInputStream s = new ObjectInputStream(memStream);
            this.root.removeAllChildren();
            ((MBTNode)this.root.getUserObject()).removeAllChildren();
            ((DefaultTreeModel)this.tree.getModel()).nodeChanged(this.root);
            while (true) {
                Object o;
                if ((o = s.readObject()) instanceof TreePath) {
                    expandedPaths.add(o);
                    continue;
                }
                if (!(o instanceof DefaultMBTAxisNode)) continue;
                ((MBTNode)this.root.getUserObject()).addChild((MBTNode)o);
                this.root.add(new DefaultMutableTreeNode(o));
            }
        }
        catch (EOFException e) {
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, I18n.getString("msgText.errLoadingQuery"), I18n.getString("msgTitle.loadingQuery"), 0);
            return;
        }
        ((DefaultTreeModel)this.tree.getModel()).nodeChanged(this.root);
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            this.loadNode((DefaultMutableTreeNode)this.root.getChildAt(i));
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        Enumeration<TreeNode> enumt = this.root.breadthFirstEnumeration();
        while (enumt != null && enumt.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumt.nextElement();
            TreePath tp1 = new TreePath(node.getPath());
            for (int i = 0; i < expandedPaths.size(); ++i) {
                TreePath tp2 = (TreePath)expandedPaths.get(i);
                if (!tp1.toString().equals(tp2.toString())) continue;
                this.tree.expandPath(tp1);
            }
        }
        this.tree.repaint();
        this.listener.mdxChanged(this.getMdx());
    }

    private void loadNode(DefaultMutableTreeNode parent) {
        MBTNode[] children = ((MBTNode)parent.getUserObject()).getMdxBuilderTreeNodes();
        for (int i = 0; children != null && i < children.length; ++i) {
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(children[i]);
            parent.add(newNode);
            this.loadNode(newNode);
        }
    }

    public boolean getSaveStatus() {
        return ((MdxEditor)this.listener).getSaveStatus();
    }

    public void setSaveStatus(boolean bool) {
        ((MdxEditor)this.listener).setSaveStatus(bool);
    }

    public String getFileName() {
        try {
            return ((MdxEditor)this.listener).getFileName();
        }
        catch (Exception exc) {
            return "";
        }
    }

    public void setFileName(String fName) {
        ((MdxEditor)this.listener).setFileName(fName);
    }

    public void newQuery() {
        ((MdxEditor)this.listener).newQuery();
    }

    public void openQuery() {
        ((MdxEditor)this.listener).openQuery();
    }

    public void saveQuery() {
        ((MdxEditor)this.listener).saveQuery();
    }

    private void buildFunctionList(DefaultMutableTreeNode root) {
        MBTWithMembersNode calculatedMembersNode = new MBTWithMembersNode("WITH");
        DefaultMBTAxisNode rowsNode = new DefaultMBTAxisNode("ROWS", true);
        DefaultMBTAxisNode columnsNode = new DefaultMBTAxisNode("COLUMNS", true);
        DefaultMBTAxisNode pagesNode = new DefaultMBTAxisNode("PAGES", true);
        MBTFromNode fromNode = new MBTFromNode(this.cubeName);
        MBTWhereNode whereNode = new MBTWhereNode("WHERE");
        ((MBTNode)root.getUserObject()).addChild(calculatedMembersNode);
        ((MBTNode)root.getUserObject()).addChild(columnsNode);
        ((MBTNode)root.getUserObject()).addChild(rowsNode);
        ((MBTNode)root.getUserObject()).addChild(pagesNode);
        ((MBTNode)root.getUserObject()).addChild(fromNode);
        ((MBTNode)root.getUserObject()).addChild(whereNode);
        root.add(new DefaultMutableTreeNode(calculatedMembersNode));
        root.add(new DefaultMutableTreeNode(columnsNode));
        root.add(new DefaultMutableTreeNode(rowsNode));
        root.add(new DefaultMutableTreeNode(pagesNode));
        root.add(new DefaultMutableTreeNode(fromNode));
        root.add(new DefaultMutableTreeNode(whereNode));
    }

    public void handleDropOnPoint(Point p, Object droppedNode) {
        TreePath path = this.tree.getPathForLocation(p.x, p.y);
        this.tree.setCellRenderer(new MdxBuilderTreeRenderer(null, null));
        if (path != null) {
            this.toolbar.actionToBePerformed();
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            ((MBTNode)currentNode.getUserObject()).handleDrop(droppedNode, currentNode, this.treeModel);
            this.tree.expandPath(path);
            ((DefaultTreeModel)this.tree.getModel()).nodeChanged(currentNode);
            this.tree.repaint();
            this.listener.mdxChanged(this.getMdx());
        }
    }

    public boolean acceptDropOnPoint(Point p, DataFlavor flavor) {
        TreePath path = this.tree.getPathForLocation(p.x, p.y);
        if (path != null) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            MBTNode node = (MBTNode)currentNode.getUserObject();
            boolean acceptDrop = node.acceptDrop(flavor);
            if (acceptDrop) {
                this.tree.setCellRenderer(new MdxBuilderTreeRenderer(node, Color.green));
            } else {
                this.tree.setCellRenderer(new MdxBuilderTreeRenderer(node, Color.red));
            }
            return acceptDrop;
        }
        return false;
    }

    public void clear() {
        this.toolbar.removeLanguageListener();
        ((MBTRootNode)this.root.getUserObject()).removeAllChildren();
    }

    public String getMdx() {
        return ((MBTNode)this.root.getUserObject()).getMdx("");
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Testing MdxBuilderTree...");
        MdxBuilderTree dst = new MdxBuilderTree(null, "Sales");
        frame.setContentPane(dst);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    private class MdxBuilderTreeRenderer
    extends JLabel
    implements TreeCellRenderer {
        private Color color;
        private MBTNode dragOverNode;

        public MdxBuilderTreeRenderer(MBTNode _dragOverNode, Color _color) {
            this.dragOverNode = _dragOverNode;
            this.color = _color;
            this.setOpaque(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            MBTNode node = (MBTNode)((DefaultMutableTreeNode)value).getUserObject();
            this.setText(((Object)node).toString());
            this.setIcon(node.getIcon());
            this.setToolTipText(node.getToolTip());
            if (node.isComplete()) {
                this.setBackground(null);
            } else {
                this.setBackground(AppColors.MBT_NODE_NOT_COMPLETE_BACKGROUND);
            }
            if (node == this.dragOverNode) {
                this.setForeground(this.color);
            } else {
                this.setForeground(Color.black);
            }
            return this;
        }
    }

    private class MdxBuilderTreePopUpActionListener
    implements ActionListener {
        String action;
        DefaultMutableTreeNode actionNode;

        public MdxBuilderTreePopUpActionListener(String _action, DefaultMutableTreeNode _actionNode) {
            this.action = _action;
            this.actionNode = _actionNode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MdxBuilderTree.this.toolbar.actionToBePerformed();
            ((MBTNode)this.actionNode.getUserObject()).handlePopUpAction(this.action, this.actionNode, MdxBuilderTree.this.treeModel);
            ((DefaultTreeModel)MdxBuilderTree.this.tree.getModel()).nodeChanged(this.actionNode);
            MdxBuilderTree.this.tree.repaint();
            MdxBuilderTree.this.listener.mdxChanged(MdxBuilderTree.this.getMdx());
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        private void maybeShowPopup(MouseEvent e) {
            int selRow = MdxBuilderTree.this.tree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = MdxBuilderTree.this.tree.getPathForLocation(e.getX(), e.getY());
            if (selRow != -1 && e.isPopupTrigger()) {
                MdxBuilderTree.this.popup.removeAll();
                DefaultMutableTreeNode actionNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                String[] al = ((MBTNode)actionNode.getUserObject()).getPopUpActionList();
                for (int i = 0; al != null && i < al.length; ++i) {
                    JMenuItem menuItem;
                    String caption = (String)MBTPopUpActions.popUpCaptions.get(al[i]);
                    if (caption == null) {
                        menuItem = new JMenuItem(al[i]);
                        menuItem.addActionListener(new MdxBuilderTreePopUpActionListener(al[i], actionNode));
                        MdxBuilderTree.this.popup.add(menuItem);
                        continue;
                    }
                    if (al[i].equals(MBTPopUpActions.SEPARATOR)) {
                        MdxBuilderTree.this.popup.addSeparator();
                        continue;
                    }
                    if (al[i].equals(MBTPopUpActions.OPEN_SUBMENU)) {
                        JMenu submenu = new JMenu(al[i + 1]);
                        i += 2;
                        while (!al[i].equals(MBTPopUpActions.CLOSE_SUBMENU)) {
                            menuItem = new JMenuItem(al[i]);
                            menuItem.addActionListener(new MdxBuilderTreePopUpActionListener(al[i], actionNode));
                            submenu.add(menuItem);
                            ++i;
                        }
                        MdxBuilderTree.this.popup.add(submenu);
                        continue;
                    }
                    menuItem = new JMenuItem((String)MBTPopUpActions.popUpCaptions.get(al[i]));
                    menuItem.addActionListener(new MdxBuilderTreePopUpActionListener(al[i], actionNode));
                    MdxBuilderTree.this.popup.add(menuItem);
                }
                MdxBuilderTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

