/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.Folds;
import org.netbeans.modules.languages.features.LocalizationSupport;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldManagerFactory;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguagesFoldManager
extends ASTEvaluator
implements FoldManager {
    static final String FOLD = "FOLD";
    private static final int EVALUATING = 0;
    private static final int STOPPED = 1;
    private FoldOperation operation;
    private Document doc;
    private ParserManagerImpl parserManager;
    private int evalState = 1;
    private static FoldType defaultFoldType = new FoldType("default");
    private List<FoldItem> folds;

    public void init(FoldOperation foldOperation) {
        Document document = foldOperation.getHierarchy().getComponent().getDocument();
        if (document instanceof NbEditorDocument) {
            this.doc = document;
            this.operation = foldOperation;
            this.parserManager = ParserManagerImpl.getImpl(this.doc);
            this.parserManager.addASTEvaluator(this);
            this.parserManager.fire(this.parserManager.getState(), null, Collections.singletonMap(FOLD, Collections.singleton(this)), this.parserManager.getAST());
        }
    }

    public void initFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void insertUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void removeUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void changedUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void removeEmptyNotify(Fold fold) {
    }

    public void removeDamagedNotify(Fold fold) {
    }

    public void expandNotify(Fold fold) {
    }

    public void release() {
        if (this.doc != null) {
            this.parserManager.removeASTEvaluator(this);
        }
        this.parserManager = null;
    }

    @Override
    public void beforeEvaluation(ParserManager.State state, ASTNode aSTNode) {
        this.evalState = 0;
        this.folds = null;
    }

    @Override
    public void afterEvaluation(ParserManager.State state, ASTNode aSTNode) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (LanguagesFoldManager.this.operation == null) {
                    LanguagesFoldManager.this.evalState = 1;
                    return;
                }
                FoldHierarchy foldHierarchy = LanguagesFoldManager.this.operation.getHierarchy();
                try {
                    Object object;
                    Object object2;
                    Object object322;
                    Object object4;
                    Fold fold = LanguagesFoldManager.this.operation.getHierarchy().getRootFold();
                    ArrayList arrayList = new ArrayList();
                    LanguagesFoldManager.this.collectFolds(fold, arrayList);
                    List list = LanguagesFoldManager.this.folds != null ? LanguagesFoldManager.this.folds : new ArrayList();
                    HashSet<Object> hashSet = new HashSet<Object>(list.size() / 2);
                    HashSet<Object> hashSet2 = new HashSet<Object>(list.size() / 2);
                    Iterator iterator = list.iterator();
                    Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
                    HashSet<Object> hashSet3 = new HashSet<Object>();
                    while (iterator.hasNext()) {
                        object4 = (FoldItem)iterator.next();
                        int n = Utilities.getLineOffset((BaseDocument)((BaseDocument)LanguagesFoldManager.this.doc), (int)((FoldItem)object4).start);
                        object322 = (FoldItem)hashtable.get(n);
                        if (object322 != null && ((FoldItem)object322).end < ((FoldItem)object4).end) {
                            hashSet3.add(object322);
                        }
                        hashtable.put(n, object4);
                        object2 = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)((FoldItem)object4).start);
                        if (object2 != null) {
                            try {
                                LanguagesFoldManager.this.operation.getExtraInfo((Fold)object2);
                            }
                            catch (IllegalStateException illegalStateException) {
                                object2 = null;
                            }
                        }
                        if (object2 != null && object2.getStartOffset() == ((FoldItem)object4).start && object2.getEndOffset() == ((FoldItem)object4).end) {
                            if (((FoldItem)object4).type == object2.getType() && ((FoldItem)object4).foldName.equals(object2.getDescription())) continue;
                            hashSet2.add(object2);
                            hashSet.add(object4);
                            continue;
                        }
                        hashSet.add(object4);
                    }
                    hashSet.removeAll(hashSet3);
                    arrayList.removeAll(hashSet2);
                    object4 = new Hashtable();
                    for (Object object322 : arrayList) {
                        object2 = list.iterator();
                        boolean bl = false;
                        while (object2.hasNext()) {
                            object = (FoldItem)object2.next();
                            if (object322.getStartOffset() != ((FoldItem)object).start || object322.getEndOffset() != ((FoldItem)object).end) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            hashSet2.add(object322);
                            continue;
                        }
                        int n = Utilities.getLineOffset((BaseDocument)((BaseDocument)LanguagesFoldManager.this.doc), (int)object322.getStartOffset());
                        ((Hashtable)object4).put(n, object322);
                    }
                    object322 = hashSet.iterator();
                    object2 = new HashSet();
                    while (object322.hasNext()) {
                        FoldItem foldItem = (FoldItem)object322.next();
                        object = (Fold)((Hashtable)object4).get(Utilities.getLineOffset((BaseDocument)((BaseDocument)LanguagesFoldManager.this.doc), (int)foldItem.start));
                        if (object == null) continue;
                        if (object.getEndOffset() < foldItem.end) {
                            hashSet2.add(object);
                            continue;
                        }
                        ((HashSet)object2).add(foldItem);
                    }
                    hashSet.removeAll((Collection<?>)object2);
                    ((BaseDocument)LanguagesFoldManager.this.doc).readLock();
                    try {
                        foldHierarchy.lock();
                        try {
                            FoldHierarchyTransaction foldHierarchyTransaction = LanguagesFoldManager.this.operation.openTransaction();
                            try {
                                for (Fold fold2 : hashSet2) {
                                    if (LanguagesFoldManager.this.doc.getLength() == 0) break;
                                    LanguagesFoldManager.this.operation.removeFromHierarchy(fold2, foldHierarchyTransaction);
                                }
                                for (FoldItem foldItem : hashSet) {
                                    if (LanguagesFoldManager.this.doc.getLength() == 0) {
                                        break;
                                    }
                                    if (foldItem.start < 0 || foldItem.end < 0 || foldItem.start >= foldItem.end || foldItem.end > LanguagesFoldManager.this.doc.getLength()) continue;
                                    LanguagesFoldManager.this.operation.addToHierarchy(foldItem.type, foldItem.foldName, false, foldItem.start, foldItem.end, 0, 0, (Object)foldHierarchy, foldHierarchyTransaction);
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                badLocationException.printStackTrace();
                            }
                            finally {
                                foldHierarchyTransaction.commit();
                            }
                        }
                        finally {
                            foldHierarchy.unlock();
                        }
                    }
                    finally {
                        ((BaseDocument)LanguagesFoldManager.this.doc).readUnlock();
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                finally {
                    LanguagesFoldManager.this.evalState = 1;
                }
            }
        });
    }

    private void collectFolds(Fold fold, List<Fold> list) {
        int n = fold.getFoldCount();
        for (int i = 0; i < n; ++i) {
            Fold fold2 = fold.getFold(i);
            try {
                this.operation.getExtraInfo(fold2);
                list.add(fold2);
                this.collectFolds(fold2, list);
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getFeatureName() {
        return FOLD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluate(ParserManager.State state, List<ASTItem> list, Feature feature) {
        Object object;
        Object object2;
        boolean bl;
        int n;
        ASTItem aSTItem = list.get(list.size() - 1);
        int n2 = aSTItem.getOffset();
        int n3 = aSTItem.getEndOffset();
        int n4 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)n2);
        if (n4 == (n = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)n3))) {
            return;
        }
        String string = aSTItem.getMimeType();
        Language language = (Language)aSTItem.getLanguage();
        boolean bl2 = bl = aSTItem instanceof ASTToken && feature == language.getFeatureList().getFeature(FOLD, ((ASTToken)aSTItem).getTypeName());
        if (!bl) {
            object2 = TokenHierarchy.get((Document)this.doc);
            if (this.doc instanceof NbEditorDocument) {
                ((NbEditorDocument)this.doc).readLock();
            }
            try {
                object = object2.tokenSequence();
                object.move(n3 - 1);
                if (!object.moveNext()) {
                    return;
                }
                while (!object.language().mimeType().equals(string)) {
                    if ((object = object.embedded()) == null) {
                        return;
                    }
                    object.move(n3 - 1);
                    if (object.moveNext()) continue;
                    return;
                }
                Token token = object.token();
                Set<Integer> set = language.getAnalyser().getSkipTokenTypes();
                while (set.contains(token.id().ordinal()) && object.movePrevious()) {
                    token = object.token();
                }
                n3 = object.offset() + token.length();
                String string2 = ((Object)token.text()).toString();
                if (string2.endsWith("\n")) {
                    --n3;
                }
                n4 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)n2);
                n = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)n3);
                if (n - n4 < 1) {
                    return;
                }
            }
            finally {
                if (this.doc instanceof NbEditorDocument) {
                    ((NbEditorDocument)this.doc).readUnlock();
                }
            }
        }
        if (feature.hasSingleValue()) {
            object2 = LocalizationSupport.localize(language, (String)feature.getValue(SyntaxContext.create(this.doc, ASTPath.create(list))));
            if (object2 == null) {
                return;
            }
            this.addFold(new FoldItem((String)object2, n2, n3, defaultFoldType));
            return;
        }
        object2 = LocalizationSupport.localize(language, (String)feature.getValue("fold_display_name", SyntaxContext.create(this.doc, ASTPath.create(list))));
        if (object2 == null) {
            object2 = "...";
        }
        object = LocalizationSupport.localize(language, (String)feature.getValue("collapse_type_action_name"));
        this.addFold(new FoldItem((String)object2, n2, n3, Folds.getFoldType((String)object)));
    }

    private void addFold(FoldItem foldItem) {
        if (this.folds == null) {
            this.folds = new CopyOnWriteArrayList<FoldItem>();
        }
        this.folds.add(foldItem);
    }

    void init(Document document) {
        this.doc = document;
        this.operation = null;
        this.parserManager = ParserManagerImpl.getImpl(document);
        this.parserManager.addASTEvaluator(this);
    }

    List<FoldItem> getFolds() {
        return this.folds;
    }

    boolean isEvaluating() {
        return this.evalState == 0;
    }

    public static final class Factory
    implements FoldManagerFactory {
        public FoldManager createFoldManager() {
            return new LanguagesFoldManager();
        }
    }

    static final class FoldItem {
        String foldName;
        int start;
        int end;
        FoldType type;

        FoldItem(String string, int n, int n2, FoldType foldType) {
            this.foldName = string;
            this.start = n;
            this.end = n2;
            this.type = foldType;
        }
    }
}

