/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.MIMEOptionFile;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyBindingsMIMEOptionFile
extends MIMEOptionFile {
    public static final String TAG_ROOT = "bindings";
    public static final String TAG_BIND = "bind";
    public static final String ATTR_KEY = "key";
    public static final String ATTR_ACTION_NAME = "actionName";
    public static final String ATTR_REMOVE = "remove";
    static final String FILENAME = "keybindings";

    public KeyBindingsMIMEOptionFile(BaseOptions baseOptions, Object object) {
        super(baseOptions, object);
    }

    private List getKBList() {
        int n;
        Settings.KitAndValue[] kitAndValueArray = Settings.getValueHierarchy(this.base.getKitClass(), "key-bindings");
        List<MultiKeyBinding> list = null;
        for (n = 0; n < kitAndValueArray.length; ++n) {
            if (kitAndValueArray[n].kitClass != this.base.getKitClass()) continue;
            list = (List)kitAndValueArray[n].value;
        }
        if (list == null) {
            list = new ArrayList();
        }
        n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (e instanceof MultiKeyBinding || e == null) continue;
            JTextComponent.KeyBinding keyBinding = (JTextComponent.KeyBinding)e;
            list.set(i, new MultiKeyBinding(keyBinding.key, keyBinding.actionName));
        }
        return new ArrayList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSettings(boolean bl) {
        assert (false) : "KeyBindingsMIMEOptionFile should not be used anymore. Please file a bug (http://www.netbeans.org/community/issues.html) for editor/settings and attach this stacktrace to it.";
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            Document document = this.dom;
            Element element = document.getDocumentElement();
            if (!TAG_ROOT.equals(element.getTagName())) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            List list = this.getKBList();
            Map<String, MultiKeyBinding> map = OptionUtilities.makeKeyBindingsMap(list);
            this.properties.clear();
            NodeList nodeList = element.getElementsByTagName(TAG_BIND);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Object object = nodeList.item(i);
                Element element2 = (Element)object;
                if (element2 == null) continue;
                String string = element2.getAttribute(ATTR_KEY);
                String string2 = element2.getAttribute(ATTR_REMOVE);
                String string3 = element2.getAttribute(ATTR_ACTION_NAME);
                if (string3 == null) {
                    string3 = "";
                }
                if (string3.length() != 0 && !Boolean.valueOf(string2).booleanValue()) {
                    MultiKeyBinding multiKeyBinding;
                    if (string.indexOf(36) > 0) {
                        multiKeyBinding = new MultiKeyBinding(OptionUtilities.stringToKeys(string), string3);
                        this.properties.put(string, multiKeyBinding);
                        continue;
                    }
                    multiKeyBinding = new MultiKeyBinding(OptionUtilities.stringToKey(string), string3);
                    this.properties.put(string, multiKeyBinding);
                    continue;
                }
                this.properties.put(string, "");
            }
            if (this.properties.size() > 0) {
                map.putAll(this.properties);
                for (Object object : this.properties.keySet()) {
                    if (!(this.properties.get(object) instanceof String)) continue;
                    map.remove(object);
                }
                if (bl) {
                    this.setLoaded(true);
                    this.base.setKeyBindingList(new ArrayList<MultiKeyBinding>(map.values()), false);
                }
            }
            if (bl) {
                this.setLoaded(true);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSettings(Map map) {
        assert (false) : "KeyBindingsMIMEOptionFile should not be used anymore. Please file a bug (http://www.netbeans.org/community/issues.html) for editor/settings and attach this stacktrace to it.";
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            Document document = XMLUtil.createDocument((String)TAG_ROOT, null, (String)this.processor.getPublicID(), (String)this.processor.getSystemID());
            this.properties.putAll(map);
            Element element = document.getDocumentElement();
            ArrayList<String> arrayList = new ArrayList<String>();
            Map<String, MultiKeyBinding> map2 = this.base.getDefaultKeyBindingsMap();
            if (map2 == null) {
                map2 = new HashMap<String, MultiKeyBinding>();
            }
            for (String string : this.properties.keySet()) {
                Object object;
                String string2;
                if (this.properties.get(string) instanceof String) {
                    string2 = KeyBindingsMIMEOptionFile.tryRemoveKeyFromMap(document, this.properties, string, map2, element);
                    if (string2 == null) continue;
                    arrayList.add(string2);
                    string = string2;
                    continue;
                }
                if (!(this.properties.get(string) instanceof MultiKeyBinding)) continue;
                string2 = (MultiKeyBinding)this.properties.get(string);
                String string3 = ((MultiKeyBinding)string2).actionName;
                if (string3 == null) {
                    string3 = "";
                }
                boolean bl = true;
                if (map2.get(string) instanceof MultiKeyBinding) {
                    object = map2.get((Object)string).actionName;
                    boolean bl2 = map2.containsKey(string);
                    if (!bl2) {
                        String[] stringArray = KeyBindingsMIMEOptionFile.getPermutations(string);
                        for (int i = 0; i < stringArray.length && !bl2; ++i) {
                            if (!(bl2 |= map2.containsKey(stringArray[i]))) continue;
                            string = stringArray[i];
                            break;
                        }
                    }
                    if (bl2 && string3.equals(object)) {
                        bl = false;
                    }
                }
                if (!bl) continue;
                object = document.createElement(TAG_BIND);
                object.setAttribute(ATTR_KEY, string);
                object.setAttribute(ATTR_ACTION_NAME, string3);
                element.appendChild((Node)object);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                this.properties.remove(arrayList.get(i));
            }
            document.getDocumentElement().normalize();
            this.saveSettings(document);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static String tryRemoveKeyFromMap(Document document, Map map, String string, Map map2, Element element) {
        if (map2.containsKey(string)) {
            KeyBindingsMIMEOptionFile.removeKeyFromMap(document, map, string, element);
            return string;
        }
        String[] stringArray = KeyBindingsMIMEOptionFile.getPermutations(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!map2.containsKey(stringArray[i])) continue;
            KeyBindingsMIMEOptionFile.removeKeyFromMap(document, map, string, element);
            return stringArray[i];
        }
        return null;
    }

    private static void removeKeyFromMap(Document document, Map map, String string, Element element) {
        Element element2 = document.createElement(TAG_BIND);
        element2.setAttribute(ATTR_KEY, string);
        element2.setAttribute(ATTR_REMOVE, Boolean.TRUE.toString());
        element.appendChild(element2);
    }

    static String[] getPermutations(String string) {
        String[] stringArray;
        String string2 = 4 == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() ? "M" : "C";
        String string3 = "D";
        String string4 = System.getProperty("mrj.version") != null ? "C" : "A";
        String string5 = "O";
        int n = string.lastIndexOf("-");
        if (n == -1) {
            return new String[]{string};
        }
        String string6 = string.substring(n);
        String string7 = Utilities.replaceString((String)string.substring(0, n), (String)"-", (String)"");
        if (string7.length() > 1) {
            StringBuffer stringBuffer;
            HashSet<String> hashSet = new HashSet<String>(string7.length() * string7.length());
            int n2 = string.indexOf(string2);
            if (n2 != -1) {
                stringBuffer = new StringBuffer(string7);
                stringBuffer.replace(n2, n2 + 1, string3);
                hashSet.add(stringBuffer.toString() + string6);
                KeyBindingsMIMEOptionFile.getAllPossibleOrderings(stringBuffer.toString(), string6, hashSet);
                KeyBindingsMIMEOptionFile.createHyphenatedPermutation(stringBuffer.toString().toCharArray(), hashSet, string6);
                n2 = string.indexOf(string4);
                if (n2 != -1) {
                    stringBuffer.replace(n2, n2 + 1, string5);
                    hashSet.add(stringBuffer.toString() + string6);
                    KeyBindingsMIMEOptionFile.getAllPossibleOrderings(stringBuffer.toString(), string6, hashSet);
                    KeyBindingsMIMEOptionFile.createHyphenatedPermutation(stringBuffer.toString().toCharArray(), hashSet, string6);
                } else {
                    n2 = string.indexOf(string5);
                    if (n2 != -1) {
                        stringBuffer.replace(n2, n2 + 1, string4);
                        hashSet.add(stringBuffer.toString() + string6);
                        KeyBindingsMIMEOptionFile.getAllPossibleOrderings(stringBuffer.toString(), string6, hashSet);
                        KeyBindingsMIMEOptionFile.createHyphenatedPermutation(stringBuffer.toString().toCharArray(), hashSet, string6);
                    }
                }
            } else {
                n2 = string.indexOf(string3);
                if (n2 != -1) {
                    stringBuffer = new StringBuffer(string7);
                    stringBuffer.replace(n2, n2 + 1, string2);
                    hashSet.add(stringBuffer.toString() + string6);
                    KeyBindingsMIMEOptionFile.getAllPossibleOrderings(stringBuffer.toString(), string6, hashSet);
                    KeyBindingsMIMEOptionFile.createHyphenatedPermutation(stringBuffer.toString().toCharArray(), hashSet, string6);
                    n2 = string.indexOf(string4);
                    if (n2 != -1) {
                        stringBuffer.replace(n2, n2 + 1, string5);
                        hashSet.add(stringBuffer.toString() + string6);
                        KeyBindingsMIMEOptionFile.getAllPossibleOrderings(stringBuffer.toString(), string6, hashSet);
                    } else {
                        n2 = string.indexOf(string5);
                        if (n2 != -1) {
                            stringBuffer.replace(n2, n2 + 1, string4);
                            hashSet.add(stringBuffer.toString() + string6);
                            KeyBindingsMIMEOptionFile.getAllPossibleOrderings(stringBuffer.toString(), string6, hashSet);
                            KeyBindingsMIMEOptionFile.createHyphenatedPermutation(stringBuffer.toString().toCharArray(), hashSet, string6);
                        }
                    }
                }
            }
            n2 = string.indexOf(string4);
            if (n2 != -1) {
                stringBuffer = new StringBuffer(string7);
                stringBuffer.replace(n2, n2 + 1, string5);
                hashSet.add(stringBuffer.toString() + string6);
                KeyBindingsMIMEOptionFile.getAllPossibleOrderings(stringBuffer.toString(), string6, hashSet);
                KeyBindingsMIMEOptionFile.createHyphenatedPermutation(stringBuffer.toString().toCharArray(), hashSet, string6);
            } else {
                stringBuffer = new StringBuffer(string7);
                n2 = string.indexOf(string5);
                if (n2 != -1) {
                    stringBuffer.replace(n2, n2 + 1, string4);
                    hashSet.add(stringBuffer.toString() + string6);
                    KeyBindingsMIMEOptionFile.getAllPossibleOrderings(stringBuffer.toString(), string6, hashSet);
                    KeyBindingsMIMEOptionFile.createHyphenatedPermutation(stringBuffer.toString().toCharArray(), hashSet, string6);
                }
            }
            KeyBindingsMIMEOptionFile.getAllPossibleOrderings(string7, string6, hashSet);
            KeyBindingsMIMEOptionFile.createHyphenatedPermutation(string7.toCharArray(), hashSet, string6);
            return hashSet.toArray(new String[hashSet.size()]);
        }
        if (string2.equals(string7)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string3 + string6;
        } else if (string4.equals(string7)) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = string5 + string6;
        } else if (string5.equals(string7)) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = string4 + string6;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    static void getAllPossibleOrderings(String string, String string2, Collection collection) {
        char[] cArray = string.toCharArray();
        KeyBindingsMIMEOptionFile.mutate(cArray, collection, 0, string2);
        String[] stringArray = collection.toArray(new String[collection.size()]);
    }

    private static void mutate(char[] cArray, Collection collection, int n, String string) {
        if (n == cArray.length) {
            collection.add(new String(cArray) + string);
            KeyBindingsMIMEOptionFile.createHyphenatedPermutation(cArray, collection, string);
            return;
        }
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            cArray[i] = cArray[n];
            cArray[n] = c;
            if (n >= cArray.length) continue;
            KeyBindingsMIMEOptionFile.mutate(cArray, collection, n + 1, string);
        }
    }

    static void createHyphenatedPermutation(char[] cArray, Collection collection, String string) {
        if (cArray.length == 1) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(new String(cArray));
        for (int i = cArray.length - 1; i >= 1; --i) {
            stringBuffer.insert(i, '-');
        }
        stringBuffer.append(string);
        collection.add(stringBuffer.toString());
    }
}

