/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.export;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.export.ExporterFactory;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.util.prefs.Preferences;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JExcelApiMetadataExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.export.JRXhtmlExporter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.oasis.JROdsExporter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;

public class DefaultExporterFactory
implements ExporterFactory {
    String format = "";

    public DefaultExporterFactory(String format) {
        this.format = format;
    }

    public String getExportFormat() {
        return this.format;
    }

    public String getExporterFileExtension() {
        if (this.format.equals("xhtml") || this.format.equals("layered_html")) {
            return "html";
        }
        if (this.format.equals("xml")) {
            return "jrpxml";
        }
        if (this.format.equals("xls")) {
            return "xls";
        }
        if (this.format.equals("xls2")) {
            return "xls";
        }
        if (this.format.equals("xls3")) {
            return "xls";
        }
        return this.format;
    }

    public JRExporter createExporter() {
        return this.createExporter(null);
    }

    public JRExporter createExporter(JasperReportsContext ctx) {
        SimpleJasperReportsContext context = null;
        if (ctx instanceof SimpleJasperReportsContext) {
            context = (SimpleJasperReportsContext)ctx;
        }
        JRPdfExporter exporter = null;
        if (this.format.equalsIgnoreCase("pdf")) {
            exporter = new JRPdfExporter((JasperReportsContext)context);
            this.configurePdfExporter((JRExporter)exporter, context);
        } else if (this.format.equalsIgnoreCase("csv")) {
            exporter = new JRCsvExporter((JasperReportsContext)context);
            this.configureCsvExporter((JRExporter)exporter, context);
        } else if (this.format.equalsIgnoreCase("html")) {
            exporter = new JRHtmlExporter((JasperReportsContext)context);
            this.configureHtmlExporter((JRExporter)exporter, context);
        } else if (this.format.equalsIgnoreCase("layered_html")) {
            exporter = new HtmlExporter((JasperReportsContext)context);
            this.configureHtmlExporter((JRExporter)exporter, context);
        } else if (this.format.equalsIgnoreCase("xhtml")) {
            exporter = new JRXhtmlExporter((JasperReportsContext)context);
            this.configureXHtmlExporter((JRExporter)exporter, context);
        } else if (this.format.equalsIgnoreCase("xls")) {
            exporter = new JRXlsExporter((JasperReportsContext)context);
            this.configureXlsExporter((JRExporter)exporter, context);
        } else if (this.format.equalsIgnoreCase("xls2")) {
            exporter = new JExcelApiExporter((JasperReportsContext)context);
            this.configureXlsExporter((JRExporter)exporter, context);
        } else if (this.format.equalsIgnoreCase("xls3")) {
            exporter = new JExcelApiMetadataExporter((JasperReportsContext)context);
            this.configureXlsExporter((JRExporter)exporter, context);
        } else if (this.format.equalsIgnoreCase("xlsx")) {
            exporter = new JRXlsxExporter((JasperReportsContext)context);
            this.configureXlsExporter((JRExporter)exporter, context);
        } else if (!this.format.equalsIgnoreCase("java2D")) {
            if (this.format.equalsIgnoreCase("txt")) {
                exporter = new JRTextExporter((JasperReportsContext)context);
                this.configureTextExporter((JRExporter)exporter, context);
            } else if (this.format.equalsIgnoreCase("rtf")) {
                exporter = new JRRtfExporter((JasperReportsContext)context);
            } else if (this.format.equalsIgnoreCase("odt")) {
                exporter = new JROdtExporter((JasperReportsContext)context);
            } else if (this.format.equalsIgnoreCase("ods")) {
                exporter = new JROdsExporter((JasperReportsContext)context);
            } else if (this.format.equalsIgnoreCase("docx")) {
                exporter = new JRDocxExporter((JasperReportsContext)context);
            } else if (this.format.equalsIgnoreCase("xml")) {
                exporter = new JRXmlExporter((JasperReportsContext)context);
                this.configureXmlExporter((JRExporter)exporter, context);
            } else if (this.format.equalsIgnoreCase("pptx")) {
                exporter = new JRPptxExporter((JasperReportsContext)context);
            }
        }
        return exporter;
    }

    public String getExportFormatDisplayName() {
        return I18n.getString("export.format.name." + this.format);
    }

    public String getViewer() {
        if (this.format.equalsIgnoreCase("pdf")) {
            return IReportManager.getInstance().getProperty("ExternalPDFViewer");
        }
        if (this.format.equalsIgnoreCase("csv")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalCSVViewer"), "");
        }
        if (this.format.equalsIgnoreCase("html") || this.format.equalsIgnoreCase("xhtml") || this.format.equals("layered_html")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalHTMLViewer"), "");
        }
        if (this.format.equalsIgnoreCase("xls") || this.format.equalsIgnoreCase("xls2") || this.format.equalsIgnoreCase("xls3") || this.format.equalsIgnoreCase("xlsx")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalXLSViewer"), "");
        }
        if (this.format.equalsIgnoreCase("java2D")) {
            return null;
        }
        if (this.format.equalsIgnoreCase("txt") || this.format.equalsIgnoreCase("xml")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalTXTViewer"), "");
        }
        if (this.format.equalsIgnoreCase("rtf")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalRTFViewer"), "");
        }
        if (this.format.equalsIgnoreCase("odt")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalODFViewer"), "");
        }
        if (this.format.equalsIgnoreCase("ods")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalODSViewer"), "");
        }
        if (this.format.equalsIgnoreCase("docx")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalDOCXViewer"), "");
        }
        if (this.format.equalsIgnoreCase("pptx")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalPPTXViewer"), "");
        }
        return null;
    }

    private void configureTextExporter(JRExporter exporter, SimpleJasperReportsContext context) {
        int val;
        Preferences pref = IReportManager.getPreferences();
        JRPropertiesUtil jrPropUtils = JRPropertiesUtil.getInstance((JasperReportsContext)context);
        float floatVal = pref.getFloat("net.sf.jasperreports.export.text.character.height", 0.0f);
        if (floatVal > 0.0f) {
            context.setValue("net.sf.jasperreports.export.text.character.height", (Object)(floatVal + ""));
        }
        if ((floatVal = pref.getFloat("net.sf.jasperreports.export.text.character.width", 0.0f)) > 0.0f) {
            context.setValue("net.sf.jasperreports.export.text.character.width", (Object)(floatVal + ""));
        }
        if ((val = pref.getInt("net.sf.jasperreports.export.text.page.height", 0)) > 0) {
            context.setValue("net.sf.jasperreports.export.text.page.height", (Object)("" + val));
        }
        if ((val = pref.getInt("net.sf.jasperreports.export.text.page.width", 0)) > 0) {
            context.setValue("net.sf.jasperreports.export.text.page.width", (Object)("" + val));
        }
        String s = null;
        if (pref.getBoolean("net.sf.jasperreports.export.txt.nothingBetweenPages", false)) {
            exporter.setParameter((JRExporterParameter)JRTextExporterParameter.BETWEEN_PAGES_TEXT, (Object)"");
        } else {
            s = pref.get("net.sf.jasperreports.export.txt.betweenPagesText", "");
            if (s.length() > 0) {
                exporter.setParameter((JRExporterParameter)JRTextExporterParameter.BETWEEN_PAGES_TEXT, (Object)s);
            }
        }
        s = pref.get("net.sf.jasperreports.export.txt.lineSeparator", "");
        if (s.length() > 0) {
            exporter.setParameter((JRExporterParameter)JRTextExporterParameter.LINE_SEPARATOR, (Object)s);
        }
    }

    private void configureXlsExporter(JRExporter exporter, SimpleJasperReportsContext context) {
        int row;
        String col;
        Preferences pref = IReportManager.getPreferences();
        JRPropertiesUtil jrPropUtils = JRPropertiesUtil.getInstance((JasperReportsContext)context);
        context.setValue("net.sf.jasperreports.export.xls.create.custom.palette", (Object)pref.getBoolean("net.sf.jasperreports.export.xls.create.custom.palette", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.xls.create.custom.palette")));
        String password = pref.get("net.sf.jasperreports.export.xls.password", jrPropUtils.getProperty("net.sf.jasperreports.export.xls.password"));
        if (password != null && password.length() > 0) {
            context.setValue("net.sf.jasperreports.export.xls.password", (Object)password);
        }
        context.setValue("net.sf.jasperreports.export.xls.collapse.row.span", (Object)pref.getBoolean("net.sf.jasperreports.export.xls.collapse.row.span", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.xls.collapse.row.span")));
        System.out.println("Setting detect cell type to:" + pref.getBoolean("net.sf.jasperreports.export.xls.detect.cell.type", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.xls.detect.cell.type")));
        context.setValue("net.sf.jasperreports.export.xls.detect.cell.type", (Object)pref.getBoolean("net.sf.jasperreports.export.xls.detect.cell.type", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.xls.detect.cell.type")));
        System.out.println("Setting detect cell type to (net.sf.jasperreports.export.xls.detect.cell.type):" + jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.xls.detect.cell.type"));
        context.setValue("net.sf.jasperreports.export.xls.font.size.fix.enabled", (Object)pref.getBoolean("net.sf.jasperreports.export.xls.font.size.fix.enabled", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.xls.font.size.fix.enabled")));
        context.setValue("net.sf.jasperreports.export.xls.ignore.cell.border", (Object)pref.getBoolean("net.sf.jasperreports.export.xls.ignore.cell.border", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.xls.ignore.cell.border")));
        context.setValue("net.sf.jasperreports.export.xls.ignore.cell.background", (Object)pref.getBoolean("net.sf.jasperreports.export.xls.ignore.cell.background", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.xls.ignore.cell.background")));
        context.setValue("net.sf.jasperreports.export.xls.ignore.graphics", (Object)pref.getBoolean("net.sf.jasperreports.export.xls.ignore.graphics", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.xls.ignore.graphics")));
        context.setValue("net.sf.jasperreports.export.xls.image.border.fix.enabled", (Object)pref.getBoolean("net.sf.jasperreports.export.xls.image.border.fix.enabled", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.xls.image.border.fix.enabled")));
        context.setValue("net.sf.jasperreports.export.xls.one.page.per.sheet", (Object)pref.getBoolean("net.sf.jasperreports.export.xls.one.page.per.sheet", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.xls.one.page.per.sheet")));
        context.setValue("net.sf.jasperreports.export.xls.remove.empty.space.between.columns", (Object)pref.getBoolean("net.sf.jasperreports.export.xls.remove.empty.space.between.columns", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.xls.remove.empty.space.between.columns")));
        context.setValue("net.sf.jasperreports.export.xls.remove.empty.space.between.rows", (Object)pref.getBoolean("net.sf.jasperreports.export.xls.remove.empty.space.between.rows", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.xls.remove.empty.space.between.rows")));
        context.setValue("net.sf.jasperreports.export.xls.white.page.background", (Object)pref.getBoolean("net.sf.jasperreports.export.xls.white.page.background", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.xls.white.page.background")));
        int maxRowsPerSheet = pref.getInt("net.sf.jasperreports.export.xls.max.rows.per.sheet", jrPropUtils.getIntegerProperty("net.sf.jasperreports.export.xls.max.rows.per.sheet"));
        if (maxRowsPerSheet > 0) {
            context.setValue("net.sf.jasperreports.export.xls.max.rows.per.sheet", (Object)("" + maxRowsPerSheet));
        }
        if (pref.getBoolean("net.sf.jasperreports.export.xls.useSheetNames", false)) {
            String sheetNames = pref.get("net.sf.jasperreports.export.xls.sheetNames", "");
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.SHEET_NAMES, (Object)sheetNames.split("\n"));
        }
        if ((col = pref.get("net.sf.jasperreports.export.xls.freeze.column", jrPropUtils.getProperty("net.sf.jasperreports.export.xls.freeze.column"))) != null && col.length() > 0) {
            context.setValue("net.sf.jasperreports.export.xls.freeze.column", (Object)("" + col));
        }
        if ((row = pref.getInt("net.sf.jasperreports.export.xls.freeze.row", jrPropUtils.getIntegerProperty("net.sf.jasperreports.export.xls.freeze.row", 0))) > 0) {
            context.setValue("net.sf.jasperreports.export.xls.freeze.row", (Object)("" + row));
        }
    }

    private void configurePdfExporter(JRExporter exporter, SimpleJasperReportsContext context) {
        String pdfaICC;
        String pdfa;
        Preferences pref = IReportManager.getPreferences();
        JRPropertiesUtil jrPropUtils = JRPropertiesUtil.getInstance((JasperReportsContext)context);
        String pdfVersion = pref.get("net.sf.jasperreports.export.pdf.version", null);
        if (pdfVersion != null && pdfVersion.length() == 1) {
            context.setValue("net.sf.jasperreports.export.pdf.version", (Object)("" + pdfVersion.charAt(0)));
        }
        boolean b = pref.getBoolean("net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks"));
        context.setValue("net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks", (Object)new Boolean(b));
        context.setValue("net.sf.jasperreports.export.pdf.compressed", (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.compressed", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.pdf.compressed"))));
        context.setValue("net.sf.jasperreports.export.pdf.force.linebreak.policy", (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.force.linebreak.policy", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.pdf.force.linebreak.policy"))));
        context.setValue("net.sf.jasperreports.export.pdf.force.svg.shapes", (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.force.svg.shapes", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.pdf.force.svg.shapes"))));
        context.setValue("net.sf.jasperreports.export.pdf.tagged", (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.tagged", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.pdf.tagged"))));
        context.setValue("net.sf.jasperreports.export.pdf.encrypted", (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.encrypted", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.pdf.encrypted"))));
        context.setValue("net.sf.jasperreports.export.pdf.128.bit.key", (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.128.bit.key", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.pdf.128.bit.key"))));
        if (pref.get("export.pdf.METADATA_AUTHOR", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_AUTHOR, (Object)pref.get("export.pdf.METADATA_AUTHOR", ""));
        }
        if (pref.get("export.pdf.METADATA_CREATOR", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_CREATOR, (Object)pref.get("export.pdf.METADATA_CREATOR", ""));
        }
        if (pref.get("export.pdf.METADATA_KEYWORDS", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_KEYWORDS, (Object)pref.get("export.pdf.METADATA_KEYWORDS", ""));
        }
        if (pref.get("export.pdf.METADATA_SUBJECT", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_SUBJECT, (Object)pref.get("export.pdf.METADATA_SUBJECT", ""));
        }
        if (pref.get("export.pdf.METADATA_TITLE", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_TITLE, (Object)pref.get("export.pdf.METADATA_TITLE", ""));
        }
        if (pref.get("export.pdf.OWNER_PASSWORD", "").length() > 0) {
            context.setValue("net.sf.jasperreports.export.pdf.owner.password", (Object)pref.get("export.pdf.OWNER_PASSWORD", ""));
        }
        if (pref.get("export.pdf.USER_PASSWORD", "").length() > 0) {
            context.setValue("net.sf.jasperreports.export.pdf.user.password", (Object)pref.get("export.pdf.USER_PASSWORD", ""));
        }
        if (pref.get("export.pdf.TAG_LANGUAGE", jrPropUtils.getProperty("net.sf.jasperreports.export.pdf.tag.language")) != null) {
            context.setValue("net.sf.jasperreports.export.pdf.tag.language", (Object)pref.get("export.pdf.TAG_LANGUAGE", jrPropUtils.getProperty("net.sf.jasperreports.export.pdf.tag.language")));
        }
        if (pref.get("export.pdf.PDF_JAVASCRIPT", jrPropUtils.getProperty("net.sf.jasperreports.export.pdf.javascript")) != null) {
            context.setValue("net.sf.jasperreports.export.pdf.javascript", (Object)pref.get("export.pdf.PDF_JAVASCRIPT", jrPropUtils.getProperty("net.sf.jasperreports.export.pdf.javascript")));
        }
        if (pref.getInt("export.pdf.PERMISSIONS", 0) != 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.PERMISSIONS, (Object)pref.getInt("export.pdf.PERMISSIONS", 0));
        }
        if ((pdfa = pref.get("net.sf.jasperreports.export.pdfa.conformance", jrPropUtils.getProperty(JRPdfExporterParameter.PDFA_CONFORMANCE_NONE))) != null) {
            context.setValue("net.sf.jasperreports.export.pdfa.conformance", (Object)pdfa);
        }
        if ((pdfaICC = pref.get("net.sf.jasperreports.export.pdfa.icc.profile.path", jrPropUtils.getProperty("net.sf.jasperreports.export.pdfa.icc.profile.path"))) != null && !pdfaICC.equals("")) {
            context.setValue("net.sf.jasperreports.export.pdfa.icc.profile.path", (Object)pdfaICC);
        }
    }

    private void configureXHtmlExporter(JRExporter exporter, SimpleJasperReportsContext context) {
        Preferences pref = IReportManager.getPreferences();
        JRPropertiesUtil jrPropUtils = JRPropertiesUtil.getInstance((JasperReportsContext)context);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR, (Object)pref.getBoolean("net.sf.jasperreports.export.html.saveImages", true));
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)pref.getBoolean("net.sf.jasperreports.export.html.white.page.background", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.html.white.page.background")));
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WRAP_BREAK_WORD, (Object)pref.getBoolean("net.sf.jasperreports.export.html.wrap.break.word", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.html.wrap.break.word")));
        if (pref.get("net.sf.jasperreports.export.html.imagesDirectory", "").length() > 0) {
            context.setValue("net.sf.jasperreports.export.html.imagesDirectory", (Object)pref.get("net.sf.jasperreports.export.html.imagesDirectory", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.imagesUri", "").length() > 0) {
            context.setValue("net.sf.jasperreports.export.html.imagesUri", (Object)pref.get("net.sf.jasperreports.export.html.imagesUri", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.htmlHeader", "").length() > 0) {
            context.setValue("net.sf.jasperreports.export.html.htmlHeader", (Object)pref.get("net.sf.jasperreports.export.html.htmlHeader", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.htmlBetweenPages", "").length() > 0) {
            context.setValue("net.sf.jasperreports.export.html.htmlBetweenPages", (Object)pref.get("net.sf.jasperreports.export.html.htmlBetweenPages", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.htmlFooter", "").length() > 0) {
            context.setValue("net.sf.jasperreports.export.html.htmlFooter", (Object)pref.get("net.sf.jasperreports.export.html.htmlFooter", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.size.unit", jrPropUtils.getProperty("net.sf.jasperreports.export.html.size.unit")).length() > 0) {
            context.setValue("net.sf.jasperreports.export.html.size.unit", (Object)pref.get("net.sf.jasperreports.export.html.size.unit", jrPropUtils.getProperty("net.sf.jasperreports.export.html.size.unit")));
        }
    }

    private void configureHtmlExporter(JRExporter exporter, SimpleJasperReportsContext context) {
        Preferences pref = IReportManager.getPreferences();
        JRPropertiesUtil jrPropUtils = JRPropertiesUtil.getInstance((JasperReportsContext)context);
        context.setValue("net.sf.jasperreports.export.html.frames.as.nested.tables", (Object)pref.getBoolean("net.sf.jasperreports.export.html.frames.as.nested.tables", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.html.frames.as.nested.tables")));
        context.setValue("net.sf.jasperreports.export.html.remove.emtpy.space.between.rows", (Object)pref.getBoolean("net.sf.jasperreports.export.html.remove.emtpy.space.between.rows", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.html.remove.emtpy.space.between.rows")));
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR, (Object)pref.getBoolean("net.sf.jasperreports.export.html.saveImages", true));
        context.setValue("net.sf.jasperreports.export.html.using.images.to.align", (Object)pref.getBoolean("net.sf.jasperreports.export.html.using.images.to.align", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.html.using.images.to.align")));
        context.setValue("net.sf.jasperreports.export.html.white.page.background", (Object)pref.getBoolean("net.sf.jasperreports.export.html.white.page.background", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.html.white.page.background")));
        context.setValue("net.sf.jasperreports.export.html.wrap.break.word", (Object)pref.getBoolean("net.sf.jasperreports.export.html.wrap.break.word", jrPropUtils.getBooleanProperty("net.sf.jasperreports.export.html.wrap.break.word")));
        if (pref.get("net.sf.jasperreports.export.html.imagesDirectory", "").length() > 0) {
            context.setValue("net.sf.jasperreports.export.html.imagesDirectory", (Object)pref.get("net.sf.jasperreports.export.html.imagesDirectory", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.imagesUri", "").length() > 0) {
            context.setValue("net.sf.jasperreports.export.html.imagesUri", (Object)pref.get("net.sf.jasperreports.export.html.imagesUri", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.htmlHeader", "").length() > 0) {
            context.setValue("net.sf.jasperreports.export.html.htmlHeader", (Object)pref.get("net.sf.jasperreports.export.html.htmlHeader", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.htmlBetweenPages", "").length() > 0) {
            context.setValue("net.sf.jasperreports.export.html.htmlBetweenPages", (Object)pref.get("net.sf.jasperreports.export.html.htmlBetweenPages", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.htmlFooter", "").length() > 0) {
            context.setValue("net.sf.jasperreports.export.html.htmlFooter", (Object)pref.get("net.sf.jasperreports.export.html.htmlFooter", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.size.unit", jrPropUtils.getProperty("net.sf.jasperreports.export.html.size.unit")).length() > 0) {
            context.setValue("net.sf.jasperreports.export.html.size.unit", (Object)pref.get("net.sf.jasperreports.export.html.size.unit", jrPropUtils.getProperty("net.sf.jasperreports.export.html.size.unit")));
        }
    }

    private void configureCsvExporter(JRExporter exporter, SimpleJasperReportsContext context) {
        Preferences pref = IReportManager.getPreferences();
        JRPropertiesUtil jrPropUtils = JRPropertiesUtil.getInstance((JasperReportsContext)context);
        context.setValue("net.sf.jasperreports.export.csv.field.delimiter", (Object)pref.get("net.sf.jasperreports.export.csv.field.delimiter", jrPropUtils.getProperty("net.sf.jasperreports.export.csv.field.delimiter")));
        context.setValue("net.sf.jasperreports.export.csv.record.delimiter", (Object)pref.get("net.sf.jasperreports.export.csv.record.delimiter", jrPropUtils.getProperty("net.sf.jasperreports.export.csv.record.delimiter")));
    }

    private void configureXmlExporter(JRExporter exporter, SimpleJasperReportsContext context) {
        Preferences pref = IReportManager.getPreferences();
    }
}

