/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.jrtx;

import com.jaspersoft.ireport.designer.jrtx.JRTXDataObject;
import com.jaspersoft.ireport.designer.jrtx.JRTXEditorSupport;
import com.jaspersoft.ireport.designer.jrtx.JRTXVisualView;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.xml.JRXmlTemplateWriter;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class JRTXSourceEditor
extends CloneableEditor
implements MultiViewElement,
Runnable {
    private JComponent toolbar;
    private MultiViewElementCallback callback;

    public JRTXSourceEditor() {
    }

    JRTXSourceEditor(JRTXEditorSupport ed) {
        super((CloneableEditorSupport)ed);
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void componentShowing() {
        super.componentShowing();
        JRSimpleTemplate template = ((JRTXEditorSupport)this.cloneableEditorSupport()).getCurrentModel();
        if (template != null && ((JRTXEditorSupport)this.cloneableEditorSupport()).isModified()) {
            try {
                String content = JRXmlTemplateWriter.writeTemplate((JRTemplate)template, (String)"UTF-8");
                this.getEditorPane().setText(content);
                this.getEditorPane().setCaretPosition(0);
                ((JRTXVisualView)((JRTXEditorSupport)this.cloneableEditorSupport()).descriptions[0]).setNeedModelRefresh(false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ((JRTXEditorSupport)this.cloneableEditorSupport()).setCurrentModel(null);
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            Document doc;
            JEditorPane pane = this.pane;
            if (pane != null && (doc = pane.getDocument()) instanceof NbDocument.CustomToolbar) {
                this.toolbar = ((NbDocument.CustomToolbar)doc).createToolbar(pane);
            }
            if (this.toolbar == null) {
                this.toolbar = new JPanel();
            }
        }
        return this.toolbar;
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.callback = callback;
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentClosed() {
        super.componentClosed();
    }

    public void componentHidden() {
        super.componentHidden();
    }

    public void componentActivated() {
        super.componentActivated();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    public void updateName() {
        Runnable run = new Runnable(){

            public void run() {
                MultiViewElementCallback c = JRTXSourceEditor.this.callback;
                if (c == null) {
                    return;
                }
                TopComponent tc = c.getTopComponent();
                if (tc == null) {
                    return;
                }
                Node nd = ((JRTXDataObject)((JRTXEditorSupport)JRTXSourceEditor.this.cloneableEditorSupport()).getDataObject()).getNodeDelegate();
                tc.setName(nd.getName());
                tc.setDisplayName(nd.getDisplayName());
                tc.setHtmlDisplayName(nd.getHtmlDisplayName());
                tc.setIcon(nd.getIcon(1));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public void run() {
        MultiViewElementCallback c = this.callback;
        if (c == null) {
            return;
        }
        TopComponent tc = c.getTopComponent();
        if (tc == null) {
            return;
        }
        super.updateName();
        Node nd = ((JRTXDataObject)((JRTXEditorSupport)this.cloneableEditorSupport()).getDataObject()).getNodeDelegate();
        tc.setName(nd.getName());
        tc.setDisplayName(nd.getDisplayName());
        tc.setHtmlDisplayName(nd.getHtmlDisplayName());
    }

    public Lookup getLookup() {
        return ((JRTXDataObject)((JRTXEditorSupport)this.cloneableEditorSupport()).getDataObject()).getNodeDelegate().getLookup();
    }
}

