/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties.charts;

import com.jaspersoft.ireport.designer.sheet.properties.FloatProperty;
import com.jaspersoft.ireport.locale.I18n;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;

public final class PlotBackgroundAlphaProperty
extends FloatProperty {
    private final JRBaseChartPlot plot;

    public PlotBackgroundAlphaProperty(JRBaseChartPlot plot) {
        super(plot);
        this.plot = plot;
    }

    public String getName() {
        return "backgroundAlpha";
    }

    public String getDisplayName() {
        return I18n.getString("Background_Alpha_(%)");
    }

    public String getShortDescription() {
        return I18n.getString("Background_Alpha.");
    }

    public Float getFloat() {
        return this.plot.getBackgroundAlphaFloat();
    }

    public Float getOwnFloat() {
        return this.plot.getBackgroundAlphaFloat();
    }

    public Float getDefaultFloat() {
        return null;
    }

    public void setFloat(Float backgroundAlpha) {
        this.plot.setBackgroundAlpha(backgroundAlpha);
    }

    public void validateFloat(Float backgroundAlpha) {
        if (backgroundAlpha != null && (backgroundAlpha.floatValue() < 0.0f || backgroundAlpha.floatValue() > 1.0f)) {
            throw this.annotateException(I18n.getString("The_value_must_be_between_0_and_1."));
        }
    }
}

