/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties.style;

import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.properties.ByteProperty;
import com.jaspersoft.ireport.locale.I18n;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.type.LineSpacingEnum;

public final class LineSpacingProperty
extends ByteProperty {
    private JRBaseStyle style = null;

    public LineSpacingProperty(JRBaseStyle style) {
        super(style);
        this.style = style;
    }

    public String getName() {
        return "lineSpacing";
    }

    public String getDisplayName() {
        return I18n.getString("Global.Property.LineSpacing");
    }

    public String getShortDescription() {
        return I18n.getString("Global.Property.LineSpacingdetail");
    }

    public List getTagList() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(new Tag(LineSpacingEnum.SINGLE.getValueByte(), I18n.getString("Global.Property.Single")));
        tags.add(new Tag(LineSpacingEnum.ONE_AND_HALF.getValueByte(), I18n.getString("Global.Property.1.5")));
        tags.add(new Tag(LineSpacingEnum.DOUBLE.getValueByte(), I18n.getString("Global.Property.Double")));
        tags.add(new Tag(LineSpacingEnum.AT_LEAST.getValueByte(), I18n.getString("Global.Property.LineSpacingAtLeast")));
        tags.add(new Tag(LineSpacingEnum.FIXED.getValueByte(), I18n.getString("Global.Property.LineSpacingFixed")));
        tags.add(new Tag(LineSpacingEnum.PROPORTIONAL.getValueByte(), I18n.getString("Global.Property.LineSpacingProportional")));
        return tags;
    }

    public Byte getByte() {
        return this.style.getParagraph().getLineSpacing() != null ? this.style.getParagraph().getLineSpacing().getValueByte() : null;
    }

    public Byte getOwnByte() {
        return this.style.getParagraph().getOwnLineSpacing() != null ? this.style.getParagraph().getOwnLineSpacing().getValueByte() : null;
    }

    public Byte getDefaultByte() {
        return null;
    }

    public void setByte(Byte lineSpacing) {
        this.style.getParagraph().setLineSpacing(LineSpacingEnum.getByValue((Byte)lineSpacing));
    }
}

