/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties.style;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.type.ModeEnum;
import org.openide.nodes.PropertySupport;

public final class ModeProperty
extends PropertySupport.ReadWrite {
    JRBaseStyle style = null;

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return new Boolean(this.style.getModeValue() != null && this.style.getModeValue() == ModeEnum.OPAQUE);
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val == null || val instanceof Boolean) {
            ModeEnum oldValue = this.style.getOwnModeValue();
            ModeEnum newValue = val == null ? null : ((Boolean)val != false ? ModeEnum.OPAQUE : ModeEnum.TRANSPARENT);
            this.style.setMode(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Mode", ModeEnum.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        return this.style.getOwnModeValue() == null;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public ModeProperty(JRBaseStyle style) {
        super("mode", Boolean.class, I18n.getString("AbstractStyleNode.Property.Opaque"), I18n.getString("AbstractStyleNode.Property.Set"));
        this.style = style;
    }
}

