/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.tools.MultiUnitNumberEditor;
import com.jaspersoft.ireport.designer.tools.PageFormatPreviewPanel;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.utils.PageSize;
import com.jaspersoft.ireport.designer.utils.Unit;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.OrientationEnum;
import org.jdesktop.layout.GroupLayout;

public class PageFormatPanel
extends JPanel {
    JDialog dialog = null;
    private int dialogResult = 2;
    private boolean updating = false;
    private JasperDesign jasperDesign;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JComboBox jComboBox1;
    private JComboBox jComboBoxFormat;
    private JLabel jLabelColumnWidth;
    private JLabel jLabelColumns;
    private JLabel jLabelColumnstitle;
    private JLabel jLabelFormat;
    private JLabel jLabelHeight;
    private JLabel jLabelLeft;
    private JLabel jLabelMarginBottom;
    private JLabel jLabelMarginRight;
    private JLabel jLabelMarginTop;
    private JLabel jLabelMargins;
    private JLabel jLabelOrientation;
    private JLabel jLabelSpace;
    private JLabel jLabelUnit;
    private JLabel jLabelWidth;
    private JPanel jPanel2;
    private JRadioButton jRadioLandscape;
    private JRadioButton jRadioPortrait;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSpinner jSpinnerColumns;
    private MultiUnitNumberEditor multiUnitNumberEditorColumnWidth;
    private MultiUnitNumberEditor multiUnitNumberEditorHeight;
    private MultiUnitNumberEditor multiUnitNumberEditorMarginBottom;
    private MultiUnitNumberEditor multiUnitNumberEditorMarginLeft;
    private MultiUnitNumberEditor multiUnitNumberEditorMarginRight;
    private MultiUnitNumberEditor multiUnitNumberEditorMarginaTop;
    private MultiUnitNumberEditor multiUnitNumberEditorWidth;
    private MultiUnitNumberEditor multiUnitNumberEditorcolumnSpace;
    private PageFormatPreviewPanel pageFormatPreviewPanel1;

    public PageFormatPanel() {
        this.initComponents();
        this.jSpinnerColumns.setModel(new SpinnerNumberModel(1, 1, 1000, 1));
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PageFormatPanel.this.updatePreview();
            }
        };
        ChangeListener changeListener2 = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PageFormatPanel.this.recalculateColumnWidth();
            }
        };
        ChangeListener changeListenerUpdateFormat = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                String format = PageSize.deductPageFormat(PageFormatPanel.this.multiUnitNumberEditorWidth.getValue(), PageFormatPanel.this.multiUnitNumberEditorHeight.getValue());
                boolean oldUp = PageFormatPanel.this.setUpdating(true);
                Misc.setComboboxSelectedTagValue(PageFormatPanel.this.jComboBoxFormat, format);
                PageFormatPanel.this.setUpdating(oldUp);
            }
        };
        this.multiUnitNumberEditorWidth.addChangeListener(changeListener);
        this.multiUnitNumberEditorWidth.addChangeListener(changeListener2);
        this.multiUnitNumberEditorWidth.addChangeListener(changeListenerUpdateFormat);
        this.multiUnitNumberEditorHeight.addChangeListener(changeListener);
        this.multiUnitNumberEditorHeight.addChangeListener(changeListenerUpdateFormat);
        this.multiUnitNumberEditorMarginaTop.addChangeListener(changeListener);
        this.multiUnitNumberEditorMarginBottom.addChangeListener(changeListener);
        this.multiUnitNumberEditorMarginLeft.addChangeListener(changeListener);
        this.multiUnitNumberEditorMarginLeft.addChangeListener(changeListener2);
        this.multiUnitNumberEditorMarginRight.addChangeListener(changeListener);
        this.multiUnitNumberEditorMarginRight.addChangeListener(changeListener2);
        this.multiUnitNumberEditorColumnWidth.addChangeListener(changeListener);
        this.multiUnitNumberEditorColumnWidth.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PageFormatPanel.this.recalculateColumnSpace();
            }
        });
        this.multiUnitNumberEditorcolumnSpace.addChangeListener(changeListener);
        this.multiUnitNumberEditorcolumnSpace.addChangeListener(changeListener2);
        this.jComboBox1.setModel(new DefaultComboBoxModel<Unit>(Unit.getStandardUnits()));
        String unit = IReportManager.getPreferences().get("Unit", "inches");
        int index = Unit.getUnitIndex(unit);
        this.jComboBox1.setSelectedIndex(index);
        this.jComboBoxFormat.addItem(new Tag("Custom", I18n.getString("pageformat.Custom")));
        this.jComboBoxFormat.addItem(new Tag("LETTER", I18n.getString("pageformat.LETTER")));
        this.jComboBoxFormat.addItem(new Tag("NOTE", I18n.getString("pageformat.NOTE")));
        this.jComboBoxFormat.addItem(new Tag("LEGAL", I18n.getString("pageformat.LEGAL")));
        this.jComboBoxFormat.addItem(new Tag("A0", I18n.getString("pageformat.A0")));
        this.jComboBoxFormat.addItem(new Tag("A1", I18n.getString("pageformat.A1")));
        this.jComboBoxFormat.addItem(new Tag("A2", I18n.getString("pageformat.A2")));
        this.jComboBoxFormat.addItem(new Tag("A3", I18n.getString("pageformat.A3")));
        this.jComboBoxFormat.addItem(new Tag("A4", I18n.getString("pageformat.A4")));
        this.jComboBoxFormat.addItem(new Tag("A5", I18n.getString("pageformat.A5")));
        this.jComboBoxFormat.addItem(new Tag("A6", I18n.getString("pageformat.A6")));
        this.jComboBoxFormat.addItem(new Tag("A7", I18n.getString("pageformat.A7")));
        this.jComboBoxFormat.addItem(new Tag("A8", I18n.getString("pageformat.A8")));
        this.jComboBoxFormat.addItem(new Tag("A9", I18n.getString("pageformat.A9")));
        this.jComboBoxFormat.addItem(new Tag("A10", I18n.getString("pageformat.A10")));
        this.jComboBoxFormat.addItem(new Tag("B0", I18n.getString("pageformat.B0")));
        this.jComboBoxFormat.addItem(new Tag("B1", I18n.getString("pageformat.B1")));
        this.jComboBoxFormat.addItem(new Tag("B2", I18n.getString("pageformat.B2")));
        this.jComboBoxFormat.addItem(new Tag("B3", I18n.getString("pageformat.B3")));
        this.jComboBoxFormat.addItem(new Tag("B4", I18n.getString("pageformat.B4")));
        this.jComboBoxFormat.addItem(new Tag("B5", I18n.getString("pageformat.B5")));
        this.jComboBoxFormat.addItem(new Tag("ARCH_E", I18n.getString("pageformat.ARCH_E")));
        this.jComboBoxFormat.addItem(new Tag("ARCH_D", I18n.getString("pageformat.ARCH_D")));
        this.jComboBoxFormat.addItem(new Tag("ARCH_C", I18n.getString("pageformat.ARCH_C")));
        this.jComboBoxFormat.addItem(new Tag("ARCH_B", I18n.getString("pageformat.ARCH_B")));
        this.jComboBoxFormat.addItem(new Tag("ARCH_A", I18n.getString("pageformat.ARCH_A")));
        this.jComboBoxFormat.addItem(new Tag("FLSA", I18n.getString("pageformat.FLSA")));
        this.jComboBoxFormat.addItem(new Tag("FLSE", I18n.getString("pageformat.FLSE")));
        this.jComboBoxFormat.addItem(new Tag("HALFLETTER", I18n.getString("pageformat.HALFLETTER")));
        this.jComboBoxFormat.addItem(new Tag("11x17", I18n.getString("pageformat.11x17")));
        this.jComboBoxFormat.addItem(new Tag("LEDGER", I18n.getString("pageformat.LEDGER")));
        this.jLabelFormat.setText(I18n.getString("PageFormatPanel.jLabelFormat.text"));
        this.jLabelWidth.setText(I18n.getString("PageFormatPanel.jLabelWidth.text"));
        this.jLabelHeight.setText(I18n.getString("PageFormatPanel.jLabelHeight.text"));
        this.jLabelMarginTop.setText(I18n.getString("PageFormatPanel.jLabelMarginTop.text"));
        this.jLabelMarginBottom.setText(I18n.getString("PageFormatPanel.jLabelMarginBottom.text"));
        this.jLabelLeft.setText(I18n.getString("PageFormatPanel.jLabelLeft.text"));
        this.jLabelMarginRight.setText(I18n.getString("PageFormatPanel.jLabelMarginRight.text"));
        this.jLabelMargins.setText(I18n.getString("PageFormatPanel.jLabelMargins.text"));
        this.jRadioPortrait.setText(I18n.getString("PageFormatPanel.jRadioPortrait.text"));
        this.jRadioLandscape.setText(I18n.getString("PageFormatPanel.jRadioLandscape.text"));
        this.jLabelOrientation.setText(I18n.getString("PageFormatPanel.jLabelOrientation.text"));
        this.jButtonCancel.setText(I18n.getString("PageFormatPanel.jButtonCancel.text"));
        this.jLabelUnit.setText(I18n.getString("PageFormatPanel.jLabelUnit.text"));
        this.jLabelColumnstitle.setText(I18n.getString("PageFormatPanel.jLabelColumnstitle.text"));
        this.jLabelColumns.setText(I18n.getString("PageFormatPanel.jLabelColumns.text"));
        this.jLabelColumnWidth.setText(I18n.getString("PageFormatPanel.jLabelColumnWidth.text"));
        this.jLabelSpace.setText(I18n.getString("PageFormatPanel.jLabelSpace.text"));
    }

    public int showDialog(JComponent component, boolean modal) {
        Window obj = null;
        if (component != null && (obj = SwingUtilities.getWindowAncestor(component)) != null) {
            if (obj instanceof Frame) {
                this.dialog = new JDialog((Frame)obj, modal);
            } else if (obj instanceof Dialog) {
                this.dialog = new JDialog((Dialog)obj, modal);
            }
        }
        if (this.dialog == null) {
            this.dialog = new JDialog(Misc.getMainFrame(), modal);
        }
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.getContentPane().add((Component)this, "Center");
        this.setDialogResult(2);
        this.dialog.setTitle("Page format...");
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setMinimumSize(this.dialog.getSize());
        this.dialog.setMaximumSize(this.dialog.getSize());
        this.dialog.setResizable(false);
        this.dialog.setVisible(modal);
        return this.getDialogResult();
    }

    public void setJasperDesign(JasperDesign jd) {
        this.jasperDesign = jd;
        boolean old = this.setUpdating(true);
        this.jSpinnerColumns.setValue(jd.getColumnCount());
        this.multiUnitNumberEditorWidth.setValue(jd.getPageWidth());
        this.multiUnitNumberEditorHeight.setValue(jd.getPageHeight());
        this.multiUnitNumberEditorMarginaTop.setValue(jd.getTopMargin());
        this.multiUnitNumberEditorMarginBottom.setValue(jd.getBottomMargin());
        this.multiUnitNumberEditorMarginLeft.setValue(jd.getLeftMargin());
        this.multiUnitNumberEditorMarginRight.setValue(jd.getRightMargin());
        this.multiUnitNumberEditorColumnWidth.setValue(jd.getColumnWidth());
        this.multiUnitNumberEditorcolumnSpace.setValue(jd.getColumnSpacing());
        this.jRadioLandscape.setSelected(jd.getOrientationValue() == OrientationEnum.LANDSCAPE);
        this.jRadioPortrait.setSelected(jd.getOrientationValue() == OrientationEnum.PORTRAIT);
        Misc.setComboboxSelectedTagValue(this.jComboBoxFormat, PageSize.deductPageFormat(jd.getPageWidth(), jd.getPageHeight()));
        this.setUpdating(old);
        this.updatePreview();
    }

    public void updatePreview() {
        int cols = ((Number)this.jSpinnerColumns.getValue()).intValue();
        this.pageFormatPreviewPanel1.setPageWidth(this.multiUnitNumberEditorWidth.getValue());
        this.pageFormatPreviewPanel1.setPageHeight(this.multiUnitNumberEditorHeight.getValue());
        this.pageFormatPreviewPanel1.setMarginBottom(this.multiUnitNumberEditorMarginBottom.getValue());
        this.pageFormatPreviewPanel1.setMarginLeft(this.multiUnitNumberEditorMarginLeft.getValue());
        this.pageFormatPreviewPanel1.setMarginRight(this.multiUnitNumberEditorMarginRight.getValue());
        this.pageFormatPreviewPanel1.setMarginTop(this.multiUnitNumberEditorMarginaTop.getValue());
        this.pageFormatPreviewPanel1.setColumns(cols);
        this.pageFormatPreviewPanel1.setColumnSpace(this.multiUnitNumberEditorcolumnSpace.getValue());
        this.pageFormatPreviewPanel1.setColumnWidth(this.multiUnitNumberEditorColumnWidth.getValue());
        this.pageFormatPreviewPanel1.repaint();
    }

    public void applyChanges(JasperDesign jd) {
        int cols = ((Number)this.jSpinnerColumns.getValue()).intValue();
        jd.setPageWidth(this.multiUnitNumberEditorWidth.getValue());
        jd.setPageHeight(this.multiUnitNumberEditorHeight.getValue());
        jd.setBottomMargin(this.multiUnitNumberEditorMarginBottom.getValue());
        jd.setLeftMargin(this.multiUnitNumberEditorMarginLeft.getValue());
        jd.setRightMargin(this.multiUnitNumberEditorMarginRight.getValue());
        jd.setTopMargin(this.multiUnitNumberEditorMarginaTop.getValue());
        jd.setColumnCount(cols);
        jd.setColumnSpacing(this.multiUnitNumberEditorcolumnSpace.getValue());
        jd.setColumnWidth(this.multiUnitNumberEditorColumnWidth.getValue());
        jd.setOrientation(this.jRadioLandscape.isSelected() ? OrientationEnum.LANDSCAPE : OrientationEnum.PORTRAIT);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabelFormat = new JLabel();
        this.jComboBoxFormat = new JComboBox();
        this.jLabelWidth = new JLabel();
        this.jLabelHeight = new JLabel();
        this.jLabelMarginTop = new JLabel();
        this.jLabelMarginBottom = new JLabel();
        this.jLabelLeft = new JLabel();
        this.jLabelMarginRight = new JLabel();
        this.jLabelMargins = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jRadioPortrait = new JRadioButton();
        this.jRadioLandscape = new JRadioButton();
        this.jLabelOrientation = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jPanel2 = new JPanel();
        this.jSeparator2 = new JSeparator();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabelUnit = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.multiUnitNumberEditorWidth = new MultiUnitNumberEditor();
        this.multiUnitNumberEditorHeight = new MultiUnitNumberEditor();
        this.multiUnitNumberEditorMarginaTop = new MultiUnitNumberEditor();
        this.multiUnitNumberEditorMarginBottom = new MultiUnitNumberEditor();
        this.multiUnitNumberEditorMarginLeft = new MultiUnitNumberEditor();
        this.multiUnitNumberEditorMarginRight = new MultiUnitNumberEditor();
        this.jLabelColumnstitle = new JLabel();
        this.jSeparator4 = new JSeparator();
        this.jLabelColumns = new JLabel();
        this.jSpinnerColumns = new JSpinner();
        this.multiUnitNumberEditorColumnWidth = new MultiUnitNumberEditor();
        this.jLabelColumnWidth = new JLabel();
        this.multiUnitNumberEditorcolumnSpace = new MultiUnitNumberEditor();
        this.jLabelSpace = new JLabel();
        this.pageFormatPreviewPanel1 = new PageFormatPreviewPanel();
        this.jLabelFormat.setText("Format");
        this.jComboBoxFormat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PageFormatPanel.this.jComboBoxFormatActionPerformed(evt);
            }
        });
        this.jLabelWidth.setText("Width");
        this.jLabelHeight.setText("Height");
        this.jLabelMarginTop.setText("Top");
        this.jLabelMarginBottom.setText("Bottom");
        this.jLabelLeft.setText("Left");
        this.jLabelMarginRight.setText("Right");
        this.jLabelMargins.setText("Margins");
        this.buttonGroup1.add(this.jRadioPortrait);
        this.jRadioPortrait.setSelected(true);
        this.jRadioPortrait.setText("Portrait");
        this.jRadioPortrait.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PageFormatPanel.this.jRadioPortraitActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioLandscape);
        this.jRadioLandscape.setText("Landscape");
        this.jRadioLandscape.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PageFormatPanel.this.jRadioLandscapeActionPerformed(evt);
            }
        });
        this.jLabelOrientation.setText("Page orientation");
        this.jButtonOk.setText("Ok");
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PageFormatPanel.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PageFormatPanel.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabelUnit.setText("Unit");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PageFormatPanel.this.jComboBox1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabelUnit).addPreferredGap(0).add((Component)this.jComboBox1, -2, -1, -2).addPreferredGap(0, 263, Short.MAX_VALUE).add((Component)this.jButtonOk).addPreferredGap(0).add((Component)this.jButtonCancel)).add(2, (Component)this.jSeparator2, -1, 458, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jSeparator2, -1, 10, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(0, 0, 0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOk))).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabelUnit).add((Component)this.jComboBox1, -2, -1, -2)))).addContainerGap()));
        this.jLabelColumnstitle.setText("Columns");
        this.jLabelColumns.setText("Columns");
        this.jSpinnerColumns.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                PageFormatPanel.this.jSpinnerColumnsStateChanged(evt);
            }
        });
        this.multiUnitNumberEditorColumnWidth.setEnabled(false);
        this.jLabelColumnWidth.setText("Column width");
        this.multiUnitNumberEditorcolumnSpace.setEnabled(false);
        this.jLabelSpace.setText("Space");
        GroupLayout pageFormatPreviewPanel1Layout = new GroupLayout((Container)this.pageFormatPreviewPanel1);
        this.pageFormatPreviewPanel1.setLayout((LayoutManager)pageFormatPreviewPanel1Layout);
        pageFormatPreviewPanel1Layout.setHorizontalGroup((GroupLayout.Group)pageFormatPreviewPanel1Layout.createParallelGroup(1).add(0, 235, Short.MAX_VALUE));
        pageFormatPreviewPanel1Layout.setVerticalGroup((GroupLayout.Group)pageFormatPreviewPanel1Layout.createParallelGroup(1).add(0, 186, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelMarginBottom).add((Component)this.jLabelLeft).add((Component)this.jLabelMarginTop).add((Component)this.jLabelMarginRight)).add(6, 6, 6).add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.multiUnitNumberEditorMarginRight, -2, 165, -2).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.multiUnitNumberEditorMarginaTop, -1, 165, Short.MAX_VALUE).add((Component)this.multiUnitNumberEditorMarginBottom, -1, -1, Short.MAX_VALUE).add((Component)this.multiUnitNumberEditorMarginLeft, -1, -1, Short.MAX_VALUE))).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelColumnWidth).add((Component)this.jLabelColumns).add((Component)this.jLabelSpace)).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jSpinnerColumns, -2, 48, -2).add((Component)this.multiUnitNumberEditorColumnWidth, -1, 167, Short.MAX_VALUE).add((Component)this.multiUnitNumberEditorcolumnSpace, -1, -1, Short.MAX_VALUE))).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelMargins).add((Component)this.jSeparator1, -2, 205, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelColumnstitle).add((Component)this.jSeparator4, -2, 235, -2))).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jRadioLandscape).add((Component)this.jRadioPortrait).add((Component)this.jSeparator3, -2, 205, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelFormat).add((Component)this.jLabelWidth).add((Component)this.jLabelHeight)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.multiUnitNumberEditorWidth, -1, -1, Short.MAX_VALUE).add((Component)this.multiUnitNumberEditorHeight, -1, -1, Short.MAX_VALUE).add((Component)this.jComboBoxFormat, -2, 167, -2))).add((Component)this.jLabelOrientation)).add(18, 18, 18).add((Component)this.pageFormatPreviewPanel1, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelFormat).add((Component)this.jComboBoxFormat, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.multiUnitNumberEditorWidth, -2, -1, -2).add((Component)this.jLabelWidth)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabelHeight).add((Component)this.multiUnitNumberEditorHeight, -2, -1, -2)).add(24, 24, 24).add((Component)this.jLabelOrientation).add(2, 2, 2).add((Component)this.jSeparator3, -2, 10, -2).addPreferredGap(0).add((Component)this.jRadioPortrait).addPreferredGap(0).add((Component)this.jRadioLandscape).add(27, 27, 27)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pageFormatPreviewPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(1))).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelMargins).add((Component)this.jLabelColumnstitle)).add(2, 2, 2).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jSeparator1, -2, 10, -2).add(0, 0, 0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabelMarginTop).add((Component)this.multiUnitNumberEditorMarginaTop, -2, -1, -2))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jSeparator4, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelColumns).add((Component)this.jSpinnerColumns, -2, -1, -2)))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabelMarginBottom).add((Component)this.multiUnitNumberEditorMarginBottom, -2, -1, -2).add((Component)this.jLabelColumnWidth).add((Component)this.multiUnitNumberEditorColumnWidth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabelLeft).add((Component)this.multiUnitNumberEditorMarginLeft, -2, -1, -2).add((Component)this.jLabelSpace).add((Component)this.multiUnitNumberEditorcolumnSpace, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabelMarginRight).add((Component)this.multiUnitNumberEditorMarginRight, -2, -1, -2)).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2)));
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setDialogResult(2);
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        this.setDialogResult(0);
        this.applyChanges(this.jasperDesign);
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private void jRadioLandscapeActionPerformed(ActionEvent evt) {
        this.updateOrientation();
    }

    private void jRadioPortraitActionPerformed(ActionEvent evt) {
        this.updateOrientation();
    }

    private void jSpinnerColumnsStateChanged(ChangeEvent evt) {
        int cols = ((Number)this.jSpinnerColumns.getValue()).intValue();
        if (cols > 1) {
            this.multiUnitNumberEditorcolumnSpace.setEnabled(true);
            this.multiUnitNumberEditorColumnWidth.setEnabled(true);
        } else {
            this.multiUnitNumberEditorcolumnSpace.setEnabled(false);
            this.multiUnitNumberEditorColumnWidth.setEnabled(false);
        }
        this.recalculateColumnWidth();
        this.updatePreview();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        Unit unit = (Unit)this.jComboBox1.getSelectedItem();
        this.multiUnitNumberEditorWidth.setSelectedUnit(unit);
        this.multiUnitNumberEditorHeight.setSelectedUnit(unit);
        this.multiUnitNumberEditorMarginaTop.setSelectedUnit(unit);
        this.multiUnitNumberEditorMarginBottom.setSelectedUnit(unit);
        this.multiUnitNumberEditorMarginLeft.setSelectedUnit(unit);
        this.multiUnitNumberEditorMarginRight.setSelectedUnit(unit);
        this.multiUnitNumberEditorColumnWidth.setSelectedUnit(unit);
        this.multiUnitNumberEditorcolumnSpace.setSelectedUnit(unit);
    }

    private void jComboBoxFormatActionPerformed(ActionEvent evt) {
        Point p;
        if (this.isUpdating()) {
            return;
        }
        Tag t = (Tag)this.jComboBoxFormat.getSelectedItem();
        if (!t.getValue().equals("Custom") && (p = PageSize.getFormatSize("" + t.getValue())) != null) {
            if (this.jRadioLandscape.isSelected()) {
                this.multiUnitNumberEditorWidth.setValue(p.y);
                this.multiUnitNumberEditorHeight.setValue(p.x);
            } else {
                this.multiUnitNumberEditorWidth.setValue(p.x);
                this.multiUnitNumberEditorHeight.setValue(p.y);
            }
        }
        this.recalculateColumnWidth();
        this.updatePreview();
    }

    public void recalculateColumnWidth() {
        int available = this.multiUnitNumberEditorWidth.getValue() - this.multiUnitNumberEditorMarginLeft.getValue() - this.multiUnitNumberEditorMarginRight.getValue();
        int cols = ((Number)this.jSpinnerColumns.getValue()).intValue();
        if (cols <= 1) {
            this.multiUnitNumberEditorcolumnSpace.setValue(0);
            this.multiUnitNumberEditorColumnWidth.setValue(available);
            return;
        }
        int maxColSpace = available / (cols - 1);
        if ((available -= this.multiUnitNumberEditorcolumnSpace.getValue() * (cols - 1)) < 0) {
            this.multiUnitNumberEditorcolumnSpace.setValue(maxColSpace);
            this.multiUnitNumberEditorColumnWidth.setValue(0);
        } else {
            this.multiUnitNumberEditorColumnWidth.setValue(available / cols);
        }
    }

    public void recalculateColumnSpace() {
        int available = this.multiUnitNumberEditorWidth.getValue() - this.multiUnitNumberEditorMarginLeft.getValue() - this.multiUnitNumberEditorMarginRight.getValue();
        int cols = ((Number)this.jSpinnerColumns.getValue()).intValue();
        if (cols <= 1) {
            return;
        }
        int maxColWidth = available / cols;
        if ((available -= this.multiUnitNumberEditorColumnWidth.getValue() * cols) < 0) {
            this.multiUnitNumberEditorcolumnSpace.setValue(0);
            this.multiUnitNumberEditorColumnWidth.setValue(maxColWidth);
        } else {
            this.multiUnitNumberEditorcolumnSpace.setValue(available / (cols - 1));
        }
        this.updatePreview();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    private void updateOrientation() {
        int w = this.multiUnitNumberEditorWidth.getValue();
        int h = this.multiUnitNumberEditorHeight.getValue();
        if (this.jRadioLandscape.isSelected()) {
            this.multiUnitNumberEditorWidth.setValue(Math.max(w, h));
            this.multiUnitNumberEditorHeight.setValue(Math.min(w, h));
        } else {
            this.multiUnitNumberEditorWidth.setValue(Math.min(w, h));
            this.multiUnitNumberEditorHeight.setValue(Math.max(w, h));
        }
        this.recalculateColumnWidth();
        this.updatePreview();
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public boolean setUpdating(boolean updating) {
        boolean b = this.updating;
        this.updating = updating;
        return b;
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }
}

