/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.utils;

import bsh.EvalError;
import bsh.Interpreter;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRStringUtil;
import org.openide.util.Exceptions;

public class ExpressionInterpreter {
    JRDesignDataset dataset = null;
    Interpreter interpreter = null;
    JasperDesign jasperDesign = null;
    private boolean convertNullParams = false;

    public ExpressionInterpreter(JRDesignDataset dataset, ClassLoader classLoader) {
        this(dataset, classLoader, null);
    }

    public ExpressionInterpreter(JRDesignDataset dataset, ClassLoader classLoader, JasperDesign jasperDesign) {
        try {
            this.dataset = dataset;
            this.jasperDesign = jasperDesign;
            if (jasperDesign == null && IReportManager.getInstance().getActiveReport() != null) {
                jasperDesign = IReportManager.getInstance().getActiveReport();
            }
            this.prepareExpressionEvaluator(classLoader);
        }
        catch (EvalError ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public Object interpretExpression(String expression) {
        try {
            if (this.interpreter == null) {
                return null;
            }
            ArrayList queryParams = new ArrayList();
            Iterator iterParams = null;
            if (this.dataset != null) {
                iterParams = this.dataset.getParametersList().iterator();
            }
            while (iterParams != null && iterParams.hasNext()) {
                Object defValue;
                JRDesignParameter parameter = (JRDesignParameter)iterParams.next();
                String p1 = "$P{" + parameter.getName() + "}";
                int ip1 = expression.indexOf(p1);
                if (ip1 < 0) continue;
                if (parameter.getDefaultValueExpression() != null && !parameter.getDefaultValueExpression().equals("")) {
                    String expText = "";
                    if (parameter.getDefaultValueExpression() != null) {
                        expText = parameter.getDefaultValueExpression().getText();
                    }
                    defValue = ExpressionInterpreter.recursiveInterpreter(this.interpreter, expText, this.dataset.getParametersList(), 0, parameter.getName());
                } else {
                    defValue = null;
                    if (this.isConvertNullParams() && parameter.getValueClassName().equals("java.lang.String")) {
                        defValue = "";
                    }
                }
                while (ip1 != -1) {
                    String before = expression.substring(0, ip1);
                    String after = expression.substring(ip1 + p1.length());
                    String param_name_literal = "param_" + JRStringUtil.getJavaIdentifier((String)parameter.getName());
                    expression = before + param_name_literal + after;
                    this.interpreter.set(param_name_literal, defValue);
                    ip1 = expression.indexOf(p1);
                }
            }
            return this.interpreter.eval(expression);
        }
        catch (EvalError evalError) {
            return null;
        }
    }

    private void prepareExpressionEvaluator(ClassLoader cl) throws EvalError {
        this.interpreter = new Interpreter();
        if (cl != null) {
            this.interpreter.setClassLoader(cl);
        }
        this.interpreter.eval("String tmp;");
        List<String> paths = IReportManager.getInstance().getClasspath();
        for (String path : paths) {
            this.interpreter.set("tmp", (Object)path);
            this.interpreter.eval("addClassPath(tmp);");
        }
        this.interpreter.eval("import net.sf.jasperreports.engine.*;");
        this.interpreter.eval("import net.sf.jasperreports.engine.fill.*;");
        this.interpreter.eval("import java.util.*;");
        this.interpreter.eval("import java.math.*;");
        this.interpreter.eval("import java.text.*;");
        this.interpreter.eval("import java.io.*;");
        this.interpreter.eval("import java.net.*;");
        this.interpreter.eval("import java.util.*;");
        this.interpreter.eval("import net.sf.jasperreports.engine.*;");
        this.interpreter.eval("import net.sf.jasperreports.engine.data.*;");
        if (this.jasperDesign != null) {
            String[] imports = this.jasperDesign.getImports();
            for (int i = 0; imports != null && i < imports.length; ++i) {
                this.interpreter.eval("import " + imports[i] + ";");
            }
        }
    }

    public static Object recursiveInterpreter(Interpreter interpreter, String expression, List parameters) throws EvalError {
        return ExpressionInterpreter.recursiveInterpreter(interpreter, expression, parameters, 0);
    }

    public static Object recursiveInterpreter(Interpreter interpreter, String expression, List parameters, int recursion_level) throws EvalError {
        return ExpressionInterpreter.recursiveInterpreter(interpreter, expression, parameters, 0, null);
    }

    public static Object recursiveInterpreter(Interpreter interpreter, String expression, List parameters, int recursion_level, String this_param_name) throws EvalError {
        ++recursion_level;
        if (expression == null || expression.length() == 0) {
            return null;
        }
        if (recursion_level > 100) {
            return null;
        }
        if (expression != null && expression.trim().length() > 0) {
            while (expression.indexOf("$P{") >= 0) {
                int start_index = expression.indexOf("$P{") + 3;
                String param_name = expression.substring(start_index, expression.indexOf("}", start_index));
                String param_expression = "";
                for (int i = 0; i < parameters.size(); ++i) {
                    JRDesignParameter p = (JRDesignParameter)parameters.get(i);
                    if (!p.getName().equals(param_name)) continue;
                    param_expression = p.getDefaultValueExpression().getText();
                    break;
                }
                String param_name_literal = "param_" + JRStringUtil.getJavaIdentifier((String)param_name);
                expression = Misc.string_replace(param_name_literal, "$P{" + param_name + "}", expression);
                if (interpreter.get(param_name_literal) != null) continue;
                Object paramValue = ExpressionInterpreter.recursiveInterpreter(interpreter, param_expression, parameters, recursion_level, this_param_name);
                interpreter.set(param_name_literal, paramValue);
            }
            String this_param_name_literal = "param_unknow";
            if (this_param_name != null) {
                this_param_name_literal = "param_" + JRStringUtil.getJavaIdentifier((String)this_param_name);
            }
            Object res = interpreter.eval(expression);
            interpreter.set(this_param_name_literal, res);
            return res;
        }
        return null;
    }

    public boolean isConvertNullParams() {
        return this.convertNullParams;
    }

    public void setConvertNullParams(boolean convertNullParams) {
        this.convertNullParams = convertNullParams;
    }
}

