/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasper;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.jdesktop.layout.GroupLayout;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class ConvertJasperJrxmlDialog
extends JDialog {
    private String jasperFile = null;
    private String jrxmlFile = null;
    private JButton jButtonBrowse;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JCheckBox jCheckBoxAtTheEnd;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelError;
    private JSeparator jSeparator1;
    private JTextField jTextFieldDestination;

    public ConvertJasperJrxmlDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jTextFieldDestination.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ConvertJasperJrxmlDialog.this.checkFile();
            }

            public void removeUpdate(DocumentEvent e) {
                ConvertJasperJrxmlDialog.this.checkFile();
            }

            public void changedUpdate(DocumentEvent e) {
                ConvertJasperJrxmlDialog.this.checkFile();
            }
        });
        this.setLocationRelativeTo(null);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldDestination = new JTextField();
        this.jCheckBoxAtTheEnd = new JCheckBox();
        this.jButtonBrowse = new JButton();
        this.jLabel3 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonOk = new JButton();
        this.jLabelError = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText(NbBundle.getMessage(ConvertJasperJrxmlDialog.class, (String)"ConvertJasperJrxmlDialog.jLabel1.text"));
        this.jLabel1.setVerticalAlignment(1);
        this.jLabel2.setText(NbBundle.getMessage(ConvertJasperJrxmlDialog.class, (String)"ConvertJasperJrxmlDialog.jLabel2.text"));
        this.jTextFieldDestination.setText(NbBundle.getMessage(ConvertJasperJrxmlDialog.class, (String)"ConvertJasperJrxmlDialog.jTextFieldDestination.text"));
        this.jCheckBoxAtTheEnd.setSelected(true);
        this.jCheckBoxAtTheEnd.setText(NbBundle.getMessage(ConvertJasperJrxmlDialog.class, (String)"ConvertJasperJrxmlDialog.jCheckBoxAtTheEnd.text"));
        this.jButtonBrowse.setText(NbBundle.getMessage(ConvertJasperJrxmlDialog.class, (String)"ConvertJasperJrxmlDialog.jButtonBrowse.text"));
        this.jButtonBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConvertJasperJrxmlDialog.this.jButtonBrowseActionPerformed(evt);
            }
        });
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/convert_jasper_jrxml.png")));
        this.jLabel3.setText(NbBundle.getMessage(ConvertJasperJrxmlDialog.class, (String)"ConvertJasperJrxmlDialog.jLabel3.text"));
        this.jButtonCancel.setText(NbBundle.getMessage(ConvertJasperJrxmlDialog.class, (String)"ConvertJasperJrxmlDialog.jButtonCancel.text"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConvertJasperJrxmlDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOk.setText(NbBundle.getMessage(ConvertJasperJrxmlDialog.class, (String)"ConvertJasperJrxmlDialog.jButtonOk.text"));
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConvertJasperJrxmlDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        this.jLabelError.setForeground(new Color(204, 0, 0));
        this.jLabelError.setText(NbBundle.getMessage(ConvertJasperJrxmlDialog.class, (String)"ConvertJasperJrxmlDialog.jLabelError.text"));
        this.jLabelError.setVerticalAlignment(3);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1, -1, 412, Short.MAX_VALUE).add((Component)this.jLabelError, -1, 412, Short.MAX_VALUE).add((Component)this.jCheckBoxAtTheEnd).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jLabel2).add((Component)this.jTextFieldDestination, -1, 327, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jButtonBrowse))).addContainerGap()).add((Component)this.jSeparator1, -1, 632, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(480, Short.MAX_VALUE).add((Component)this.jButtonOk).addPreferredGap(0).add((Component)this.jButtonCancel).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1, -2, 46, -2).add(28, 28, 28).add((Component)this.jLabel2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonBrowse).add((Component)this.jTextFieldDestination, -2, -1, -2)).addPreferredGap(1).add((Component)this.jCheckBoxAtTheEnd).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabelError, -2, 39, -2)).add((Component)this.jLabel3)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOk)).addContainerGap()));
        this.pack();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        try {
            File newFile = new File(this.jTextFieldDestination.getText());
            if (newFile.exists() && JOptionPane.showConfirmDialog(Misc.getMainFrame(), I18n.getString("LBL_File_Exists", (Object)newFile.getName()), NbBundle.getMessage(DataObject.class, (String)"CTL_SaveAsAction"), 0, 2) != 0) {
                return;
            }
            JasperReport report = (JasperReport)JRLoader.loadObject((File)new File(this.jasperFile));
            JRXmlWriter.writeReport((JRReport)report, (OutputStream)new FileOutputStream(newFile), (String)"UTF-8");
            if (this.jCheckBoxAtTheEnd.isSelected()) {
                FileObject obj = FileUtil.toFileObject((File)newFile);
                final DataObject dataObj = DataObject.find((FileObject)obj);
                if (dataObj != null && dataObj.getCookie(OpenCookie.class) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ((OpenCookie)dataObj.getCookie(OpenCookie.class)).open();
                        }
                    });
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(Misc.getMainFrame(), I18n.getString("ConvertJasperJrxmlDialog.fileConverted"), "", 1);
                    }
                });
            }
        }
        catch (Throwable t) {
            this.jLabelError.setText("<html>" + I18n.getString("ConvertJasperJrxmlDialog.errorOnConversion", (Object)t.getMessage()));
            t.printStackTrace();
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser(IReportManager.getInstance().getCurrentDirectory());
        jfc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.toLowerCase().endsWith(".jrxml") || file.isDirectory();
            }

            public String getDescription() {
                return "JRXML *.jrxml";
            }
        });
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            File file = jfc.getSelectedFile();
            try {
                this.jTextFieldDestination.setText(file.getAbsolutePath());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public String getJasperFile() {
        return this.jasperFile;
    }

    public void checkFile() {
        this.jLabelError.setText("");
        this.jButtonOk.setEnabled(true);
        if (this.jTextFieldDestination.getText().length() == 0) {
            this.jLabelError.setText("Invalid file name");
            this.jButtonOk.setEnabled(false);
        }
    }

    public void setJasperFile(String jasperFile) {
        this.jasperFile = jasperFile;
        this.jrxmlFile = Misc.changeFileExtension(jasperFile, "jrxml");
        this.jTextFieldDestination.setText(this.jrxmlFile);
        this.checkFile();
    }
}

