/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.sheet.ExpressionProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignImage;
import org.openide.ErrorManager;

public final class ImageExpressionProperty
extends ExpressionProperty {
    private final JRDesignDataset dataset;
    private final JRDesignImage element;

    public ImageExpressionProperty(JRDesignImage element, JRDesignDataset dataset) {
        super("expression", "Expression", "Expression");
        this.element = element;
        this.dataset = dataset;
        this.setValue("expressionContext", new ExpressionContext(dataset));
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        if (this.element.getExpression() == null) {
            return "";
        }
        return this.element.getExpression().getText();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        JRDesignExpression oldExp = (JRDesignExpression)this.element.getExpression();
        JRDesignExpression newExp = null;
        if ((val == null || val.equals("")) && (oldExp == null || oldExp.getValueClassName() == null || oldExp.getValueClassName().equals("java.lang.String"))) {
            this.element.setExpression(null);
        } else {
            String s = val != null ? val + "" : "";
            newExp = new JRDesignExpression();
            newExp.setText(s);
            newExp.setValueClassName(oldExp != null ? oldExp.getValueClassName() : "java.lang.String");
            this.element.setExpression((JRExpression)newExp);
        }
        ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "Expression", JRExpression.class, oldExp, newExp);
        IReportManager.getInstance().addUndoableEdit(urob);
    }

    public IllegalArgumentException annotateException(String msg) {
        IllegalArgumentException iae = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
        return iae;
    }

    public boolean isDefaultValue() {
        return this.element.getExpression() == null || this.element.getExpression().getText() == null || this.element.getExpression().getText().length() == 0;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }
}

