/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.openide.ErrorManager;
import org.openide.nodes.PropertySupport;

public final class TopProperty
extends PropertySupport {
    private final JRDesignElement element;

    public TopProperty(JRDesignElement element) {
        super("y", Integer.class, "Top", "Top position of this element in the band/cell", true, true);
        this.element = element;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.element.getY();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val instanceof Integer) {
            Integer oldValue = this.element.getY();
            Integer newValue = (Integer)val;
            if (newValue < 0) {
                IllegalArgumentException iae = this.annotateException("This property requires a positive number.");
                throw iae;
            }
            this.element.setY(newValue.intValue());
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "Y", Integer.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public IllegalArgumentException annotateException(String msg) {
        IllegalArgumentException iae = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
        return iae;
    }
}

