/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties.charts;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.charts.design.JRDesignPie3DPlot;
import org.openide.ErrorManager;
import org.openide.nodes.PropertySupport;

public final class Pie3DDepthFactorProperty
extends PropertySupport.ReadWrite {
    JRDesignPie3DPlot element = null;

    public Pie3DDepthFactorProperty(JRDesignPie3DPlot element) {
        super("depthFactor", Double.class, "Depth Factor", "Depth Factor");
        this.element = element;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.element.getDepthFactor();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.setPropertyValue(val);
    }

    private void setPropertyValue(Object val) {
        if (val instanceof Double) {
            double oldValue = this.element.getDepthFactor();
            double newValue = (Double)val;
            if (newValue < 0.0) {
                IllegalArgumentException iae = this.annotateException("The depth factor must be a positive value.");
                throw iae;
            }
            this.element.setDepthFactor(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "DepthFactor", Double.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public IllegalArgumentException annotateException(String msg) {
        IllegalArgumentException iae = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
        return iae;
    }
}

