/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.openide.nodes.PropertySupport;

public abstract class ByteProperty
extends PropertySupport.ReadWrite {
    private final Object object;
    private ComboBoxPropertyEditor editor;

    public ByteProperty(Object object) {
        super(null, Byte.class, null, null);
        this.object = object;
        this.setValue("suppressCustomEditor", Boolean.TRUE);
        this.editor = new ComboBoxPropertyEditor(false, this.getTagList());
    }

    public PropertyEditor getPropertyEditor() {
        return this.editor;
    }

    public void setValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (value instanceof Byte) {
            Byte oldValue = (Byte)this.getValue();
            Byte newValue = (Byte)value;
            this.setValue(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.object, this.getDisplayName(), Byte.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        Object value = null;
        try {
            value = this.getValue();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return this.getDefaultValue() == null && value == null || this.getDefaultValue() != null && this.getDefaultValue().equals(value);
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(this.getDefaultValue());
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public abstract List getTagList();

    public abstract Byte getDefaultValue();

    public abstract void setValue(Byte var1);
}

