/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.subreport;

import com.jaspersoft.ireport.designer.subreport.SubreportSelectionVisualPanel;
import com.jaspersoft.ireport.designer.subreport.SubreportWizardIterator;
import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;

public class SubreportSelectionWizardPanel
implements WizardDescriptor.FinishablePanel,
WizardDescriptor.AsynchronousValidatingPanel {
    private WizardDescriptor wizard = null;
    private SubreportWizardIterator wizardIterator = null;
    private SubreportSelectionVisualPanel component;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public SubreportSelectionWizardPanel(WizardDescriptor wizard, SubreportWizardIterator witerator) {
        this.wizard = wizard;
        this.wizardIterator = witerator;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new SubreportSelectionVisualPanel(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        if (this.component == null) {
            return false;
        }
        try {
            this.component.validateForm();
            this.getWizard().putProperty("WizardPanel_errorMessage", null);
            return true;
        }
        catch (IllegalArgumentException ex) {
            this.getWizard().putProperty("WizardPanel_errorMessage", (Object)ex.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void updateWizardPanels() {
        this.storeSettings(this.getWizard());
        this.getWizardIterator().updatePanels();
        this.getWizardIterator().fireChangeEvent();
    }

    public void readSettings(Object settings) {
    }

    public void storeSettings(Object settings) {
        this.getWizard().putProperty("subreport_type", (Object)new Integer(this.component.getSelectedSubreportType()));
        this.getWizard().putProperty("subreport_filename", (Object)this.component.getSelectedReportName());
    }

    public boolean isFinishPanel() {
        return true;
    }

    public WizardDescriptor getWizard() {
        return this.wizard;
    }

    public void setWizard(WizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public SubreportWizardIterator getWizardIterator() {
        return this.wizardIterator;
    }

    public void setWizardIterator(SubreportWizardIterator wizardIterator) {
        this.wizardIterator = wizardIterator;
    }

    public void prepareValidation() {
    }

    public void validate() throws WizardValidationException {
        try {
            this.getWizard().putProperty("subreport_parameters", null);
            if (this.component.getSelectedSubreportType() == 1) {
                String filename = this.component.getSelectedReportName();
                JRParameter[] params = null;
                if (filename.toLowerCase().endsWith(".jrxml")) {
                    JasperDesign jd = JRXmlLoader.load((String)filename);
                    params = jd.getParameters();
                } else if (filename.toLowerCase().endsWith(".jasper")) {
                    JasperReport report = (JasperReport)JRLoader.loadObject((String)filename);
                    params = report.getParameters();
                }
                this.getWizard().putProperty("subreport_parameters", (Object)params);
            }
        }
        catch (Exception ex) {
            throw new WizardValidationException((JComponent)this.component, "The report specified is not valid", "The report specified is not valid");
        }
        this.getWizardIterator().fireChangeEvent();
    }
}

