/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IRFont;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.designer.sheet.FieldPatternProperty;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.DeleteStyleUndoableEdit;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class StyleNode
extends IRAbstractNode
implements PropertyChangeListener {
    JasperDesign jd = null;
    private JRDesignStyle style = null;

    public StyleNode(JasperDesign jd, JRDesignStyle style, Lookup doLkp) {
        super(Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, style})}));
        this.jd = jd;
        this.style = style;
        this.setDisplayName(style.getName());
        super.setName(style.getName());
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/style-16.png");
        style.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public String getDisplayName() {
        return this.getStyle().getName();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new NameProperty(this.getStyle(), this.jd));
        set.put((Node.Property)new DefaultStyleProperty(this.getStyle(), this.jd));
        set.put((Node.Property)new ParentStyleProperty(this.getStyle(), this.jd));
        set.put((Node.Property)new ModeProperty(this.getStyle()));
        set.put((Node.Property)new ForecolorProperty(this.getStyle()));
        set.put((Node.Property)new BackcolorProperty(this.getStyle()));
        set.put((Node.Property)new FillProperty(this.getStyle()));
        set.put((Node.Property)new RadiusProperty(this.getStyle()));
        set.put((Node.Property)new ScaleImageProperty(this.getStyle()));
        set.put((Node.Property)new HorizontalAlignmentProperty(this.getStyle()));
        set.put((Node.Property)new VerticalAlignmentProperty(this.getStyle()));
        set.put((Node.Property)new RotationProperty(this.getStyle()));
        set.put((Node.Property)new LineSpacingProperty(this.getStyle()));
        set.put((Node.Property)new StyledTextProperty(this.getStyle()));
        set.put((Node.Property)new FontNameProperty(this.getStyle()));
        set.put((Node.Property)new FontSizeProperty(this.getStyle()));
        set.put((Node.Property)new BoldProperty(this.getStyle()));
        set.put((Node.Property)new ItalicProperty(this.getStyle()));
        set.put((Node.Property)new UnderlineProperty(this.getStyle()));
        set.put((Node.Property)new StrikeThroughProperty(this.getStyle()));
        set.put((Node.Property)new PdfFontNameProperty(this.getStyle()));
        set.put((Node.Property)new PdfEmbeddedProperty(this.getStyle()));
        set.put((Node.Property)new PdfEncodingProperty(this.getStyle()));
        set.put((Node.Property)new PatternProperty(this.getStyle()));
        set.put((Node.Property)new BlankWhenNullProperty(this.getStyle()));
        sheet.put(set);
        return sheet;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canRename() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)4);
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)1);
    }

    public void destroy() throws IOException {
        int index = this.jd.getStylesList().indexOf(this.getStyle());
        this.jd.removeStyle((JRStyle)this.getStyle());
        DeleteStyleUndoableEdit undo = new DeleteStyleUndoableEdit(this.getStyle(), this.jd, index);
        IReportManager.getInstance().addUndoableEdit(undo);
        super.destroy();
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), SystemAction.get(RenameAction.class), SystemAction.get(ReorderAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        return tras;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("name")) {
            super.setName(this.getStyle().getName());
            this.setDisplayName(this.getStyle().getName());
        }
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public void setName(String s) {
        if (s.equals("")) {
            throw new IllegalArgumentException("Style name not valid.");
        }
        List currentStyles = null;
        JRDesignDataset dataset = (JRDesignDataset)this.getParentNode().getLookup().lookup(JRDesignDataset.class);
        currentStyles = this.jd.getStylesList();
        for (JRDesignStyle p : currentStyles) {
            if (p == this.getStyle() || !p.getName().equals(s)) continue;
            throw new IllegalArgumentException("Style name already in use.");
        }
        String oldName = this.getStyle().getName();
        this.getStyle().setName(s);
        ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getStyle(), "Name", String.class, oldName, s);
        IReportManager.getInstance().addUndoableEdit(opue);
    }

    public JRDesignStyle getStyle() {
        return this.style;
    }

    public void setStyle(JRDesignStyle style) {
        this.style = style;
    }

    public static final class BlankWhenNullProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignStyle style;

        public BlankWhenNullProperty(JRDesignStyle style) {
            super("blankWhenNull", Boolean.class, "Blank When Null", "Print a blank string instead of null.");
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.isBlankWhenNull();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.style.isOwnBlankWhenNull();
                Boolean newValue = (Boolean)val;
                this.style.setBlankWhenNull(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "BlankWhenNull", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.isOwnBlankWhenNull() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    private static final class PatternProperty
    extends FieldPatternProperty {
        private final JRDesignStyle style;

        public PatternProperty(JRDesignStyle style) {
            super("pattern", "Pattern", "Patter to use to format numbers and dates.");
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getPattern() == null ? "" : this.style.getPattern();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof String) {
                String oldValue = this.style.getOwnPattern();
                String newValue = (String)val;
                if (newValue != null && newValue.length() == 0) {
                    newValue = null;
                }
                this.style.setPattern(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Pattern", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getPattern() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    private static final class PdfEncodingProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignStyle style;
        PropertyEditor editor = null;

        public PdfEncodingProperty(JRDesignStyle style) {
            super("pdfEncoding", String.class, "Pdf Encoding", "Pdf Encoding");
            this.style = style;
            this.setValue("canEditAsText", true);
            this.setValue("oneline", true);
            this.setValue("suppressCustomEditor", false);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getPdfEncoding();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof String) {
                if ((val + "").trim().length() == 0) {
                    val = null;
                }
                String oldValue = this.style.getOwnPdfEncoding();
                String newValue = (String)val;
                this.style.setPdfEncoding(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "PdfEncoding", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnPdfEncoding() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> encodings = new ArrayList<Tag>();
                encodings.add(new Tag("Cp1250", "CP1250 (Central European)"));
                encodings.add(new Tag("Cp1251", "CP1251 (Cyrillic)"));
                encodings.add(new Tag("Cp1252", "CP1252 (Western European ANSI aka WinAnsi)"));
                encodings.add(new Tag("Cp1253", "CP1253 (Greek)"));
                encodings.add(new Tag("Cp1254", "CP1254 (Turkish)"));
                encodings.add(new Tag("Cp1255", "CP1255 (Hebrew)"));
                encodings.add(new Tag("Cp1256", "CP1256 (Arabic)"));
                encodings.add(new Tag("Cp1257", "CP1257 (Baltic)"));
                encodings.add(new Tag("Cp1258", "CP1258 (Vietnamese)"));
                encodings.add(new Tag("UniGB-UCS2-H", "UniGB-UCS2-H (Chinese Simplified)"));
                encodings.add(new Tag("UniGB-UCS2-V", "UniGB-UCS2-V (Chinese Simplified)"));
                encodings.add(new Tag("UniCNS-UCS2-H", "UniCNS-UCS2-H (Chinese traditional)"));
                encodings.add(new Tag("UniCNS-UCS2-V", "UniCNS-UCS2-V (Chinese traditional)"));
                encodings.add(new Tag("UniJIS-UCS2-H", "UniJIS-UCS2-H (Japanese)"));
                encodings.add(new Tag("UniJIS-UCS2-V", "UniJIS-UCS2-V (Japanese)"));
                encodings.add(new Tag("UniJIS-UCS2-HW-H", "UniJIS-UCS2-HW-H (Japanese)"));
                encodings.add(new Tag("UniJIS-UCS2-HW-V", "UniJIS-UCS2-HW-V (Japanese)"));
                encodings.add(new Tag("UniKS-UCS2-H", "UniKS-UCS2-H (Korean)"));
                encodings.add(new Tag("UniKS-UCS2-V", "UniKS-UCS2-V (Korean)"));
                encodings.add(new Tag("Identity-H", "Identity-H (Unicode with horizontal writing)"));
                encodings.add(new Tag("Identity-V", "Identity-V (Unicode with vertical writing)"));
                this.editor = new ComboBoxPropertyEditor(true, encodings);
            }
            return this.editor;
        }
    }

    private static final class PdfFontNameProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignStyle style;
        PropertyEditor editor = null;

        public PdfFontNameProperty(JRDesignStyle style) {
            super("pdfFontName", String.class, "Pdf Font name", "Pdf Font name");
            this.style = style;
            this.setValue("canEditAsText", true);
            this.setValue("oneline", true);
            this.setValue("suppressCustomEditor", true);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getPdfFontName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof String) {
                String oldValue = this.style.getOwnPdfFontName();
                String newValue = (String)val;
                this.style.setPdfFontName(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "PdfFontName", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnPdfFontName() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> classes = new ArrayList<Tag>();
                classes.add(new Tag("Helvetica"));
                classes.add(new Tag("Helvetica-Bold"));
                classes.add(new Tag("Helvetica-BoldOblique"));
                classes.add(new Tag("Helvetica-Oblique"));
                classes.add(new Tag("Courier"));
                classes.add(new Tag("Courier-Bold"));
                classes.add(new Tag("Courier-BoldOblique"));
                classes.add(new Tag("Courier-Oblique"));
                classes.add(new Tag("Symbol"));
                classes.add(new Tag("Times-Roman"));
                classes.add(new Tag("Times-Bold"));
                classes.add(new Tag("Times-BoldItalic"));
                classes.add(new Tag("Times-Italic"));
                classes.add(new Tag("ZapfDingbats"));
                classes.add(new Tag("STSong-Light"));
                classes.add(new Tag("MHei-Medium"));
                classes.add(new Tag("MSung-Light"));
                classes.add(new Tag("HeiseiKakuGo-W5"));
                classes.add(new Tag("HeiseiMin-W3"));
                classes.add(new Tag("HYGoThic-Medium"));
                classes.add(new Tag("HYSMyeongJo-Medium"));
                List<IRFont> fonts = IReportManager.getInstance().getIRFonts();
                for (IRFont f : fonts) {
                    classes.add(new Tag(f.getFile(), f.toString()));
                }
                this.editor = new ComboBoxPropertyEditor(true, classes);
            }
            return this.editor;
        }
    }

    private static final class FontSizeProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignStyle style;
        PropertyEditor editor = null;

        public FontSizeProperty(JRDesignStyle style) {
            super("fontSize", Integer.class, "Size", "Size");
            this.style = style;
            this.setValue("canEditAsText", true);
            this.setValue("oneline", true);
            this.setValue("suppressCustomEditor", false);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getFontSize();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val != null && !(val instanceof Integer)) {
                try {
                    val = new Integer(val + "");
                }
                catch (Exception ex) {
                    return;
                }
            }
            if (val == null || val instanceof Integer) {
                Integer oldValue = this.style.getOwnFontSize();
                Integer newValue = (Integer)val;
                this.style.setFontSize(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "FontSize", Integer.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnFontSize() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> classes = new ArrayList<Tag>();
                int i = 6;
                while (i < 100) {
                    classes.add(new Tag(new Integer(i), "" + i));
                    if (i < 16) {
                        ++i;
                        continue;
                    }
                    if (i < 32) {
                        i += 2;
                        continue;
                    }
                    if (i < 48) {
                        i += 4;
                        continue;
                    }
                    if (i < 72) {
                        i += 6;
                        continue;
                    }
                    i += 8;
                }
                this.editor = new ComboBoxPropertyEditor(true, classes);
            }
            return this.editor;
        }
    }

    private static final class FontNameProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignStyle style;
        PropertyEditor editor = null;

        public FontNameProperty(JRDesignStyle style) {
            super("fontName", String.class, "Font name", "Font name");
            this.style = style;
            this.setValue("canEditAsText", true);
            this.setValue("oneline", true);
            this.setValue("suppressCustomEditor", false);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getFontName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof String) {
                String oldValue = this.style.getOwnFontName();
                String newValue = (String)val;
                this.style.setFontName(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "FontName", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnFontName() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> classes = new ArrayList<Tag>();
                String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    classes.add(new Tag(name));
                }
                this.editor = new ComboBoxPropertyEditor(true, classes);
            }
            return this.editor;
        }
    }

    public static final class PdfEmbeddedProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignStyle style;

        public PdfEmbeddedProperty(JRDesignStyle style) {
            super("pdfEmbedded", Boolean.class, "Pdf Embedded", "");
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.isPdfEmbedded();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.style.isOwnPdfEmbedded();
                Boolean newValue = (Boolean)val;
                this.style.setPdfEmbedded(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "PdfEmbedded", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.isOwnPdfEmbedded() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class UnderlineProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignStyle style;

        public UnderlineProperty(JRDesignStyle style) {
            super("underline", Boolean.class, "Underline", "");
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.isUnderline();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.style.isOwnUnderline();
                Boolean newValue = (Boolean)val;
                this.style.setUnderline(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Underline", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.isOwnUnderline() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class StrikeThroughProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignStyle style;

        public StrikeThroughProperty(JRDesignStyle style) {
            super("strikeThrough", Boolean.class, "Strike Through", "");
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.isStrikeThrough();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.style.isOwnStrikeThrough();
                Boolean newValue = (Boolean)val;
                this.style.setStrikeThrough(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "StrikeThrough", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.isOwnStrikeThrough() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class ItalicProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignStyle style;

        public ItalicProperty(JRDesignStyle style) {
            super("italic", Boolean.class, "Italic", "");
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.isItalic();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.style.isOwnItalic();
                Boolean newValue = (Boolean)val;
                this.style.setItalic(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Italic", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.isOwnItalic() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class BoldProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignStyle style;

        public BoldProperty(JRDesignStyle style) {
            super("bold", Boolean.class, "Bold", "");
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.isBold();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.style.isOwnBold();
                Boolean newValue = (Boolean)val;
                this.style.setBold(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Bold", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.isOwnBold() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class StyledTextProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignStyle style;

        public StyledTextProperty(JRDesignStyle style) {
            super("isStyledText", Boolean.class, "Is Styled Text", "Set if the value should be parsed as styled text.");
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.isStyledText();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.style.isOwnStyledText();
                Boolean newValue = (Boolean)val;
                this.style.setStyledText(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "StyledText", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.isOwnStyledText() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    private static final class LineSpacingProperty
    extends PropertySupport {
        private final JRDesignStyle style;
        private ComboBoxPropertyEditor editor;

        public LineSpacingProperty(JRDesignStyle style) {
            super("lineSpacing", Byte.class, "Line Spacing", "The space to put between lines of text.", true, true);
            this.style = style;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(null, "<Default>"));
                l.add(new Tag(new Byte(0), "Single"));
                l.add(new Tag(new Byte(1), "1.5"));
                l.add(new Tag(new Byte(2), "Double"));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getLineSpacing();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.setPropertyValue(val);
        }

        private void setPropertyValue(Object val) {
            if (val == null || val instanceof Byte) {
                Byte oldValue = this.style.getOwnLineSpacing();
                Byte newValue = (Byte)val;
                this.style.setLineSpacing(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "LineSpacing", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnLineSpacing() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    private static final class RotationProperty
    extends PropertySupport {
        private final JRDesignStyle style;
        private ComboBoxPropertyEditor editor;

        public RotationProperty(JRDesignStyle style) {
            super("rotation", Byte.class, "Rotation", "How to rotate the text.", true, true);
            this.style = style;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(null, "<Default>"));
                l.add(new Tag(new Byte(0), "None"));
                l.add(new Tag(new Byte(1), "Left"));
                l.add(new Tag(new Byte(2), "Right"));
                l.add(new Tag(new Byte(3), "Upside Down"));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getRotation();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.setPropertyValue(val);
        }

        private void setPropertyValue(Object val) {
            if (val == null || val instanceof Byte) {
                Byte oldValue = this.style.getOwnRotation();
                Byte newValue = (Byte)val;
                this.style.setRotation(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Rotation", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnRotation() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public final class VerticalAlignmentProperty
    extends PropertySupport {
        private final JRDesignStyle style;
        private ComboBoxPropertyEditor editor;

        public VerticalAlignmentProperty(JRDesignStyle style) {
            super("verticalAlignment", Byte.class, "Vertical Alignment", "How to align the image.", true, true);
            this.style = style;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(null, "<Default>"));
                l.add(new Tag(new Byte(1), "Left"));
                l.add(new Tag(new Byte(2), "Center"));
                l.add(new Tag(new Byte(3), "Right"));
                l.add(new Tag(new Byte(4), "Justified"));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getVerticalAlignment();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Byte) {
                Byte oldValue = this.style.getOwnVerticalAlignment();
                Byte newValue = (Byte)val;
                this.style.setVerticalAlignment(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "VerticalAlignment", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnVerticalAlignment() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public final class HorizontalAlignmentProperty
    extends PropertySupport {
        private final JRDesignStyle style;
        private ComboBoxPropertyEditor editor;

        public HorizontalAlignmentProperty(JRDesignStyle style) {
            super("horizontalAlignment", Byte.class, "Horizontal Alignment", "How to align the image.", true, true);
            this.style = style;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(null, "<Default>"));
                l.add(new Tag(new Byte(1), "Left"));
                l.add(new Tag(new Byte(2), "Center"));
                l.add(new Tag(new Byte(3), "Right"));
                l.add(new Tag(new Byte(4), "Justified"));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getHorizontalAlignment();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Byte) {
                Byte oldValue = this.style.getOwnHorizontalAlignment();
                Byte newValue = (Byte)val;
                this.style.setHorizontalAlignment(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "HorizontalAlignment", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnHorizontalAlignment() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public final class ScaleImageProperty
    extends PropertySupport {
        private final JRDesignStyle style;
        private ComboBoxPropertyEditor editor;

        public ScaleImageProperty(JRDesignStyle style) {
            super("scaleImage", Byte.class, "Scale", "How to scale the image.", true, true);
            this.style = style;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(null, "<Default>"));
                l.add(new Tag(new Byte(1), "Clip"));
                l.add(new Tag(new Byte(2), "Fill Frame"));
                l.add(new Tag(new Byte(3), "Retain Shape"));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getScaleImage();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Byte) {
                Byte oldValue = this.style.getOwnScaleImage();
                Byte newValue = (Byte)val;
                this.style.setScaleImage(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "ScaleImage", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnScaleImage() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public final class RadiusProperty
    extends PropertySupport {
        private final JRDesignStyle style;

        public RadiusProperty(JRDesignStyle style) {
            super("radius", Integer.class, "Radius", "The radius used to paint the corners.", true, true);
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getRadius();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Integer) {
                Integer oldValue = this.style.getOwnRadius();
                Integer newValue = (Integer)val;
                if (newValue < 0) {
                    IllegalArgumentException iae = this.annotateException("This property requires a positive number.");
                    throw iae;
                }
                this.style.setRadius(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Radius", Integer.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }

        public boolean isDefaultValue() {
            return this.style.getOwnRadius() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public final class FillProperty
    extends PropertySupport {
        private final JRDesignStyle style;
        private ComboBoxPropertyEditor editor;

        public FillProperty(JRDesignStyle style) {
            super("fill", Byte.class, "Fill", "Fill.", true, true);
            this.style = style;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(new Byte(1), "Solid"));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getFill();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.setPropertyValue(val);
        }

        private void setPropertyValue(Object val) {
            if (val == null || val instanceof Byte) {
                Byte oldValue = this.style.getOwnFill();
                Byte newValue = (Byte)val;
                this.style.setFill(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Fill", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnFill() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public final class BackcolorProperty
    extends PropertySupport.ReadWrite {
        JRDesignStyle style;

        public BackcolorProperty(JRDesignStyle style) {
            super("backcolor", Color.class, "Backcolor", "The background color.");
            this.style = null;
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getBackcolor();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.setPropertyValue(val);
        }

        private void setPropertyValue(Object val) {
            if (val == null || val instanceof Color) {
                Color oldValue = this.style.getOwnBackcolor();
                Color newValue = (Color)val;
                this.style.setBackcolor(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Backcolor", Color.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return null == this.style.getOwnBackcolor();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public final class ForecolorProperty
    extends PropertySupport.ReadWrite {
        JRDesignStyle style;

        public ForecolorProperty(JRDesignStyle style) {
            super("forecolor", Color.class, "Forecolor", "The foreground color.");
            this.style = null;
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.style.getForecolor();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.setPropertyValue(val);
        }

        private void setPropertyValue(Object val) {
            if (val == null || val instanceof Color) {
                Color oldValue = this.style.getOwnForecolor();
                Color newValue = (Color)val;
                this.style.setForecolor(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Forecolor", Color.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return null == this.style.getOwnForecolor();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public final class ModeProperty
    extends PropertySupport.ReadWrite {
        JRDesignStyle style;

        public ModeProperty(JRDesignStyle style) {
            super("mode", Boolean.class, "Opaque", "Set if the style is opaque or transparent.");
            this.style = null;
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new Boolean(this.style.getMode() != null && this.style.getMode() == 1);
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Byte oldValue = this.style.getOwnMode();
                Byte newValue = val == null ? null : Byte.valueOf((Boolean)val != false ? (byte)1 : 2);
                this.style.setMode(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Mode", Byte.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.style.getOwnMode() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class ParentStyleProperty
    extends PropertySupport
    implements PropertyChangeListener {
        JRDesignStyle style = null;
        JasperDesign jd = null;
        private ComboBoxPropertyEditor editor;

        public ParentStyleProperty(JRDesignStyle style, JasperDesign jd) {
            super("parentStyle", String.class, "Style", "The optional style to use as parent. Can be the name of a locally defined style or the name of a style defined in an external style template file.", true, true);
            this.jd = jd;
            this.style = style;
            this.setValue("canEditAsText", Boolean.TRUE);
            this.setValue("oneline", Boolean.TRUE);
            this.setValue("suppressCustomEditor", Boolean.FALSE);
            jd.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jd.getEventSupport()));
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                this.editor = new ComboBoxPropertyEditor(true, this.getListOfTags());
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (this.getStyle().getStyle() != null) {
                return this.getStyle().getStyle();
            }
            if (this.getStyle().getStyleNameReference() != null) {
                return this.getStyle().getStyleNameReference();
            }
            return "";
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            String newValue = "" + val;
            JRStyle newStyle = null;
            if (val instanceof JRStyle) {
                newValue = ((JRStyle)val).getName();
                newStyle = (JRStyle)val;
            } else if (val == null || newValue.length() == 0) {
                newValue = null;
            }
            String oldValue = this.getStyle().getStyleNameReference();
            JRStyle oldStyle = this.getStyle().getStyle();
            this.getStyle().setParentStyleNameReference(newValue);
            this.getStyle().setParentStyle(newStyle);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.getStyle(), "ParentStyleNameReference", String.class, oldValue, newValue);
            ObjectPropertyUndoableEdit urob_style = new ObjectPropertyUndoableEdit(this.getStyle(), "ParentStyle", JRStyle.class, oldStyle, newStyle);
            urob.concatenate(urob_style);
            IReportManager.getInstance().addUndoableEdit(urob);
        }

        public JasperDesign getJasperDesign() {
            return this.jd;
        }

        public JRDesignStyle getStyle() {
            return this.style;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.editor == null) {
                return;
            }
            if (evt.getPropertyName() == null) {
                return;
            }
            if (evt.getPropertyName().equals("styles") || evt.getPropertyName().equals("name")) {
                this.editor.setTagValues(this.getListOfTags());
            }
        }

        private ArrayList getListOfTags() {
            ArrayList<Tag> l = new ArrayList<Tag>();
            l.add(new Tag(null, ""));
            List styles = this.getJasperDesign().getStylesList();
            for (int i = 0; i < styles.size(); ++i) {
                JRDesignStyle st = (JRDesignStyle)styles.get(i);
                l.add(new Tag(st, st.getName()));
                st.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)st.getEventSupport()));
            }
            return l;
        }
    }

    public static final class DefaultStyleProperty
    extends PropertySupport.ReadWrite {
        JRDesignStyle style = null;
        JasperDesign jd = null;

        public DefaultStyleProperty(JRDesignStyle style, JasperDesign jd) {
            super("default", Boolean.class, "Default Style", "Default Style");
            this.jd = jd;
            this.style = style;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new Boolean(this.getStyle().isDefault());
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val != null && val instanceof Boolean) {
                Boolean oldValue = this.getStyle().isDefault();
                Boolean newValue = (Boolean)val;
                ObjectPropertyUndoableEdit urob2 = null;
                if (newValue.booleanValue()) {
                    List list = this.getJasperDesign().getStylesList();
                    for (JRDesignStyle st : list) {
                        if (!st.isDefault()) continue;
                        st.setDefault(false);
                        urob2 = new ObjectPropertyUndoableEdit(st, "Default", Boolean.TYPE, Boolean.TRUE, Boolean.FALSE);
                        break;
                    }
                }
                this.getStyle().setDefault(newValue.booleanValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.getStyle(), "Default", Boolean.TYPE, oldValue, newValue);
                if (urob2 != null) {
                    urob.concatenate(urob2);
                }
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return !this.getStyle().isDefault();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            super.restoreDefaultValue();
            this.setValue(Boolean.FALSE);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public JasperDesign getJasperDesign() {
            return this.jd;
        }

        public JRDesignStyle getStyle() {
            return this.style;
        }
    }

    public static final class NameProperty
    extends PropertySupport.ReadWrite {
        JRDesignStyle style = null;
        JasperDesign jd = null;

        public NameProperty(JRDesignStyle style, JasperDesign jd) {
            super("name", String.class, "Name", "Name of the style");
            this.style = style;
            this.jd = jd;
            this.setValue("oneline", Boolean.TRUE);
        }

        public boolean canWrite() {
            return true;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.getStyle().getName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val.equals("")) {
                IllegalArgumentException iae = this.annotateException("Style name not valid.");
                throw iae;
            }
            String s = val + "";
            List currentStyles = null;
            currentStyles = this.getJasperDesign().getStylesList();
            for (JRDesignStyle st : currentStyles) {
                if (st == this.getStyle() || !st.getName().equals(s)) continue;
                IllegalArgumentException iae = this.annotateException("Style name already in use.");
                throw iae;
            }
            String oldName = this.getStyle().getName();
            this.getStyle().setName(s);
            ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getStyle(), "Name", String.class, oldName, this.getStyle().getName());
            IReportManager.getInstance().addUndoableEdit(opue);
        }

        public JasperDesign getJasperDesign() {
            return this.jd;
        }

        public JRDesignStyle getStyle() {
            return this.style;
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }
}

