/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.languages.Context;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;

public class IndentAction
extends BaseKit.InsertBreakAction {
    private static Map indentProperties = new WeakHashMap();

    protected void afterBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret, Object object) {
        block17: {
            try {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                tokenSequence.move(caret.getDot());
                if (tokenSequence.moveNext()) {
                    while (tokenSequence.embedded() != null) {
                        tokenSequence = tokenSequence.embedded();
                        tokenSequence.move(caret.getDot());
                        if (tokenSequence.moveNext()) continue;
                    }
                }
                Language language = LanguagesManager.getDefault().getLanguage(tokenSequence.language().mimeType());
                Token token = tokenSequence.token();
                Object object2 = IndentAction.getIndentProperties(language);
                if (object2 == null) {
                    return;
                }
                if (object2 instanceof Object[]) {
                    Object[] objectArray = (Object[])object2;
                    int n = baseDocument.getLength();
                    int n2 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)baseDocument), (int)(caret.getDot() - 1));
                    int n3 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)baseDocument), (int)(n - 1));
                    int n4 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)baseDocument), (int)n2);
                    int n5 = n2 < n3 ? NbDocument.findLineOffset((StyledDocument)((StyledDocument)baseDocument), (int)(n2 + 1)) : n;
                    String string = baseDocument.getText(n4, n5 - n4);
                    int n6 = IndentAction.getIndent(string);
                    tokenSequence.move(n4);
                    tokenSequence.moveNext();
                    int n7 = IndentAction.getIndent(string, tokenSequence, n5, objectArray);
                    if (n7 > 0) {
                        n6 += 4;
                    } else if (n7 == 0 && n2 > 0) {
                        int n8 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)baseDocument), (int)(n2 - 1));
                        string = baseDocument.getText(n8, n4 - n8);
                        tokenSequence.move(n8);
                        tokenSequence.moveNext();
                        n7 = IndentAction.getIndent(string, tokenSequence, n4, objectArray);
                        if (n7 == 2) {
                            n6 -= 4;
                        }
                    }
                    try {
                        n4 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)baseDocument), (int)(n2 + 1));
                        try {
                            n5 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)baseDocument), (int)(n2 + 2));
                            string = baseDocument.getText(n4, n5 - n4);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            string = baseDocument.getText(n4, baseDocument.getLength() - n4);
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        string = null;
                    }
                    IndentAction.indent((Document)baseDocument, caret.getDot(), n6);
                    if (string != null && ((Set)objectArray[2]).contains(string.trim())) {
                        int n9 = caret.getDot();
                        baseDocument.insertString(n9, "\n", null);
                        IndentAction.indent((Document)baseDocument, caret.getDot(), n6 -= 4);
                        caret.setDot(n9);
                    }
                    break block17;
                }
                if (object2 instanceof Feature) {
                    Feature feature = (Feature)object2;
                    feature.getValue(Context.create((Document)baseDocument, tokenSequence.offset()));
                }
            }
            catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
    }

    private static int getIndent(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        for (int i = 0; i < n2 && Character.isWhitespace(string.charAt(i)); ++i) {
            if (string.charAt(i) == '\t') {
                n += 8 - n % 8;
                continue;
            }
            ++n;
        }
        return n;
    }

    private static int getIndent(String string, TokenSequence tokenSequence, int n, Object[] objectArray) {
        Object object;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        do {
            Integer n2;
            String string2;
            if (((Set)objectArray[1]).contains(string2 = ((Object)(object = tokenSequence.token()).text()).toString())) {
                n2 = (Integer)hashMap.get(string2);
                n2 = n2 == null ? Integer.valueOf(1) : Integer.valueOf(n2 + 1);
                hashMap.put(string2, n2);
            }
            if (!((Set)objectArray[2]).contains(((Object)object.text()).toString())) continue;
            n2 = (Integer)hashMap.get(string2 = (String)((Map)objectArray[3]).get(string2));
            n2 = n2 == null ? Integer.valueOf(-1) : Integer.valueOf(n2 - 1);
            hashMap.put(string2, n2);
        } while (tokenSequence.moveNext() && tokenSequence.offset() < n);
        object = hashMap.values().iterator();
        while (object.hasNext()) {
            int n3 = (Integer)object.next();
            if (n3 > 0) {
                return 1;
            }
            if (n3 >= 0) continue;
            return -1;
        }
        for (Pattern pattern : (List)objectArray[0]) {
            if (!pattern.matcher(string).matches()) continue;
            return 2;
        }
        return 0;
    }

    private static void indent(Document document, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 > 0) {
            stringBuilder.append(' ');
            --n2;
        }
        try {
            document.insertString(n, stringBuilder.toString(), null);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
        }
    }

    private static Object getIndentProperties(Language language) {
        if (!indentProperties.containsKey(language)) {
            ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            List<Feature> list = language.getFeatures("INDENT");
            for (Feature feature : list) {
                if (feature.getType() == Feature.Type.METHOD_CALL) {
                    return feature;
                }
                String string = (String)feature.getValue();
                int n = string.indexOf(58);
                if (n < 1) {
                    arrayList.add(Pattern.compile(IndentAction.c(string)));
                    continue;
                }
                hashSet.add(string.substring(0, n));
                hashSet2.add(string.substring(n + 1));
                hashMap.put(string.substring(n + 1), string.substring(0, n));
            }
            indentProperties.put(language, new Object[]{arrayList, hashSet, hashSet2, hashMap});
        }
        return indentProperties.get(language);
    }

    private static String c(String string) {
        string = string.replace("\\n", "\n");
        string = string.replace("\\r", "\r");
        string = string.replace("\\t", "\t");
        string = string.replace("\\\"", "\"");
        string = string.replace("\\'", "'");
        string = string.replace("\\\\", "\\");
        return string;
    }
}

