/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.languages.CharInput;
import org.netbeans.api.languages.ParseException;
import org.netbeans.modules.languages.TokenType;
import org.netbeans.modules.languages.parser.DG;
import org.netbeans.modules.languages.parser.DGUtils;
import org.netbeans.modules.languages.parser.NodeFactory;
import org.netbeans.modules.languages.parser.StringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pattern {
    private static final Character STAR = new Character('\u0000');
    private static NodeFactory<Integer> nodeFactory = new NodeFactory<Integer>(){
        private int counter = 1;

        @Override
        public Integer createNode() {
            return this.counter++;
        }
    };
    private static Set<Character> whitespace = new HashSet<Character>();
    private DG<Integer, Character, Integer, TokenType> dg;

    public static Pattern create() {
        return new Pattern();
    }

    public static Pattern create(String string) throws ParseException {
        if (string.length() == 0) {
            throw new ParseException("Empty pattern.");
        }
        return Pattern.create(new StringInput(string));
    }

    public static Pattern create(CharInput charInput) throws ParseException {
        Pattern pattern = Pattern.createIn(charInput);
        DG<Integer, Character, Integer, TokenType> dG = DGUtils.reduce(pattern.dg, nodeFactory);
        return new Pattern(dG);
    }

    private static Pattern createCaseInsensitive(StringBuffer stringBuffer) throws ParseException {
        int n = stringBuffer.length();
        Pattern pattern = new Pattern();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = stringBuffer.charAt(i);
            char c3 = Character.toUpperCase(c2);
            pattern = c3 != (c = Character.toLowerCase(c2)) ? pattern.append(new Pattern(new Character(c3)).merge(new Pattern(new Character(c)))) : pattern.append(new Pattern(new Character(c2)));
        }
        return pattern;
    }

    private static Pattern createIn(CharInput charInput) throws ParseException {
        Pattern pattern = new Pattern();
        Pattern pattern2 = null;
        char c = charInput.next();
        while (c != '\u0000') {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    charInput.read();
                    break;
                }
                case '*': {
                    charInput.read();
                    if (pattern2 == null) {
                        throw new ParseException("Unexpected character '" + c + "'.");
                    }
                    pattern2 = pattern2.star();
                    break;
                }
                case '?': {
                    charInput.read();
                    if (pattern2 == null) {
                        throw new ParseException("Unexpected character '" + c + "'.");
                    }
                    pattern2 = pattern2.question();
                    break;
                }
                case '+': {
                    charInput.read();
                    if (pattern2 == null) {
                        throw new ParseException("Unexpected character '" + c + "'.");
                    }
                    pattern2 = pattern2.plus();
                    break;
                }
                case '(': {
                    charInput.read();
                    if (pattern2 != null) {
                        pattern = pattern.append(pattern2);
                    }
                    pattern2 = Pattern.createIn(charInput);
                    if (charInput.next() != ')') {
                        throw new ParseException("Unexpected character '" + charInput.next() + "'.");
                    }
                    charInput.read();
                    break;
                }
                case '\"': 
                case '\'': {
                    int n;
                    int n2;
                    int n3;
                    charInput.read();
                    if (pattern2 != null) {
                        pattern = pattern.append(pattern2);
                    }
                    pattern2 = Pattern.create();
                    StringBuffer stringBuffer = new StringBuffer();
                    c = charInput.next();
                    while (c != '\"' && c != '\'') {
                        if (c == '\u0000') {
                            throw new ParseException("Unexpected character '" + c + "'.");
                        }
                        if (c == '\\') {
                            charInput.read();
                            switch (charInput.next()) {
                                case '\\': {
                                    charInput.read();
                                    stringBuffer.append('\\');
                                    break;
                                }
                                case 'n': {
                                    charInput.read();
                                    stringBuffer.append('\n');
                                    break;
                                }
                                case 'r': {
                                    charInput.read();
                                    stringBuffer.append('\r');
                                    break;
                                }
                                case 't': {
                                    charInput.read();
                                    stringBuffer.append('\t');
                                    break;
                                }
                                case '\"': {
                                    charInput.read();
                                    stringBuffer.append('\"');
                                    break;
                                }
                                case '\'': {
                                    charInput.read();
                                    stringBuffer.append('\'');
                                    break;
                                }
                                case 'u': {
                                    charInput.read();
                                    n3 = 0;
                                    for (int i = 4096; i >= 1; i /= 16) {
                                        n2 = charInput.next();
                                        n = 0;
                                        if (48 <= n2 && n2 <= 57) {
                                            n = n2 - 48;
                                        } else if (97 <= n2 && n2 <= 102) {
                                            n = n2 - 97 + 10;
                                        } else if (65 <= n2 && n2 <= 70) {
                                            n = n2 - 65 + 10;
                                        } else {
                                            throw new ParseException("Unexpected character after \\u:" + (char)n2);
                                        }
                                        n3 += n * i;
                                        charInput.read();
                                    }
                                    stringBuffer.append((char)n3);
                                    break;
                                }
                                default: {
                                    throw new ParseException("Unexpected character after \\:" + charInput.next());
                                }
                            }
                        } else {
                            stringBuffer.append(charInput.read());
                        }
                        c = charInput.next();
                    }
                    charInput.read();
                    c = charInput.next();
                    if (c == 'i') {
                        charInput.read();
                        pattern2 = pattern2.append(Pattern.createCaseInsensitive(stringBuffer));
                        break;
                    }
                    n3 = stringBuffer.length();
                    Pattern pattern3 = new Pattern();
                    for (n2 = 0; n2 < n3; ++n2) {
                        pattern3 = pattern3.append(new Pattern(new Character(stringBuffer.charAt(n2))));
                    }
                    pattern2 = pattern2.append(pattern3);
                    break;
                }
                case '|': {
                    charInput.read();
                    if (pattern2 != null) {
                        pattern = pattern.append(pattern2);
                    }
                    pattern2 = null;
                    pattern = pattern.merge(Pattern.createIn(charInput));
                    return pattern;
                }
                case '-': {
                    if (pattern2 != null) {
                        pattern = pattern.append(pattern2);
                    }
                    charInput.read();
                    Pattern.skipWhitespaces(charInput);
                    c = charInput.next();
                    if (c != '\'' && c != '\"') {
                        throw new ParseException("Unexpected character '" + c + "'.");
                    }
                    charInput.read();
                    c = charInput.next();
                    if (c == '\'' || c == '\"') {
                        throw new ParseException("Unexpected character '" + c + "'.");
                    }
                    Character c2 = new Character(charInput.next());
                    pattern2 = new Pattern(true, Collections.singleton(c2));
                    pattern2 = pattern2.star().append(new Pattern(c2));
                    charInput.read();
                    c = charInput.next();
                    while (c != '\'' && c != '\"') {
                        if (c == '\u0000') {
                            throw new ParseException("Unexpected character '" + c + "'.");
                        }
                        pattern2 = pattern2.plus();
                        Integer n = pattern2.dg.getEnds().iterator().next();
                        Integer n4 = nodeFactory.createNode();
                        pattern2.dg.addNode(n4);
                        pattern2.dg.addEdge(n, n4, new Character(charInput.next()));
                        pattern2.dg.setEnds(Collections.singleton(n4));
                        charInput.read();
                        c = charInput.next();
                    }
                    charInput.read();
                    break;
                }
                case ')': {
                    if (pattern2 != null) {
                        pattern = pattern.append(pattern2);
                    }
                    return pattern;
                }
                case '.': {
                    charInput.read();
                    if (pattern2 != null) {
                        pattern = pattern.append(pattern2);
                    }
                    pattern2 = new Pattern(STAR);
                    break;
                }
                case '[': {
                    charInput.read();
                    if (pattern2 != null) {
                        pattern = pattern.append(pattern2);
                    }
                    boolean bl = false;
                    c = charInput.next();
                    if (c == '^') {
                        charInput.read();
                        c = charInput.next();
                        bl = true;
                    }
                    HashSet<Character> hashSet = new HashSet<Character>();
                    int n = 0;
                    boolean bl2 = false;
                    c = charInput.next();
                    while (c != ']' && c != '\u0000') {
                        switch (c) {
                            case '\t': 
                            case '\n': 
                            case '\r': 
                            case ' ': {
                                charInput.read();
                                break;
                            }
                            case '\"': 
                            case '\'': {
                                int n5 = n;
                                if (n != 0 && !bl2) {
                                    hashSet.add(new Character((char)n));
                                }
                                charInput.read();
                                c = charInput.next();
                                if (c == '\\') {
                                    charInput.read();
                                    c = charInput.next();
                                    switch (c) {
                                        case 'n': {
                                            n = 10;
                                            break;
                                        }
                                        case 't': {
                                            n = 9;
                                            break;
                                        }
                                        case 'r': {
                                            n = 13;
                                            break;
                                        }
                                        case '\'': {
                                            n = 39;
                                            break;
                                        }
                                        case '\\': {
                                            n = 92;
                                            break;
                                        }
                                        case '\"': {
                                            n = 34;
                                            break;
                                        }
                                        case 'u': {
                                            n = 0;
                                            for (int i = 4096; i >= 1; i /= 16) {
                                                charInput.read();
                                                char c3 = charInput.next();
                                                int n6 = 0;
                                                if ('0' <= c3 && c3 <= '9') {
                                                    n6 = c3 - 48;
                                                } else if ('a' <= c3 && c3 <= 'f') {
                                                    n6 = c3 - 97 + 10;
                                                } else if ('A' <= c3 && c3 <= 'F') {
                                                    n6 = c3 - 65 + 10;
                                                } else {
                                                    throw new ParseException("Unexpected character after \\u:" + c3);
                                                }
                                                n = (char)(n + n6 * i);
                                            }
                                            break;
                                        }
                                        default: {
                                            throw new ParseException("Unexpected character '" + c + "'.");
                                        }
                                    }
                                    charInput.read();
                                } else {
                                    n = charInput.read();
                                }
                                c = charInput.next();
                                if (c != '\"' && c != '\'') {
                                    throw new ParseException("Unexpected character '" + c + "'.");
                                }
                                charInput.read();
                                if (bl2) {
                                    Pattern.addInterval(hashSet, (char)n5, (char)n);
                                    n = 0;
                                }
                                bl2 = false;
                                break;
                            }
                            case '-': {
                                charInput.read();
                                if (n == 0) {
                                    throw new ParseException("Unexpected character '-'.");
                                }
                                bl2 = true;
                                break;
                            }
                            default: {
                                throw new ParseException("Unexpected character '" + c + "'.");
                            }
                        }
                        c = charInput.next();
                    }
                    if (bl2) {
                        throw new ParseException("Unexpected character '" + c + "'.");
                    }
                    if (n != 0) {
                        hashSet.add(new Character((char)n));
                    }
                    charInput.read();
                    pattern2 = new Pattern(bl, hashSet);
                    break;
                }
                default: {
                    throw new ParseException("Unexpected character '" + c + "'.");
                }
            }
            c = charInput.next();
        }
        if (pattern2 != null) {
            pattern = pattern.append(pattern2);
        }
        return pattern;
    }

    private static void skipWhitespaces(CharInput charInput) {
        while (whitespace.contains(new Character(charInput.next()))) {
            charInput.read();
        }
    }

    private static void addInterval(Set<Character> set, char c, char c2) throws ParseException {
        if (c > c2) {
            throw new ParseException("Invalid interval (" + c + ">" + c2 + ").");
        }
        do {
            set.add(new Character(c));
        } while ((c = (char)(c + '\u0001')) <= c2);
    }

    private Pattern(DG<Integer, Character, Integer, TokenType> dG) {
        this.dg = dG;
    }

    private Pattern() {
        this.dg = DG.createDG(nodeFactory.createNode());
    }

    private Pattern(Pattern pattern) {
        this.dg = DGUtils.cloneDG(pattern.dg, false, nodeFactory);
    }

    private Pattern(Character c) {
        Integer n = nodeFactory.createNode();
        this.dg = DG.createDG(n);
        Integer n2 = nodeFactory.createNode();
        this.dg.addNode(n2);
        this.dg.addEdge(n, n2, c);
        this.dg.setEnds(Collections.singleton(n2));
    }

    private Pattern(boolean bl, Set<Character> set) {
        Integer n = nodeFactory.createNode();
        this.dg = DG.createDG(n);
        Integer n2 = nodeFactory.createNode();
        this.dg.addNode(n2);
        this.dg.setStart(n);
        this.dg.setEnds(Collections.emptySet());
        for (Comparable<Character> comparable : set) {
            this.dg.addEdge(n, n2, (Character)comparable);
        }
        if (bl) {
            Comparable<Character> comparable;
            comparable = nodeFactory.createNode();
            this.dg.addNode((Integer)comparable);
            this.dg.addEdge(n, (Integer)comparable, STAR);
            this.dg.addEnd((Integer)comparable);
        } else {
            this.dg.addEnd(n2);
        }
    }

    public Pattern clonePattern() {
        return new Pattern(this);
    }

    public Pattern star() {
        DG<Integer, Character, Integer, TokenType> dG = DGUtils.plus(this.dg, STAR, nodeFactory);
        dG = DGUtils.merge(DG.createDG(nodeFactory.createNode()), dG, STAR, nodeFactory);
        Pattern pattern = new Pattern(dG);
        return pattern;
    }

    public Pattern plus() {
        DG<Integer, Character, Integer, TokenType> dG = DGUtils.plus(this.dg, STAR, nodeFactory);
        Pattern pattern = new Pattern(dG);
        return pattern;
    }

    public Pattern question() {
        DG<Integer, Character, Integer, TokenType> dG = DGUtils.cloneDG(this.dg, true, nodeFactory);
        dG.addEnd(dG.getStartNode());
        Pattern pattern = new Pattern(dG);
        return pattern;
    }

    public Pattern merge(Pattern pattern) {
        DG<Integer, Character, Integer, TokenType> dG = DGUtils.merge(this.dg, pattern.dg, STAR, nodeFactory);
        Pattern pattern2 = new Pattern(dG);
        return pattern2;
    }

    public Pattern append(Pattern pattern) {
        DG<Integer, Character, Integer, TokenType> dG = DGUtils.append(this.dg, pattern.dg, STAR, nodeFactory);
        Pattern pattern2 = new Pattern(dG);
        return pattern2;
    }

    public boolean matches(String string) {
        int n = 0;
        Integer n2 = this.dg.getStartNode();
        while (n < string.length()) {
            if ((n2 = this.dg.getNode(n2, new Character(string.charAt(n++)))) != null) continue;
            return false;
        }
        return this.dg.getEnds().contains(n2);
    }

    public Integer next(CharInput charInput) {
        return this.next(this.dg.getStartNode(), charInput);
    }

    public Integer next(Integer n, CharInput charInput) {
        int n2 = charInput.getIndex();
        Integer n3 = null;
        while (n != null) {
            if (this.dg.getEnds().contains(n)) {
                n3 = n;
                n2 = charInput.getIndex();
            }
            if (charInput.eof()) break;
            Integer n4 = this.dg.getNode(n, new Character(charInput.next()));
            if ((n = n4 != null ? n4 : this.dg.getNode(n, STAR)) == null) continue;
            charInput.read();
        }
        charInput.setIndex(n2);
        return n3;
    }

    public String toString() {
        return this.dg.toString();
    }

    public Object read(CharInput charInput) {
        Object object;
        if (charInput.eof()) {
            return null;
        }
        int n = charInput.getIndex();
        int n2 = -1;
        Object object2 = null;
        Integer n3 = this.dg.getStartNode();
        while (!charInput.eof()) {
            TokenType tokenType;
            object = new Character(charInput.next());
            Integer n4 = this.dg.getNode(n3, (Character)object);
            if (n4 == null) {
                object = STAR;
                n4 = this.dg.getNode(n3, (Character)object);
            }
            if (charInput.getIndex() > n && (tokenType = this.getBestTT(n3)) != null) {
                object2 = tokenType;
                n2 = charInput.getIndex();
            }
            if (n4 == null || this.dg.getEdges(n4).isEmpty() && this.dg.getProperties(n4).isEmpty()) {
                if (object2 == null) {
                    return null;
                }
                charInput.setIndex(n2);
                return object2;
            }
            charInput.read();
            n3 = n4;
        }
        object = this.getBestTT(n3);
        if (object != null) {
            object2 = object;
            n2 = charInput.getIndex();
        }
        if (object2 == null) {
            return null;
        }
        return object2;
    }

    private TokenType getBestTT(Integer n) {
        Map<Integer, TokenType> map = this.dg.getProperties(n);
        TokenType tokenType = null;
        for (Integer n2 : map.keySet()) {
            TokenType tokenType2 = map.get(n2);
            if (tokenType != null && tokenType.getPriority() <= tokenType2.getPriority()) continue;
            tokenType = tokenType2;
        }
        return tokenType;
    }

    void mark(int n, TokenType tokenType) {
        for (Integer n2 : this.dg.getEnds()) {
            this.dg.setProperty(n2, n, tokenType);
        }
    }

    static {
        whitespace.add(new Character(' '));
        whitespace.add(new Character('\n'));
        whitespace.add(new Character('\r'));
        whitespace.add(new Character('\t'));
    }
}

