/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.outline.NewTypesUtils;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import com.jaspersoft.ireport.designer.outline.nodes.VariableNode;
import com.jaspersoft.ireport.designer.outline.nodes.VariablesChildren;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class VariablesNode
extends IRIndexedNode
implements PropertyChangeListener {
    private JasperDesign jd = null;
    private JRDesignDataset dataset = null;

    public VariablesNode(JasperDesign jd, Lookup doLkp) {
        this(jd, (JRDesignDataset)jd.getMainDataset(), doLkp);
    }

    public VariablesNode(JasperDesign jd, JRDesignDataset dataset, Lookup doLkp) {
        this(new VariablesChildren(jd, dataset, doLkp), jd, dataset, doLkp);
    }

    public VariablesNode(VariablesChildren pc, JasperDesign jd, JRDesignDataset dataset, Lookup doLkp) {
        super((Children)pc, pc.getIndex(), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, dataset})}));
        this.addNodeListener(new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
            }

            public void childrenRemoved(NodeMemberEvent ev) {
            }

            public void childrenReordered(NodeReorderEvent ev) {
                List list = VariablesNode.this.getDataset().getVariablesList();
                ArrayList<JRDesignVariable> newList = new ArrayList<JRDesignVariable>();
                for (int i = 0; i < list.size(); ++i) {
                    JRDesignVariable p = (JRDesignVariable)list.get(i);
                    if (!p.isSystemDefined()) continue;
                    newList.add(p);
                }
                Node[] nodes = VariablesNode.this.getChildren().getNodes();
                for (int i = 0; i < nodes.length; ++i) {
                    JRDesignVariable p = ((VariableNode)nodes[i]).getVariable();
                    if (p.isSystemDefined()) continue;
                    newList.add(p);
                }
                list.clear();
                list.addAll(newList);
                VariablesNode.this.getDataset().getEventSupport().firePropertyChange(new PropertyChangeEvent(VariablesNode.this.getDataset(), "variables", null, null));
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
        this.jd = jd;
        if (dataset == null) {
            dataset = jd.getMainDesignDataset();
        }
        this.dataset = dataset;
        dataset.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        this.setDisplayName("Variables");
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/variables-16.png");
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        JRDesignVariable variable;
        final Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        final int dropAction = DnDUtilities.getTransferAction(t);
        int insertAt = index;
        if (null != dropNode && null != (variable = (JRDesignVariable)dropNode.getLookup().lookup(JRDesignVariable.class))) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    if (variable.isSystemDefined()) {
                        return null;
                    }
                    List list = VariablesNode.this.getDataset().getVariablesList();
                    int currentIndex = -1;
                    int lastSystemDefinedVariableIndex = -1;
                    for (int i = 0; i < list.size(); ++i) {
                        JRDesignVariable p = (JRDesignVariable)list.get(i);
                        if (p == variable) {
                            currentIndex = i;
                        }
                        if (!p.isSystemDefined()) continue;
                        lastSystemDefinedVariableIndex = i;
                    }
                    if ((dropAction & 6) != 0) {
                        int newIndex = -1;
                        if (currentIndex != -1) {
                            Node[] nodes = VariablesNode.this.getChildren().getNodes();
                            for (int i = 0; i < nodes.length; ++i) {
                                if (((VariableNode)nodes[i]).getVariable() != variable) continue;
                                newIndex = i;
                                break;
                            }
                            list.remove(variable);
                            if (newIndex == -1) {
                                list.add(variable);
                            } else {
                                list.add(Math.max(newIndex, lastSystemDefinedVariableIndex + 1), variable);
                            }
                        } else {
                            try {
                                JRDesignVariable newVariable = ModelUtils.cloneVariable(variable);
                                Map map = VariablesNode.this.getDataset().getVariablesMap();
                                int k = 1;
                                while (map.containsKey(newVariable.getName())) {
                                    newVariable.setName(variable.getName() + "_" + k);
                                    ++k;
                                }
                                VariablesNode.this.getDataset().addVariable(newVariable);
                                if (dropNode.getParentNode() instanceof VariablesNode) {
                                    VariablesNode pn = (VariablesNode)dropNode.getParentNode();
                                    pn.getDataset().removeVariable((JRVariable)variable);
                                }
                            }
                            catch (JRException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    } else {
                        try {
                            JRDesignVariable newVariable = ModelUtils.cloneVariable(variable);
                            Map map = VariablesNode.this.getDataset().getVariablesMap();
                            int k = 1;
                            while (map.containsKey(newVariable.getName())) {
                                newVariable.setName(variable.getName() + "_" + k);
                                ++k;
                            }
                            VariablesNode.this.getDataset().addVariable(newVariable);
                        }
                        catch (JRException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(NewAction.class), SystemAction.get(PasteAction.class), SystemAction.get(ReorderAction.class)};
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public JRDesignDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(JRDesignDataset dataset) {
        this.dataset = dataset;
    }

    public NewType[] getNewTypes() {
        return NewTypesUtils.getNewType(4, (Node)this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName().equals("variables")) {
            ((VariablesChildren)this.getChildren()).recalculateKeys();
        }
    }
}

