/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.ErrorManager;
import org.openide.nodes.PropertySupport;

public final class KeyProperty
extends PropertySupport.ReadWrite {
    final JRDesignElement element;
    final JasperDesign jasperDesign;

    public KeyProperty(JRDesignElement element, JasperDesign jasperDesign) {
        super("key", String.class, "Key", "Optional identifier for this element. If set, it must be unique within the overall band/cell.");
        this.element = element;
        this.jasperDesign = jasperDesign;
        this.setValue("oneline", Boolean.TRUE);
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.getElement().getKey() == null ? "" : this.getElement().getKey();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String oldValue = this.getElement().getKey();
        String newValue = val + "";
        if (val == null || val.equals("")) {
            newValue = null;
        } else {
            JRElementGroup group = ModelUtils.getTopElementGroup(this.getElement());
            if (group.getElementByKey(newValue) != null) {
                IllegalArgumentException iae = this.annotateException("Key already in use in this band/cell.");
                throw iae;
            }
        }
        this.getElement().setKey(newValue);
        ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getElement(), "Key", String.class, oldValue, newValue);
        IReportManager.getInstance().addUndoableEdit(opue);
    }

    public JRDesignElement getElement() {
        return this.element;
    }

    public IllegalArgumentException annotateException(String msg) {
        IllegalArgumentException iae = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
        return iae;
    }
}

