/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.openide.nodes.PropertySupport;

public final class PositionTypeProperty
extends PropertySupport {
    private final JRDesignElement element;
    private ComboBoxPropertyEditor editor;

    public PositionTypeProperty(JRDesignElement element) {
        super("positionType", Byte.class, "Position type", "How to anchor the element.", true, true);
        this.element = element;
        this.setValue("suppressCustomEditor", Boolean.TRUE);
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            ArrayList<Tag> l = new ArrayList<Tag>();
            l.add(new Tag(new Byte(2), "Fix Relative to Top"));
            l.add(new Tag(new Byte(1), "Float"));
            l.add(new Tag(new Byte(3), "Fix Relative to Bottom"));
            this.editor = new ComboBoxPropertyEditor(false, l);
        }
        return this.editor;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return new Byte(this.element.getPositionType());
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.setPropertyValue(val);
    }

    public boolean isDefaultValue() {
        return this.element.getPositionType() == 2;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setPropertyValue((byte)2);
    }

    public boolean supportsDefaultValue() {
        return super.supportsDefaultValue();
    }

    private void setPropertyValue(Object val) {
        if (val instanceof Byte) {
            Byte oldValue = this.element.getPositionType();
            Byte newValue = (Byte)val;
            this.element.setPositionType(newValue.byteValue());
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "PositionType", Byte.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }
}

