/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.MainMenuAction;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public abstract class CompletionActionsMainMenu
extends MainMenuAction
implements Action {
    private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());
    private AbstractAction delegate = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
        }
    };

    public CompletionActionsMainMenu() {
        this.putValue("Name", this.getActionName());
        this.setMenu();
    }

    public JMenuItem getMenuPresenter() {
        return this.menuItem;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.delegate.removePropertyChangeListener(propertyChangeListener);
    }

    public void putValue(String string, Object object) {
        this.delegate.putValue(string, object);
    }

    public Object getValue(String string) {
        return this.delegate.getValue(string);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.delegate.addPropertyChangeListener(propertyChangeListener);
    }

    public void setEnabled(boolean bl) {
        this.delegate.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.delegate.isEnabled();
    }

    protected void setMenu() {
        JMenuItem jMenuItem;
        Action action;
        ActionMap actionMap = this.getContextActionMap();
        Action action2 = null;
        if (actionMap != null) {
            action2 = actionMap.get(this.getActionName());
        }
        if ((action = (jMenuItem = this.getMenuPresenter()).getAction()) == null) {
            jMenuItem.setAction(this);
            jMenuItem.setToolTipText(null);
            this.menuInitialized = false;
        } else if (!this.equals(action)) {
            jMenuItem.setAction(this);
            jMenuItem.setToolTipText(null);
            this.menuInitialized = false;
        }
        if (!this.menuInitialized) {
            Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)this.getMenuItemText());
            this.menuInitialized = true;
        }
        jMenuItem.setEnabled(action2 != null);
        JTextComponent jTextComponent = Utilities.getFocusedComponent();
        if (jTextComponent != null && jTextComponent instanceof JEditorPane) {
            CompletionActionsMainMenu.addAccelerators((Action)this, (JMenuItem)jMenuItem, (JTextComponent)jTextComponent);
        } else {
            jMenuItem.setAccelerator(this.getDefaultAccelerator());
        }
    }

    public static final class CompletionShow
    extends CompletionActionsMainMenu {
        protected String getMenuItemText() {
            return NbBundle.getBundle(CompletionActionsMainMenu.class).getString("completion-show-main_menu_item");
        }

        protected String getActionName() {
            return "completion-show";
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Completion.get().showCompletion();
        }
    }

    public static final class DocumentationShow
    extends CompletionActionsMainMenu {
        protected String getMenuItemText() {
            return NbBundle.getBundle(CompletionActionsMainMenu.class).getString("documentation-show-main_menu_item");
        }

        protected String getActionName() {
            return "documentation-show";
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Completion.get().showDocumentation();
        }
    }

    public static final class ToolTipShow
    extends CompletionActionsMainMenu {
        protected String getMenuItemText() {
            return NbBundle.getBundle(CompletionActionsMainMenu.class).getString("tooltip-show-main_menu_item");
        }

        protected String getActionName() {
            return "tooltip-show";
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Completion.get().showToolTip();
        }
    }
}

