/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.ServiceType;
import org.openide.actions.DeleteAction;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DefaultES;
import org.openide.loaders.Environment;
import org.openide.loaders.InstanceNode;
import org.openide.loaders.InstanceSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.modules.ModuleInfo;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceDataObject
extends MultiDataObject
implements InstanceCookie.Of {
    static final long serialVersionUID = -6134784731744777123L;
    private static final String EA_INSTANCE_CLASS = "instanceClass";
    private static final String EA_INSTANCE_CREATE = "instanceCreate";
    private static final String EA_INSTANCE_OF = "instanceOf";
    static final String EA_NAME = "name";
    private static final int SAVE_DELAY = 2000;
    private static final char OPEN = '[';
    private static final char CLOSE = ']';
    public static final String INSTANCE = "instance";
    static final String SER_EXT = "ser";
    static final String XML_EXT = "settings";
    private static final String ICON_NAME = "icon";
    private Ser ser;
    private boolean savingCanceled = false;
    private String nameCache;
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Instance processor");
    private static final Logger err = Logger.getLogger("org.openide.loaders.InstanceDataObject");
    private final Object IDO_LOCK = new Object();
    private UpdatableNode un;
    private Lookup.Result cookieResult = null;
    private Lookup.Result nodeResult = null;
    private Lookup cookiesLkp = null;
    private LookupListener cookiesLsnr = null;
    private LookupListener nodeLsnr = null;
    private static final Set<FileObject> warnedAboutBrackets = new WeakSet();
    private static final int MAX_FILENAME_LENGTH = 50;
    private FileLock fileLock;
    private static final String EA_PROVIDER_PATH = "settings.providerPath";
    private static final String EA_SUBCLASSES = "settings.subclasses";
    private static final List<String> createdIDOs = Collections.synchronizedList(new ArrayList(1));

    public InstanceDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        if (fileObject.hasExt(SER_EXT)) {
            this.ser = new Ser(this);
            this.getCookieSet().add((Node.Cookie)this.ser);
        } else if (!fileObject.hasExt(XML_EXT)) {
            this.ser = new Ser(this);
        }
        try {
            if (!fileObject.getFileSystem().isDefault()) {
                this.getCookieSet().add((Node.Cookie)new DefaultES(this, this.getPrimaryEntry(), this.getCookieSet()));
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    private Object getLock() {
        return this.IDO_LOCK;
    }

    private static FileObject findFO(DataFolder dataFolder, String string, String string2) {
        FileObject fileObject = dataFolder.getPrimaryFile();
        String string3 = string2.replace('.', '-');
        Enumeration enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!fileObject2.hasExt(INSTANCE) || (string == null ? !string3.equals(InstanceDataObject.getName(fileObject2)) : !string.equals(InstanceDataObject.getName(fileObject2))) || !string2.equals(Ser.getClassName(fileObject2))) continue;
            return fileObject2;
        }
        return null;
    }

    private static String getName(FileObject fileObject) {
        String string = (String)fileObject.getAttribute(EA_NAME);
        if (string != null) {
            return string;
        }
        string = fileObject.getName();
        int n = string.indexOf(91);
        if (n == -1) {
            return InstanceDataObject.unescape(string);
        }
        InstanceDataObject.warnAboutBrackets(fileObject);
        return InstanceDataObject.unescape(string.substring(0, n));
    }

    public static InstanceDataObject find(DataFolder dataFolder, String string, String string2) {
        FileObject fileObject = InstanceDataObject.findFO(dataFolder, string, string2);
        if (fileObject != null) {
            try {
                return (InstanceDataObject)DataObject.find(fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static InstanceDataObject find(DataFolder dataFolder, String string, Class<?> clazz) {
        return InstanceDataObject.find(dataFolder, string, clazz.getName());
    }

    public static InstanceDataObject create(DataFolder dataFolder, final String string, final String string2) throws IOException {
        final FileObject fileObject = dataFolder.getPrimaryFile();
        if (string != null && string.length() == 0) {
            throw new IOException("name cannot be empty");
        }
        FileObject fileObject2 = InstanceDataObject.findFO(dataFolder, string, string2);
        if (fileObject2 == null) {
            final FileObject[] fileObjectArray = new FileObject[1];
            DataObjectPool.getPOOL().runAtomicAction(fileObject, new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    String string3 = string == null ? FileUtil.findFreeFileName((FileObject)fileObject, (String)string2.replace('.', '-'), (String)InstanceDataObject.INSTANCE) : InstanceDataObject.escape(string);
                    fileObjectArray[0] = fileObject.createData(string3, InstanceDataObject.INSTANCE);
                    fileObjectArray[0].setAttribute(InstanceDataObject.EA_INSTANCE_CLASS, (Object)string2);
                }
            });
            fileObject2 = fileObjectArray[0];
        }
        return (InstanceDataObject)DataObject.find(fileObject2);
    }

    public static InstanceDataObject create(DataFolder dataFolder, String string, Class<?> clazz) throws IOException {
        return InstanceDataObject.create(dataFolder, string, clazz.getName());
    }

    public static InstanceDataObject create(DataFolder dataFolder, String string, Object object, ModuleInfo moduleInfo) throws IOException {
        return InstanceDataObject.create(dataFolder, string, object, moduleInfo, false);
    }

    public static InstanceDataObject create(DataFolder dataFolder, String string, Object object, ModuleInfo moduleInfo, boolean bl) throws IOException {
        if (string != null && string.length() == 0) {
            throw new IOException("name cannot be empty");
        }
        return Creator.createInstanceDataObject(dataFolder, string, object, moduleInfo, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InstanceDataObject storeSettings(DataFolder dataFolder, String string, Object object, ModuleInfo moduleInfo) throws IOException {
        InstanceDataObject instanceDataObject;
        FileObject fileObject = dataFolder.getPrimaryFile();
        FileObject fileObject2 = fileObject.getFileObject(string, XML_EXT);
        String string2 = fileObject.getPath() + '/' + string + '.' + XML_EXT;
        boolean bl = false;
        try {
            if (fileObject2 == null) {
                System.setProperty("InstanceDataObject.current.file", fileObject.getPath() + "/" + string + "." + XML_EXT);
                ByteArrayOutputStream byteArrayOutputStream = InstanceDataObject.storeThroughConvertor(object, new FileObjectContext(fileObject, string));
                System.setProperty("InstanceDataObject.current.file", "");
                createdIDOs.add(string2);
                fileObject2 = fileObject.createData(string, XML_EXT);
                FileLock fileLock = null;
                try {
                    fileLock = fileObject2.lock();
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    outputStream.write(byteArrayOutputStream.toByteArray());
                    outputStream.close();
                }
                finally {
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            } else {
                bl = true;
            }
            instanceDataObject = (InstanceDataObject)DataObject.find(fileObject2);
            instanceDataObject.attachToConvertor(object, bl);
        }
        finally {
            createdIDOs.remove(string2);
        }
        return instanceDataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean remove(DataFolder dataFolder, String string, String string2) {
        FileLock fileLock = null;
        try {
            FileObject fileObject = InstanceDataObject.findFO(dataFolder, string, string2);
            if (fileObject == null) {
                boolean bl = false;
                return bl;
            }
            fileLock = fileObject.lock();
            fileObject.delete(fileLock);
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        return true;
    }

    public static boolean remove(DataFolder dataFolder, String string, Class<?> clazz) {
        return InstanceDataObject.remove(dataFolder, string, clazz.getName());
    }

    @Override
    public HelpCtx getHelpCtx() {
        HelpCtx helpCtx = InstanceSupport.findHelp((InstanceCookie)this);
        if (helpCtx != null) {
            return helpCtx;
        }
        return HelpCtx.DEFAULT_HELP;
    }

    @Override
    protected Node createNodeDelegate() {
        if (this.getPrimaryFile().hasExt(XML_EXT)) {
            this.un = new UpdatableNode(this.createNodeDelegateImpl());
            return this.un;
        }
        return this.createNodeDelegateImpl();
    }

    private Node createNodeDelegateImpl() {
        Node node;
        try {
            if (this.getPrimaryFile().getFileSystem() != Repository.getDefault().getDefaultFileSystem()) {
                return new DataNode(this, Children.LEAF);
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            err.log(Level.WARNING, null, fileStateInvalidException);
            return new DataNode(this, Children.LEAF);
        }
        if (this.getPrimaryFile().hasExt(XML_EXT)) {
            if (null == this.getCookieFromEP(InstanceCookie.class)) {
                return new CookieAdjustingFilter((Node)new UnrecognizedSettingNode());
            }
            node = this.getCookieFromEP(Node.class);
            if (node != null) {
                return new CookieAdjustingFilter(node);
            }
        }
        try {
            if (this.instanceOf(Node.class)) {
                node = (Node)this.instanceCreate();
                return new CookieAdjustingFilter(node);
            }
            if (this.instanceOf(Node.Handle.class)) {
                node = (Node.Handle)this.instanceCreate();
                return new CookieAdjustingFilter(node.getNode());
            }
        }
        catch (IOException iOException) {
            err.log(Level.WARNING, null, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            err.log(Level.WARNING, null, classNotFoundException);
        }
        return new InstanceNode(this);
    }

    private <T> T getCookieFromEP(Class<T> clazz) {
        return (T)this.getCookiesLookup().lookup(clazz);
    }

    @Override
    void notifyFileChanged(FileEvent fileEvent) {
        super.notifyFileChanged(fileEvent);
        if (this.getPrimaryFile().hasExt(XML_EXT) && !Creator.isFiredFromMe(fileEvent)) {
            this.getCookiesLookup(true);
        }
    }

    @Override
    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        Node.Cookie cookie = null;
        if (this.getPrimaryFile().hasExt(XML_EXT)) {
            String string = this.getPrimaryFile().getPath();
            if (createdIDOs.contains(string)) {
                return null;
            }
            T t = this.getCookieFromEP(clazz);
            Node.Cookie cookie2 = cookie = t instanceof Node.Cookie ? (Node.Cookie)clazz.cast(t) : null;
            if (InstanceCookie.class.isAssignableFrom(clazz)) {
                return (T)cookie;
            }
        }
        if (cookie == null) {
            cookie = (Node.Cookie)super.getCookie(clazz);
        }
        return (T)cookie;
    }

    private Lookup getCookiesLookup() {
        return this.getCookiesLookup(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup getCookiesLookup(boolean bl) {
        Object object = this.getLock();
        synchronized (object) {
            if (!bl && this.cookiesLkp != null) {
                return this.cookiesLkp;
            }
        }
        object = Environment.findForOne(this);
        boolean bl2 = false;
        Object object2 = this.getLock();
        synchronized (object2) {
            if (this.cookiesLkp == null || object == null || !object.getClass().equals(this.cookiesLkp.getClass())) {
                this.cookiesLkp = object == null ? Lookup.EMPTY : object;
                bl2 = true;
                this.initCookieResult();
                this.initNodeResult();
            }
        }
        if (this.nodeResult != null) {
            this.nodeResult.allItems();
        }
        if (this.cookieResult != null) {
            this.cookieResult.allItems();
        }
        if (bl2) {
            this.firePropertyChange("cookie", null, null);
        }
        return this.cookiesLkp;
    }

    private void initNodeResult() {
        if (this.nodeResult != null && this.nodeLsnr != null) {
            this.nodeResult.removeLookupListener(this.nodeLsnr);
        }
        if (this.cookiesLkp != null && !this.cookiesLkp.equals(Lookup.EMPTY)) {
            this.nodeResult = this.cookiesLkp.lookupResult(InstanceCookie.class);
            this.nodeLsnr = new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    if (InstanceDataObject.this.un != null) {
                        InstanceDataObject.this.un.update();
                    }
                }
            };
            this.nodeResult.addLookupListener(this.nodeLsnr);
        }
    }

    private void initCookieResult() {
        if (this.cookieResult != null && this.cookiesLsnr != null) {
            this.cookieResult.removeLookupListener(this.cookiesLsnr);
        }
        if (this.cookiesLkp != null && !this.cookiesLkp.equals(Lookup.EMPTY)) {
            this.cookieResult = this.cookiesLkp.lookupResult(Node.Cookie.class);
            this.cookiesLsnr = new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    InstanceDataObject.this.firePropertyChange("cookie", null, null);
                }
            };
            this.cookieResult.addLookupListener(this.cookiesLsnr);
        }
    }

    private InstanceCookie.Of delegateIC() {
        Ser ser = null;
        ser = this.getPrimaryFile().hasExt(XML_EXT) ? this.getCookieFromEP(InstanceCookie.Of.class) : this.ser;
        return ser;
    }

    public String instanceName() {
        InstanceCookie.Of of = this.delegateIC();
        if (of == null) {
            return this.getName();
        }
        return of.instanceName();
    }

    public Class<?> instanceClass() throws IOException, ClassNotFoundException {
        InstanceCookie.Of of = this.delegateIC();
        if (of == null) {
            return this.getClass();
        }
        return of.instanceClass();
    }

    public boolean instanceOf(Class<?> clazz) {
        InstanceCookie.Of of = this.delegateIC();
        if (of == null) {
            return clazz.isAssignableFrom(this.getClass());
        }
        return of.instanceOf(clazz);
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        InstanceCookie.Of of = this.delegateIC();
        if (of == null) {
            return this;
        }
        return of.instanceCreate();
    }

    final boolean creatorOf(Object object) {
        InstanceCookie.Of of = this.delegateIC();
        if (of instanceof Ser) {
            return ((Ser)of).creatorOf(object);
        }
        return false;
    }

    @Override
    public String getName() {
        if (this.nameCache != null) {
            return this.nameCache;
        }
        String string = (String)this.getPrimaryFile().getAttribute(EA_NAME);
        if (string == null) {
            string = super.getName();
            int n = string.indexOf(91);
            if (n == -1) {
                string = InstanceDataObject.unescape(string);
            } else {
                InstanceDataObject.warnAboutBrackets(this.getPrimaryFile());
                string = InstanceDataObject.unescape(string.substring(0, n));
            }
        }
        this.nameCache = string;
        return string;
    }

    private static void warnAboutBrackets(FileObject fileObject) {
        if (warnedAboutBrackets.add(fileObject)) {
            err.warning("Use of [] in " + fileObject + " is deprecated.");
            err.warning("(Please use the string-valued file attribute instanceClass instead.)");
        }
    }

    @Override
    protected FileObject handleRename(String string) throws IOException {
        FileObject fileObject = this.getPrimaryFile();
        fileObject.setAttribute(EA_NAME, (Object)string);
        return fileObject;
    }

    static String escape(String string) {
        boolean bl = string.startsWith(" ") || string.endsWith(" ") || string.indexOf("  ") != -1;
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '/' || c == ':' || c == '\\' || c == '[' || c == ']' || c == '<' || c == '>' || c == '?' || c == '*' || c == '|' || c == ' ' && bl || c == '.' || c == '\"' || c < ' ' || c > '~' || c == '#') {
                stringBuffer.append('#');
                String string2 = Integer.toString(c, 16).toUpperCase(Locale.ENGLISH);
                if (string2.length() < 4) {
                    stringBuffer.append('0');
                }
                if (string2.length() < 3) {
                    stringBuffer.append('0');
                }
                if (string2.length() < 2) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static String unescape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '#') {
                if (i + 4 >= n) {
                    err.warning("trailing garbage in instance name: " + string);
                    break;
                }
                try {
                    char[] cArray = new char[4];
                    string.getChars(i + 1, i + 5, cArray, 0);
                    stringBuffer.append((char)Integer.parseInt(new String(cArray), 16));
                }
                catch (NumberFormatException numberFormatException) {
                    err.log(Level.WARNING, null, numberFormatException);
                }
                i += 4;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static String escapeAndCut(String string) {
        int n = 50;
        String string2 = InstanceDataObject.escape(string);
        if (string2.length() <= n) {
            return string2;
        }
        String string3 = Integer.toHexString(string2.hashCode()).toUpperCase(Locale.ENGLISH);
        String string4 = string2.substring(0, n = n > string3.length() ? (n - string3.length()) / 2 : 1);
        if (string4.endsWith("#")) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        String string5 = string2.substring(string2.length() - n);
        return string4 + string3 + string5;
    }

    final void scheduleSave() {
        if (this.isSavingCanceled() || !this.getPrimaryFile().hasExt(SER_EXT)) {
            return;
        }
        this.doFileLock();
        this.ser.getSaveTask().schedule(2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLock doFileLock() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.fileLock != null) {
                return this.fileLock;
            }
            try {
                this.fileLock = this.getPrimaryFile().lock();
            }
            catch (IOException iOException) {
                err.log(Level.WARNING, this.getPrimaryFile().toString());
                err.log(Level.WARNING, null, iOException);
            }
            return this.fileLock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void relaseFileLock() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.fileLock == null) {
                return;
            }
            this.fileLock.releaseLock();
            this.fileLock = null;
        }
    }

    @Override
    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        try {
            if (this.getPrimaryFile().hasExt(XML_EXT)) {
                InstanceCookie instanceCookie = this.getCookie(InstanceCookie.class);
                Object object = instanceCookie.instanceCreate();
                InstanceDataObject instanceDataObject = this.createSettingsFile(dataFolder, string, object);
                this.attachToConvertor(null);
                return instanceDataObject;
            }
            if (!this.getPrimaryFile().hasExt(INSTANCE) && Serializable.class.isAssignableFrom(this.instanceClass())) {
                InstanceCookie instanceCookie = this.getCookie(InstanceCookie.class);
                Object object = instanceCookie.instanceCreate();
                return DataObject.find(this.createSerFile(dataFolder, string, object));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            err.log(Level.WARNING, null, classNotFoundException);
        }
        return super.handleCreateFromTemplate(dataFolder, string);
    }

    @Override
    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        if (this.getPrimaryFile().getFileSystem().isDefault()) {
            try {
                InstanceCookie instanceCookie;
                if (this.getPrimaryFile().hasExt(XML_EXT)) {
                    InstanceCookie instanceCookie2 = this.getCookie(InstanceCookie.class);
                    if (instanceCookie2 != null) {
                        Object object = instanceCookie2.instanceCreate();
                        InstanceDataObject instanceDataObject = this.createSettingsFile(dataFolder, this.getNodeDelegate().getDisplayName(), object);
                        instanceDataObject.attachToConvertor(null);
                        return instanceDataObject;
                    }
                } else if (!this.getPrimaryFile().hasExt(INSTANCE) && Serializable.class.isAssignableFrom(this.instanceClass()) && (instanceCookie = this.getCookie(InstanceCookie.class)) != null) {
                    Object object = instanceCookie.instanceCreate();
                    return DataObject.find(this.createSerFile(dataFolder, this.getNodeDelegate().getDisplayName(), object));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                err.log(Level.WARNING, null, classNotFoundException);
            }
        }
        return super.handleCopy(dataFolder);
    }

    private boolean isSavingCanceled() {
        return this.savingCanceled;
    }

    @Override
    protected void dispose() {
        if (this.getPrimaryFile().hasExt(SER_EXT)) {
            RequestProcessor.Task task;
            this.savingCanceled = true;
            if (this.ser != null && ((task = this.ser.getSaveTask()).getDelay() > 0 || this.ser.isSaving() && !task.isFinished())) {
                task.waitFinished();
            }
            this.relaseFileLock();
        } else if (this.getPrimaryFile().hasExt(XML_EXT)) {
            SaveCookie saveCookie = this.getCookie(SaveCookie.class);
            try {
                if (saveCookie != null) {
                    saveCookie.save();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.dispose();
    }

    @Override
    protected void handleDelete() throws IOException {
        this.savingCanceled = true;
        if (this.getPrimaryFile().hasExt(XML_EXT)) {
            this.handleDeleteSettings();
            return;
        }
        if (this.ser != null) {
            RequestProcessor.Task task = this.ser.getSaveTask();
            task.cancel();
            if (this.ser.isSaving() && !task.isFinished()) {
                task.waitFinished();
            }
        }
        this.relaseFileLock();
        super.handleDelete();
    }

    private void handleDeleteSettings() throws IOException {
        SaveCookie saveCookie = this.getCookie(SaveCookie.class);
        try {
            if (saveCookie != null) {
                saveCookie.save();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.handleDelete();
    }

    private InstanceDataObject createSettingsFile(DataFolder dataFolder, String string, Object object) throws IOException {
        String string2;
        Object object2;
        boolean bl = false;
        if (object instanceof ServiceType) {
            bl = true;
            object2 = (ServiceType)object;
            String string3 = string = string == null ? object2.getName() : string;
            ServiceType.Registry registry = (ServiceType.Registry)Lookup.getDefault().lookup(ServiceType.Registry.class);
            int n = 1;
            while (registry.find(string3) != null) {
                string3 = new StringBuffer(string.length() + 2).append(string).append('_').append(n).toString();
                ++n;
            }
            if (!string3.equals(object2.getName())) {
                object = object2 = object2.createClone();
                object2.setName(string3);
            }
            string2 = InstanceDataObject.escapeAndCut(string3);
        } else {
            string2 = string == null ? this.getPrimaryFile().getName() : InstanceDataObject.escapeAndCut(string);
        }
        string2 = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)string2, (String)this.getPrimaryFile().getExt());
        object2 = InstanceDataObject.storeSettings(dataFolder, string2, object, null);
        if (string != null && !bl) {
            ((DataObject)object2).getPrimaryFile().setAttribute(EA_NAME, (Object)string);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject createSerFile(DataFolder dataFolder, String string, Object object) throws IOException {
        FileLock fileLock = null;
        OutputStream outputStream = null;
        FileObject fileObject = null;
        try {
            FileObject fileObject2 = dataFolder.getPrimaryFile();
            if (string == null) {
                string = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)this.getPrimaryFile().getName(), (String)this.getPrimaryFile().getExt());
            }
            if ((fileObject = fileObject2.getFileObject(string, SER_EXT)) == null) {
                fileObject = fileObject2.createData(string, SER_EXT);
            }
            fileLock = fileObject.lock();
            outputStream = fileObject.getOutputStream(fileLock);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        return fileObject;
    }

    final void setCustomClassLoader(ClassLoader classLoader) {
        if (this.ser instanceof Ser) {
            this.ser.setCustomClassLoader(classLoader);
        }
    }

    private static ByteArrayOutputStream storeThroughConvertor(Object object, FileObjectContext fileObjectContext) throws IOException {
        FileObject fileObject = InstanceDataObject.resolveConvertor(object);
        Object object2 = fileObject.getAttribute("settings.convertor");
        if (object2 == null) {
            throw new IOException("missing attribute settings.convertor");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
        InstanceDataObject.convertorWriteMethod(object2, new WriterProvider(outputStreamWriter, fileObjectContext), object);
        ((Writer)outputStreamWriter).close();
        return byteArrayOutputStream;
    }

    private static void convertorWriteMethod(Object object, Writer writer, Object object2) throws IOException {
        Throwable throwable;
        block5: {
            throwable = null;
            try {
                Method method = object.getClass().getMethod("write", Writer.class, Object.class);
                method.setAccessible(true);
                method.invoke(object, writer, object2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throwable = noSuchMethodException;
            }
            catch (IllegalAccessException illegalAccessException) {
                throwable = illegalAccessException;
            }
            catch (InvocationTargetException invocationTargetException) {
                throwable = invocationTargetException.getTargetException();
                if (!(throwable instanceof IOException)) break block5;
                throw (IOException)throwable;
            }
        }
        if (throwable != null) {
            throw (IOException)new IOException("Problem with Convertor.write method. " + throwable).initCause(throwable);
        }
    }

    private static FileObject resolveConvertor(Object object) throws IOException {
        Class<?> clazz;
        String string = "xml/memory";
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(string);
        if (fileObject == null) {
            throw new FileNotFoundException("SFS:xml/memory while converting a " + object.getClass().getName());
        }
        Class<?> clazz2 = clazz = object.getClass();
        while (clazz2 != null) {
            String string2 = clazz2.getName();
            String string3 = new StringBuffer(200).append(string).append('/').append(string2.replace('.', '/')).toString();
            FileObject fileObject2 = fileSystem.findResource(string3);
            if (fileObject2 != null) {
                boolean bl;
                Object object2;
                String string4 = (String)fileObject2.getAttribute(EA_PROVIDER_PATH);
                if (string4 == null) {
                    clazz2 = clazz2.getSuperclass();
                    continue;
                }
                if (clazz2.equals(clazz) || Object.class.equals(clazz2)) {
                    object2 = fileSystem.findResource(string4);
                    if (object2 == null) {
                        throw new FileNotFoundException("Invalid settings.providerPath under SFS/xml/memory/ for " + clazz);
                    }
                    return object2;
                }
                object2 = fileObject2.getAttribute(EA_SUBCLASSES);
                if (object2 instanceof Boolean && (bl = ((Boolean)object2).booleanValue())) {
                    FileObject fileObject3 = fileSystem.findResource(string4);
                    if (fileObject3 == null) {
                        throw new FileNotFoundException("Invalid settings.providerPath under SFS/xml/memory/ for " + clazz);
                    }
                    return fileObject3;
                }
            }
            clazz2 = clazz2.getSuperclass();
        }
        throw new FileNotFoundException("None convertor was found under SFS/xml/memory/ for " + clazz);
    }

    private void attachToConvertor(Object object) throws IOException {
        this.attachToConvertor(object, false);
    }

    private void attachToConvertor(Object object, boolean bl) throws IOException {
        Object object2 = this.getCookiesLookup().lookup(InstanceCookie.class);
        if (object2 == null) {
            throw new IllegalStateException("Trying to store object " + object + " which most probably belongs to already disabled module!");
        }
        InstanceDataObject.convertorSetInstanceMethod(object2, object, bl);
    }

    private static void convertorSetInstanceMethod(Object object, Object object2, boolean bl) throws IOException {
        ReflectiveOperationException reflectiveOperationException;
        block5: {
            reflectiveOperationException = null;
            try {
                Method method = object.getClass().getMethod("setInstance", Object.class, Boolean.TYPE);
                method.setAccessible(true);
                method.invoke(object, object2, bl ? Boolean.TRUE : Boolean.FALSE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                reflectiveOperationException = noSuchMethodException;
            }
            catch (IllegalAccessException illegalAccessException) {
                reflectiveOperationException = illegalAccessException;
            }
            catch (InvocationTargetException invocationTargetException) {
                reflectiveOperationException = invocationTargetException;
                if (!(invocationTargetException.getTargetException() instanceof IOException)) break block5;
                throw (IOException)invocationTargetException.getTargetException();
            }
        }
        if (reflectiveOperationException != null) {
            Exceptions.attachLocalizedMessage((Throwable)reflectiveOperationException, (String)("Problem with InstanceCookie.setInstance method: " + object.getClass()));
            err.log(Level.WARNING, null, reflectiveOperationException);
        }
    }

    @Override
    void notifyAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        this.nameCache = null;
        super.notifyAttributeChanged(fileAttributeEvent);
    }

    private final class CookieAdjustingFilter
    extends FilterNode {
        public CookieAdjustingFilter(Node node) {
            super(node, null, (Lookup)new ProxyLookup(new Lookup[]{node.getLookup(), Lookups.singleton((Object)InstanceDataObject.this)}));
        }

        public Node.Handle getHandle() {
            return this.getOriginal().getHandle();
        }

        public boolean equals(Object object) {
            return this == object || this.getOriginal().equals(object) || object != null && object.equals(this.getOriginal());
        }

        public int hashCode() {
            return this.getOriginal().hashCode();
        }
    }

    private static class Creator
    implements FileSystem.AtomicAction {
        private ModuleInfo mi = null;
        private DataFolder folder = null;
        private Object instance = null;
        private String name = null;
        private InstanceDataObject result = null;
        private boolean create;
        private static final Creator me = new Creator();

        private Creator() {
        }

        public void run() throws IOException {
            FileObject fileObject = this.folder.getPrimaryFile();
            String string = this.name;
            if (string == null) {
                string = this.instance.getClass().getName().replace('.', '-');
                string = FileUtil.findFreeFileName((FileObject)fileObject, (String)string, (String)InstanceDataObject.XML_EXT);
            } else {
                String string2 = InstanceDataObject.escape(string);
                FileObject fileObject2 = fileObject.getFileObject(string2, InstanceDataObject.XML_EXT);
                string = fileObject2 == null ? InstanceDataObject.escapeAndCut(string) : string2;
                if (this.create) {
                    string = FileUtil.findFreeFileName((FileObject)fileObject, (String)string, (String)InstanceDataObject.XML_EXT);
                }
            }
            this.result = InstanceDataObject.storeSettings(this.folder, string, this.instance, this.mi);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static InstanceDataObject createInstanceDataObject(DataFolder dataFolder, String string, Object object, ModuleInfo moduleInfo, boolean bl) throws IOException {
            Creator creator = me;
            synchronized (creator) {
                Creator.me.mi = moduleInfo;
                Creator.me.folder = dataFolder;
                Creator.me.instance = object;
                Creator.me.name = string;
                Creator.me.create = bl;
                DataObjectPool.getPOOL().runAtomicActionSimple(dataFolder.getPrimaryFile(), me);
                Creator.me.mi = null;
                Creator.me.folder = null;
                Creator.me.instance = null;
                Creator.me.name = null;
                InstanceDataObject instanceDataObject = Creator.me.result;
                Creator.me.result = null;
                return instanceDataObject;
            }
        }

        public static boolean isFiredFromMe(FileEvent fileEvent) {
            return fileEvent.firedFrom((FileSystem.AtomicAction)me);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FileObjectContext
    extends FileObject {
        private static final String UNSUPPORTED = "The Restricted FileObject implementation allowing to get just read-only informations about name and location. It should prevent any manipulation with file or its content.";
        private final FileObject fo;
        private final FileObject parent;
        private final String name;

        public FileObjectContext(FileObject fileObject, String string) {
            this.parent = fileObject;
            this.name = string;
            this.fo = fileObject.getFileObject(string, InstanceDataObject.XML_EXT);
        }

        public void addFileChangeListener(FileChangeListener fileChangeListener) {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public FileObject createData(String string, String string2) throws IOException {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public FileObject createFolder(String string) throws IOException {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public void delete(FileLock fileLock) throws IOException {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public Object getAttribute(String string) {
            return this.fo == null ? null : this.fo.getAttribute(string);
        }

        public Enumeration<String> getAttributes() {
            return this.fo == null ? Enumerations.empty() : this.fo.getAttributes();
        }

        public FileObject[] getChildren() {
            return new FileObject[0];
        }

        public String getExt() {
            return InstanceDataObject.XML_EXT;
        }

        public FileObject getFileObject(String string, String string2) {
            return null;
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            return this.parent.getFileSystem();
        }

        public InputStream getInputStream() throws FileNotFoundException {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public String getName() {
            return this.name;
        }

        public OutputStream getOutputStream(FileLock fileLock) throws IOException {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public FileObject getParent() {
            return this.parent;
        }

        public long getSize() {
            return this.fo == null ? 0L : this.fo.getSize();
        }

        public boolean isData() {
            return true;
        }

        public boolean isFolder() {
            return false;
        }

        public boolean isReadOnly() {
            return this.parent.isReadOnly();
        }

        public boolean isRoot() {
            return false;
        }

        public boolean isValid() {
            return this.fo == null ? false : this.fo.isValid();
        }

        public Date lastModified() {
            return this.fo == null ? this.parent.lastModified() : this.fo.lastModified();
        }

        public FileLock lock() throws IOException {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public void removeFileChangeListener(FileChangeListener fileChangeListener) {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public void rename(FileLock fileLock, String string, String string2) throws IOException {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public void setAttribute(String string, Object object) throws IOException {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }

        public void setImportant(boolean bl) {
            throw new UnsupportedOperationException(UNSUPPORTED);
        }
    }

    private static final class Ser
    extends InstanceSupport
    implements Runnable {
        private Reference<Object> bean = new SoftReference<Object>(null);
        private long saveTime;
        private ClassLoader customClassLoader = null;
        private InstanceDataObject dobj;
        private RequestProcessor.Task task;
        private boolean saving = false;

        public Ser(InstanceDataObject instanceDataObject) {
            super(instanceDataObject.getPrimaryEntry());
            this.dobj = instanceDataObject;
        }

        public String instanceName() {
            Object object;
            FileObject fileObject = this.entry().getFile();
            if (fileObject.lastModified().getTime() <= this.saveTime && (object = this.bean.get()) != null) {
                return object.getClass().getName();
            }
            if (!fileObject.hasExt(InstanceDataObject.INSTANCE)) {
                return super.instanceName();
            }
            return Ser.getClassName(fileObject);
        }

        private static String getClassName(FileObject fileObject) {
            int n;
            Object object = fileObject.getAttribute(InstanceDataObject.EA_INSTANCE_CLASS);
            if (object instanceof String) {
                return Utilities.translate((String)((String)object));
            }
            if (object != null) {
                err.warning("instanceClass was a " + object.getClass().getName());
            }
            if ((object = fileObject.getAttribute(InstanceDataObject.EA_INSTANCE_CREATE)) != null) {
                return object.getClass().getName();
            }
            String string = fileObject.getName();
            int n2 = string.indexOf(91) + 1;
            if (n2 != 0) {
                InstanceDataObject.warnAboutBrackets(fileObject);
            }
            if ((n = string.indexOf(93)) < 0) {
                n = string.length();
            }
            if (n2 < n) {
                string = string.substring(n2, n);
            }
            string = string.replace('-', '.');
            string = Utilities.translate((String)string);
            return string;
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return super.instanceClass(this.customClassLoader);
        }

        public boolean instanceOf(Class clazz) {
            Object object;
            FileObject fileObject = this.entry().getFile();
            if (fileObject.lastModified().getTime() <= this.saveTime && (object = this.bean.get()) != null) {
                return clazz.isInstance(object);
            }
            object = Ser.inListOfClasses(clazz, this.entry().getFile());
            if (object == null) {
                return super.instanceOf(clazz);
            }
            return (Boolean)object;
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            FileObject fileObject = this.entry().getFile();
            Object object = fileObject.lastModified().getTime() <= this.saveTime ? this.bean.get() : null;
            if (object != null) {
                return object;
            }
            this.saveTime = fileObject.lastModified().getTime();
            if (this.saveTime < System.currentTimeMillis()) {
                this.saveTime = System.currentTimeMillis();
            }
            if (fileObject.hasExt(InstanceDataObject.INSTANCE)) {
                object = fileObject.getAttribute(InstanceDataObject.EA_INSTANCE_CREATE);
            }
            if (object == null) {
                object = super.instanceCreate();
            }
            this.bean = new SoftReference<Object>(object);
            return object;
        }

        final boolean creatorOf(Object object) {
            Reference<Object> reference = this.bean;
            return reference != null && reference.get() == object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.saving = true;
                this.runImpl();
            }
            finally {
                this.dobj.relaseFileLock();
                this.saving = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runImpl() {
            Object object = this.bean.get();
            if (object == null) {
                return;
            }
            try {
                FileLock fileLock = this.dobj.doFileLock();
                if (fileLock == null) {
                    return;
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.entry().getFile().getOutputStream(fileLock));
                try {
                    objectOutputStream.writeObject(object);
                    this.saveTime = this.entry().getFile().lastModified().getTime();
                }
                finally {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {
                err.log(Level.WARNING, NbBundle.getMessage(InstanceDataObject.class, (String)"EXC_CannotSaveBean", (Object)this.instanceName(), (Object)this.entry().getFile().getPath()), iOException);
            }
        }

        private static Boolean inListOfClasses(Class clazz, FileObject fileObject) {
            Object object = fileObject.getAttribute(InstanceDataObject.EA_INSTANCE_OF);
            if (object instanceof String) {
                String string = clazz.getName();
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, "\n\t ,;:");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    if (!string.equals(string2)) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (object != null) {
                err.warning("instanceOf was a " + object.getClass().getName());
            }
            return null;
        }

        final void setCustomClassLoader(ClassLoader classLoader) {
            this.customClassLoader = classLoader;
        }

        public RequestProcessor.Task getSaveTask() {
            if (this.task == null) {
                this.task = PROCESSOR.create((Runnable)this);
            }
            return this.task;
        }

        public boolean isSaving() {
            return this.saving;
        }
    }

    private final class UnrecognizedSettingNode
    extends AbstractNode {
        public UnrecognizedSettingNode() {
            super(Children.LEAF);
            this.setName(NbBundle.getMessage(InstanceDataObject.class, (String)"LBL_BrokenSettings"));
            this.setIconBaseWithExtension("org/openide/loaders/instanceBroken.gif");
            this.setShortDescription(InstanceDataObject.this.getPrimaryFile().toString());
        }

        public boolean canDestroy() {
            return true;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        public void destroy() throws IOException {
            InstanceDataObject.this.delete();
        }

        protected SystemAction[] createActions() {
            return new SystemAction[]{SystemAction.get(DeleteAction.class)};
        }
    }

    private final class UpdatableNode
    extends FilterNode {
        public UpdatableNode(Node node) {
            super(node);
        }

        public void update() {
            FilterNode.Children.MUTEX.postWriteRequest(new Runnable(){

                public void run() {
                    UpdatableNode.this.changeOriginal(InstanceDataObject.this.createNodeDelegateImpl(), true);
                }
            });
        }
    }

    private static final class WriterProvider
    extends Writer
    implements Lookup.Provider {
        private final Writer orig;
        private final FileObjectContext ctx;
        private Lookup lookup;

        public WriterProvider(Writer writer, FileObjectContext fileObjectContext) {
            this.orig = writer;
            this.ctx = fileObjectContext;
        }

        public void close() throws IOException {
            this.orig.close();
        }

        public void flush() throws IOException {
            this.orig.flush();
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            this.orig.write(cArray, n, n2);
        }

        public Lookup getLookup() {
            if (this.lookup == null) {
                this.lookup = Lookups.singleton((Object)((Object)this.ctx));
            }
            return this.lookup;
        }
    }
}

