/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.diff;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.queries.FileEncodingQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.io.ReaderInputStream;
import org.openide.util.lookup.Lookups;

public abstract class StreamSource {
    public abstract String getName();

    public abstract String getTitle();

    public abstract String getMIMEType();

    public boolean isEditable() {
        return false;
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[0]);
    }

    public abstract Reader createReader() throws IOException;

    public abstract Writer createWriter(Difference[] var1) throws IOException;

    public void close() {
    }

    public static StreamSource createSource(String string, String string2, String string3, Reader reader) {
        return new Impl(string, string2, string3, reader);
    }

    public static StreamSource createSource(String string, String string2, String string3, File file) {
        return new Impl(string, string2, string3, file);
    }

    private static void copyStreamsCloseAll(Writer writer, Reader reader) throws IOException {
        int n;
        char[] cArray = new char[4096];
        while ((n = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n);
        }
        writer.close();
        reader.close();
    }

    private static class Impl
    extends StreamSource {
        private String name;
        private String title;
        private String MIMEType;
        private Reader r;
        private File readerSource;
        private Writer w;
        private File file;
        private Charset encoding;

        Impl(String string, String string2, String string3, Reader reader) {
            this.name = string;
            this.title = string2;
            this.MIMEType = string3;
            this.r = reader;
            this.readerSource = null;
            this.w = null;
            this.file = null;
            if (reader instanceof InputStreamReader) {
                try {
                    this.encoding = Charset.forName(((InputStreamReader)reader).getEncoding());
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    // empty catch block
                }
            }
        }

        Impl(String string, String string2, String string3, File file) {
            this.name = string;
            this.title = string2;
            this.MIMEType = string3;
            this.readerSource = null;
            this.w = null;
            this.file = file;
            this.encoding = FileEncodingQuery.getEncoding((FileObject)FileUtil.toFileObject((File)file));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File createReaderSource(Reader reader) throws IOException {
            File file = null;
            file = FileUtil.normalizeFile((File)File.createTempFile("sss", "tmp"));
            file.deleteOnExit();
            file.createNewFile();
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                if (this.encoding == null) {
                    inputStream = new ReaderInputStream(reader);
                } else {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    StreamSource.copyStreamsCloseAll(new OutputStreamWriter((OutputStream)byteArrayOutputStream, this.encoding), reader);
                    inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                }
                outputStream = new FileOutputStream(file);
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            return file;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public String getMIMEType() {
            return this.MIMEType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Reader createReader() throws IOException {
            if (this.file != null) {
                return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding));
            }
            Impl impl = this;
            synchronized (impl) {
                if (this.r != null) {
                    this.readerSource = this.createReaderSource(this.r);
                    this.r = null;
                }
            }
            if (this.encoding == null) {
                return new BufferedReader(new FileReader(this.readerSource));
            }
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.readerSource), this.encoding));
        }

        public Writer createWriter(Difference[] differenceArray) throws IOException {
            if (differenceArray != null && differenceArray.length > 0) {
                return null;
            }
            if (this.file != null) {
                if (this.encoding == null) {
                    return new BufferedWriter(new FileWriter(this.file));
                }
                return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), this.encoding));
            }
            return this.w;
        }
    }
}

