/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JOptionPane;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.common.util.Text;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.ContentPane;
import nickyb.sqleonardo.environment.ctrl.content.ContentChanges;
import nickyb.sqleonardo.environment.ctrl.content.TableMetaData;
import nickyb.sqleonardo.environment.ctrl.editor._TaskSource;

public class TaskUpdate
implements Runnable {
    private ContentPane target;
    private _TaskSource source;
    private PreparedStatement pstmt = null;

    public TaskUpdate(ContentPane target, _TaskSource source) {
        this.target = target;
        this.source = source;
    }

    private TableMetaData getTableMetaData() {
        return (TableMetaData)this.source;
    }

    public void run() {
        int whereCols = this.getTableMetaData().getPrimaryKeys().size();
        String preparedWhere = new String(" WHERE ");
        ArrayList<Integer> whereColsIDX = new ArrayList<Integer>();
        for (int i = 0; i < whereCols; ++i) {
            String colName = this.getTableMetaData().getPrimaryKeyProperty(i, 3);
            int idx = this.target.getView().getColumnIndex(colName);
            if (idx >= 0) {
                preparedWhere = preparedWhere + colName + " = ? AND ";
                whereColsIDX.add(new Integer(idx));
                continue;
            }
            --whereCols;
        }
        preparedWhere = preparedWhere.substring(0, preparedWhere.length() - 5);
        int exceptions = 0;
        while (this.target.getView().getChanges().count() > exceptions) {
            int i;
            StringBuffer sql = new StringBuffer();
            Vector<Object[]> data = new Vector<Object[]>();
            ContentChanges.Handler handler = this.target.getView().getChanges().getHandlerAt(exceptions);
            Object[] rowdata = this.target.getView().getValues(handler.rid);
            if (handler.type.equals(ContentChanges.INSERT)) {
                sql.append(") VALUES (");
                for (i = rowdata.length - 1; i >= 0; --i) {
                    Object cell = rowdata[i];
                    if (rowdata[i] instanceof Object[]) {
                        cell = ((Object[])rowdata[i])[0];
                    }
                    sql.insert(0, "," + this.target.getView().getColumnName(i));
                    sql.append("?,");
                    data.insertElementAt(new Object[]{cell, new Integer(this.target.getView().getColumnType(i))}, 0);
                }
                sql.replace(0, 1, "INSERT INTO " + this.getTableMetaData().getIdentifier() + " (");
                sql.setCharAt(sql.length() - 1, ')');
            } else {
                if (handler.type.equals(ContentChanges.DELETE)) {
                    sql.append("DELETE FROM " + this.getTableMetaData().getIdentifier());
                } else if (handler.type.equals(ContentChanges.UPDATE)) {
                    sql.append("UPDATE " + this.getTableMetaData().getIdentifier() + " SET ");
                    for (int i2 = 0; i2 < rowdata.length; ++i2) {
                        if (!(rowdata[i2] instanceof Object[])) continue;
                        Object cell = ((Object[])rowdata[i2])[0];
                        data.addElement(new Object[]{cell, new Integer(this.target.getView().getColumnType(i2))});
                        sql.append(this.target.getView().getColumnName(i2) + " = ?,");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                }
                sql.append(preparedWhere);
                for (i = 0; i < whereCols; ++i) {
                    int col = (Integer)whereColsIDX.get(i);
                    Object cell = rowdata[col];
                    if (cell instanceof Object[]) {
                        cell = ((Object[])cell)[1];
                    }
                    data.addElement(new Object[]{cell, new Integer(this.target.getView().getColumnType(i))});
                }
            }
            try {
                this.close();
            }
            catch (Exception e) {
                Application.println(e, true);
            }
            try {
                this.execute(sql.toString(), data);
                for (int i3 = 0; i3 < rowdata.length; ++i3) {
                    Object cell;
                    if (!(rowdata[i3] instanceof Object[])) continue;
                    rowdata[i3] = cell = ((Object[])rowdata[i3])[0];
                }
                this.target.getView().getChanges().removeHandlerAt(exceptions);
            }
            catch (Exception e) {
                if (!this.alert(e)) break;
                ++exceptions;
            }
        }
        this.target.getView().onTableChanged(true);
        this.target.onEndTask();
    }

    private boolean alert(Exception e) {
        String title = e.getClass().getName();
        String message = Text.wrap(e.toString(), 75);
        return JOptionPane.showConfirmDialog(Application.window, message = message + "\ndo you want continue?", title, 0) == 0;
    }

    private void close() throws Exception {
        if (this.pstmt != null) {
            this.pstmt.close();
            this.pstmt = null;
        }
    }

    private void execute(String sql, Vector data) throws Exception {
        ConnectionHandler ch = ConnectionAssistant.getHandler(this.source.getHandlerKey());
        this.pstmt = ch.get().prepareStatement(sql);
        for (int i = 0; i < data.size(); ++i) {
            Object[] param = (Object[])data.elementAt(i);
            this.pstmt.setObject(i + 1, param[0], (Integer)param[1]);
        }
        this.pstmt.executeUpdate();
        this.close();
    }
}

