/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target.scope;

import org.springframework.aop.target.AbstractPrototypeBasedTargetSource;
import org.springframework.aop.target.scope.ScopeMap;
import org.springframework.aop.target.scope.ScopingConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;

public class ScopedTargetSource
extends AbstractPrototypeBasedTargetSource
implements ScopingConfig {
    private String scopeKey;
    private ScopeMap scopeMap;

    public void setScopeMap(ScopeMap scopeMap) {
        this.scopeMap = scopeMap;
    }

    public ScopeMap getScopeMap() {
        return this.scopeMap;
    }

    public void setScopeKey(String sessionEntryName) {
        this.scopeKey = sessionEntryName;
    }

    public String getScopeKey() {
        return this.scopeKey;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(beanFactory);
        if (this.scopeKey == null) {
            this.scopeKey = this.getClass().getName() + "_" + this.getTargetBeanName() + "_" + System.identityHashCode(this);
        }
    }

    public Object getTarget() throws Exception {
        Object o = this.scopeMap.get(this.scopeKey);
        if (o == null) {
            this.logger.info((Object)("Creating new scoped instance of object with name '" + this.scopeKey + "'"));
            o = this.newPrototypeInstance();
            this.scopeMap.put(this.scopeKey, o);
        }
        return o;
    }

    public void copyFrom(ScopedTargetSource other) {
        super.copyFrom(other);
        this.scopeKey = other.scopeKey;
        this.scopeMap = other.scopeMap;
    }

    public String toString() {
        return "ScopedTargetSource: scopeKey='" + this.scopeKey + "'; scopeMap=[" + this.scopeMap + "]";
    }
}

