/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline;

import com.jaspersoft.ireport.designer.JrxmlVisualView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class OutlineTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private static OutlineTopComponent instance;
    private static final String PREFERRED_ID = "OutlineTopComponent";
    private final InstanceContent ic;
    private final Lookup lookup;
    private BeanTreeView view;
    private final ExplorerManager manager = new ExplorerManager();
    private JrxmlVisualView currentJrxmlVisualView = null;
    private boolean updatingSelection = false;
    private AbstractNode noReportNode = null;

    public synchronized boolean isUpdatingSelection() {
        return this.updatingSelection;
    }

    public synchronized void setUpdatingSelection(boolean updatingSelection) {
        this.updatingSelection = updatingSelection;
    }

    private OutlineTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(OutlineTopComponent.class, (String)"CTL_OutlineTopComponent"));
        this.setToolTipText(NbBundle.getMessage(OutlineTopComponent.class, (String)"HINT_OutlineTopComponent"));
        this.ic = new InstanceContent();
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.ic);
        this.noReportNode = new AbstractNode(Children.LEAF);
        this.noReportNode.setDisplayName("Outline not available");
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        this.associateLookup((Lookup)new ProxyLookup(new Lookup[]{this.lookup, ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map)}));
        this.setLayout(new BorderLayout());
        this.view = new BeanTreeView();
        this.add((Component)this.view, "Center");
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    if (OutlineTopComponent.this.isUpdatingSelection()) {
                        return;
                    }
                    if (OutlineTopComponent.this.getCurrentJrxmlVisualView() != null) {
                        OutlineTopComponent.this.getCurrentJrxmlVisualView().setSelectedNodes(OutlineTopComponent.this.getExplorerManager().getSelectedNodes());
                    }
                }
            }
        });
        this.getExplorerManager().setRootContext((Node)this.noReportNode);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 466, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 411, Short.MAX_VALUE));
    }

    public static synchronized OutlineTopComponent getDefault() {
        if (instance == null) {
            instance = new OutlineTopComponent();
        }
        return instance;
    }

    public static synchronized OutlineTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(OutlineTopComponent.class.getName()).warning("Cannot find OutlineTopComponent component. It will not be located properly in the window system.");
            return OutlineTopComponent.getDefault();
        }
        if (win instanceof OutlineTopComponent) {
            return (OutlineTopComponent)win;
        }
        Logger.getLogger(OutlineTopComponent.class.getName()).warning("There seem to be multiple components with the 'OutlineTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return OutlineTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public JrxmlVisualView getCurrentJrxmlVisualView() {
        return this.currentJrxmlVisualView;
    }

    public void closingJrxmlVisualView(JrxmlVisualView jrxmlVisualView) {
        if (jrxmlVisualView != this.currentJrxmlVisualView) {
            return;
        }
        this.setCurrentJrxmlVisualView(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentJrxmlVisualView(JrxmlVisualView currentJrxmlVisualView) {
        if (this.currentJrxmlVisualView != null) {
            this.ic.remove((Object)this.currentJrxmlVisualView.getReportDesignerPanel());
        }
        if (currentJrxmlVisualView == null) {
            this.currentJrxmlVisualView = null;
            this.getExplorerManager().setRootContext((Node)this.noReportNode);
        }
        if (currentJrxmlVisualView != this.currentJrxmlVisualView) {
            try {
                this.currentJrxmlVisualView = currentJrxmlVisualView;
                this.ic.add((Object)this.currentJrxmlVisualView.getReportDesignerPanel());
                this.setUpdatingSelection(true);
                if (currentJrxmlVisualView.getModel() != null) {
                    this.getExplorerManager().setRootContext((Node)currentJrxmlVisualView.getModel());
                    this.getExplorerManager().setSelectedNodes(currentJrxmlVisualView.getExplorerManager().getSelectedNodes());
                } else if (currentJrxmlVisualView.isLoading()) {
                    AbstractNode an = new AbstractNode(Children.LEAF);
                    an.setDisplayName("Loading report...");
                    this.getExplorerManager().setRootContext((Node)an);
                } else {
                    this.getExplorerManager().setRootContext(currentJrxmlVisualView.getExplorerManager().getRootContext());
                }
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                this.setUpdatingSelection(false);
            }
        }
    }

    public UndoRedo getUndoRedo() {
        if (this.currentJrxmlVisualView != null) {
            return this.currentJrxmlVisualView.getUndoRedo();
        }
        return super.getUndoRedo();
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return OutlineTopComponent.getDefault();
        }
    }
}

