/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.InstalledModuleProvider;
import org.netbeans.updater.UpdateTracking;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleDeleterImpl {
    private static final ModuleDeleterImpl INSTANCE = new ModuleDeleterImpl();
    private static final String ELEMENT_MODULE = "module";
    private static final String ELEMENT_VERSION = "module_version";
    private static final String ATTR_LAST = "last";
    private static final String ATTR_FILE_NAME = "name";
    private Logger err = Logger.getLogger(ModuleDeleterImpl.class.getName());
    private Set<File> storageFilesForDelete = null;

    public static ModuleDeleterImpl getInstance() {
        return INSTANCE;
    }

    public boolean canDelete(ModuleInfo moduleInfo) {
        if (moduleInfo == null) {
            return false;
        }
        if (Utilities.isEssentialModule(moduleInfo)) {
            this.err.log(Level.FINE, "Cannot delete module because module " + moduleInfo.getCodeName() + " isEssentialModule.");
            return false;
        }
        return this.foundUpdateTracking(moduleInfo);
    }

    public Collection<File> markForDisable(Collection<ModuleInfo> collection, ProgressHandle progressHandle) {
        if (collection == null) {
            throw new IllegalArgumentException("ModuleInfo argument cannot be null.");
        }
        if (progressHandle != null) {
            progressHandle.switchToDeterminate(collection.size() + 1);
        }
        HashSet<File> hashSet = new HashSet<File>();
        int n = 0;
        for (ModuleInfo moduleInfo : collection) {
            File file = this.locateConfigFile(moduleInfo);
            assert (file != null) : "Located config file for " + moduleInfo.getCodeName();
            assert (file.exists()) : file + " config file must exists for " + moduleInfo.getCodeName();
            this.err.log(Level.FINE, "Locate config file of " + moduleInfo.getCodeNameBase() + ": " + file);
            hashSet.add(file);
            if (progressHandle == null) continue;
            progressHandle.progress(++n);
        }
        return hashSet;
    }

    public Collection<File> markForDelete(Collection<ModuleInfo> collection, ProgressHandle progressHandle) throws IOException {
        this.storageFilesForDelete = null;
        if (collection == null) {
            throw new IllegalArgumentException("ModuleInfo argument cannot be null.");
        }
        if (progressHandle != null) {
            progressHandle.switchToDeterminate(collection.size() * 2 + 1);
        }
        HashSet<File> hashSet = new HashSet<File>();
        int n = 0;
        for (ModuleInfo moduleInfo : collection) {
            Collection<File> collection2 = this.locateAllConfigFiles(moduleInfo);
            assert (collection2 != null) : "Located config files for " + moduleInfo.getCodeName();
            assert (!collection2.isEmpty()) : collection2 + " config files must exists for " + moduleInfo.getCodeName();
            hashSet.addAll(collection2);
            this.err.log(Level.FINE, "Locate config files of " + moduleInfo.getCodeNameBase() + ": " + collection2);
            if (progressHandle == null) continue;
            progressHandle.progress(++n);
        }
        this.getStorageFilesForDelete().addAll(hashSet);
        for (ModuleInfo moduleInfo : collection) {
            this.removeModuleFiles(moduleInfo, true);
            if (progressHandle == null) continue;
            progressHandle.progress(++n);
        }
        return this.getStorageFilesForDelete();
    }

    public void delete(ModuleInfo[] moduleInfoArray, ProgressHandle progressHandle) throws IOException {
        this.storageFilesForDelete = null;
        if (moduleInfoArray == null) {
            throw new IllegalArgumentException("ModuleInfo argument cannot be null.");
        }
        if (progressHandle != null) {
            progressHandle.switchToDeterminate(moduleInfoArray.length + 1);
        }
        int n = 0;
        for (ModuleInfo moduleInfo : moduleInfoArray) {
            this.err.log(Level.FINE, "Locate and remove config file of " + moduleInfo.getCodeNameBase());
            this.removeControlModuleFile(moduleInfo, false);
        }
        if (progressHandle != null) {
            progressHandle.progress(++n);
        }
        this.refreshModuleList();
        int n2 = 0;
        for (ModuleInfo moduleInfo : moduleInfoArray) {
            this.err.log(Level.FINE, "Locate and remove config file of " + moduleInfo.getCodeNameBase());
            if (progressHandle != null) {
                progressHandle.progress(moduleInfo.getDisplayName(), ++n);
            }
            while (n2 < 100 && !this.isModuleUninstalled(moduleInfo)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    this.err.log(Level.INFO, "Overflow checks of uninstalled module " + moduleInfo.getCodeName());
                    Thread.currentThread().interrupt();
                }
                ++n2;
            }
            this.removeModuleFiles(moduleInfo, false);
        }
    }

    private boolean isModuleUninstalled(ModuleInfo moduleInfo) {
        return InstalledModuleProvider.getInstalledModules().get(moduleInfo.getCodeNameBase()) == null;
    }

    private File locateConfigFile(ModuleInfo moduleInfo) {
        String string = "config/Modules/" + moduleInfo.getCodeNameBase().replace('.', '-') + ".xml";
        return InstalledFileLocator.getDefault().locate(string, moduleInfo.getCodeNameBase(), false);
    }

    private Collection<File> locateAllConfigFiles(ModuleInfo moduleInfo) {
        HashSet<File> hashSet = new HashSet<File>();
        String string = moduleInfo.getCodeNameBase().replace('.', '-') + ".xml";
        for (File file : UpdateTracking.clusters(true)) {
            File file2 = new File(new File(new File(file, "config"), "Modules"), string);
            if (!file2.exists()) continue;
            hashSet.add(file2);
        }
        return hashSet;
    }

    private void removeControlModuleFile(ModuleInfo moduleInfo, boolean bl) throws IOException {
        File file = null;
        while ((file = this.locateConfigFile(moduleInfo)) != null && !this.getStorageFilesForDelete().contains(file)) {
            if (file != null && file.exists()) {
                if (bl) {
                    this.err.log(Level.FINE, "Control file " + file + " is marked for delete.");
                    this.getStorageFilesForDelete().add(file);
                    continue;
                }
                this.err.log(Level.FINE, "Try delete the config File " + file);
                file.delete();
                this.err.log(Level.FINE, "Control file " + file + " is deleted.");
                continue;
            }
            this.err.log(Level.FINE, "Warning: Config File " + file + " doesn't exist!");
        }
    }

    private boolean foundUpdateTracking(ModuleInfo moduleInfo) {
        File file = Utilities.locateUpdateTracking(moduleInfo);
        if (file != null && file.exists()) {
            if (!file.getParentFile().canWrite()) {
                this.err.log(Level.FINE, "Cannot delete module " + moduleInfo.getCodeName() + " because no write permission to directory " + file.getParent());
                return false;
            }
            return true;
        }
        this.err.log(Level.FINE, "Cannot delete module " + moduleInfo.getCodeName() + " because no update_tracking file found.");
        return false;
    }

    private void removeModuleFiles(ModuleInfo moduleInfo, boolean bl) throws IOException {
        this.err.log(Level.FINE, "Entry removing files of module " + moduleInfo);
        File file = null;
        while ((file = Utilities.locateUpdateTracking(moduleInfo)) != null && !this.getStorageFilesForDelete().contains(file)) {
            this.removeModuleFilesInCluster(moduleInfo, file, bl);
        }
        this.err.log(Level.FINE, "Exit removing files of module " + moduleInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeModuleFilesInCluster(ModuleInfo moduleInfo, File file, boolean bl) throws IOException {
        String string3;
        Object object;
        this.err.log(Level.FINE, "Read update_tracking " + file + " file.");
        Set<String> set = this.readModuleFiles(this.getModuleConfiguration(file));
        String string2 = "config/Modules/" + moduleInfo.getCodeNameBase().replace('.', '-') + ".xml";
        if (set.contains(string2)) {
            object = InstalledFileLocator.getDefault().locate(string2, moduleInfo.getCodeNameBase(), false);
            assert (object == null || !((File)object).exists() || this.getStorageFilesForDelete().contains(object)) : "Config file " + string2 + " must be already removed or marked for remove.";
        }
        for (String string3 : set) {
            if (string3.equals(string2)) continue;
            File file2 = InstalledFileLocator.getDefault().locate(string3, moduleInfo.getCodeNameBase(), false);
            if (file2 == null) {
                this.err.log(Level.WARNING, "InstalledFileLocator doesn't locate file " + string3 + " for module " + moduleInfo.getCodeNameBase());
                continue;
            }
            if (file2.equals(file)) continue;
            assert (file2.exists()) : "File " + file2 + " exists.";
            if (!file2.exists()) continue;
            if (bl) {
                this.err.log(Level.FINE, "File " + file2 + " is marked for delete.");
                this.getStorageFilesForDelete().add(file2);
                continue;
            }
            try {
                FileObject fileObject = FileUtil.toFileObject((File)file2);
                if (fileObject != null) {
                    fileObject.lock().releaseLock();
                }
                File file3 = file2;
                while (file3.delete()) {
                    file3 = file3.getParentFile();
                }
            }
            catch (IOException iOException) {
                assert (false) : "Waring: IOException " + iOException.getMessage() + " was caught. Propably file lock on the file.";
                this.err.log(Level.FINE, "Waring: IOException " + iOException.getMessage() + " was caught. Propably file lock on the file.");
                this.err.log(Level.FINE, "Try call File.deleteOnExit() on " + file2);
                file2.deleteOnExit();
            }
            this.err.log(Level.FINE, "File " + file2 + " is deleted.");
        }
        object = FileUtil.toFileObject((File)file);
        string3 = null;
        try {
            Object object2 = string3 = object != null ? object.lock() : null;
            if (bl) {
                this.err.log(Level.FINE, "Tracking file " + file + " is marked for delete.");
                this.getStorageFilesForDelete().add(file);
            } else {
                file.delete();
                this.err.log(Level.FINE, "Tracking file " + file + " is deleted.");
            }
        }
        finally {
            if (string3 != null) {
                string3.releaseLock();
            }
        }
        this.err.log(Level.FINE, "File " + file + " is deleted.");
    }

    private Node getModuleConfiguration(File file) {
        Document document = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputSource inputSource = new InputSource(fileInputStream);
            document = XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)false, null, (EntityResolver)EntityCatalog.getDefault());
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (SAXException sAXException) {
            this.err.log(Level.WARNING, null, sAXException);
            return null;
        }
        catch (IOException iOException) {
            this.err.log(Level.WARNING, null, iOException);
        }
        assert (document.getDocumentElement() != null) : "File " + file + " must contain <module> element.";
        return this.getModuleElement(document.getDocumentElement());
    }

    private Node getModuleElement(Element element) {
        Node node = null;
        assert (ELEMENT_MODULE.equals(element.getTagName())) : "The root element is: module but was: " + element.getTagName();
        NodeList nodeList = element.getElementsByTagName(ELEMENT_VERSION);
        for (int i = 0; i < nodeList.getLength() && (node = this.getModuleLastVersion(nodeList.item(i))) == null; ++i) {
        }
        return node;
    }

    private Node getModuleLastVersion(Node node) {
        Node node2 = node.getAttributes().getNamedItem(ATTR_LAST);
        assert (node2 != null) : "ELEMENT_VERSION must contain ATTR_LAST attribute.";
        if (Boolean.valueOf(node2.getNodeValue()).booleanValue()) {
            return node;
        }
        return null;
    }

    private Set<String> readModuleFiles(Node node) {
        HashSet<String> hashSet = new HashSet<String>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).hasAttributes()) continue;
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            hashSet.add(namedNodeMap.getNamedItem(ATTR_FILE_NAME).getNodeValue());
            this.err.log(Level.FINE, "Mark to delete: " + namedNodeMap.getNamedItem(ATTR_FILE_NAME).getNodeValue());
        }
        return hashSet;
    }

    private void refreshModuleList() {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Modules");
        this.err.log(Level.FINE, "Call refresh on " + fileObject + " file object.");
        if (fileObject != null) {
            fileObject.refresh();
        }
    }

    private Set<File> getStorageFilesForDelete() {
        if (this.storageFilesForDelete == null) {
            this.storageFilesForDelete = new HashSet<File>();
        }
        return this.storageFilesForDelete;
    }
}

