/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.palette.actions.CreateTextFieldAction;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRCrosstabOrigin;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtils {
    public static JRDesignCrosstabParameter cloneCrosstabParameter(JRDesignCrosstabParameter param) {
        JRDesignCrosstabParameter newParam = new JRDesignCrosstabParameter();
        newParam.setName(param.getName());
        newParam.setForPrompting(param.isForPrompting());
        newParam.setSystemDefined(param.isSystemDefined());
        newParam.setValueClassName(param.getValueClassName());
        newParam.setDescription(param.getDescription());
        if (param.getDefaultValueExpression() != null) {
            newParam.setDefaultValueExpression((JRExpression)ModelUtils.cloneExpression((JRExpression)((JRDesignExpression)param.getDefaultValueExpression())));
        }
        ModelUtils.replacePropertiesMap(param.getPropertiesMap(), newParam.getPropertiesMap());
        return newParam;
    }

    public static JRDesignStyle cloneStyle(JRDesignStyle style) {
        JRDesignStyle newStyle = new JRDesignStyle();
        newStyle.setName(style.getName());
        return newStyle;
    }

    public static List<JRBand> getBands(JasperDesign jd) {
        int i;
        ArrayList<JRBand> list = new ArrayList<JRBand>();
        if (jd == null) {
            return list;
        }
        JRGroup[] groups = jd.getGroups();
        if (null != jd.getBackground()) {
            list.add(jd.getBackground());
        }
        if (null != jd.getTitle()) {
            list.add(jd.getTitle());
        }
        if (null != jd.getPageHeader()) {
            list.add(jd.getPageHeader());
        }
        if (null != jd.getColumnHeader()) {
            list.add(jd.getColumnHeader());
        }
        for (i = 0; i < groups.length; ++i) {
            if (null == groups[i].getGroupHeader()) continue;
            list.add(groups[i].getGroupHeader());
        }
        if (null != jd.getDetail()) {
            list.add(jd.getDetail());
        }
        for (i = groups.length - 1; i >= 0; --i) {
            if (null == groups[i].getGroupFooter()) continue;
            list.add(groups[i].getGroupFooter());
        }
        if (null != jd.getColumnFooter()) {
            list.add(jd.getColumnFooter());
        }
        if (null != jd.getPageFooter()) {
            list.add(jd.getPageFooter());
        }
        if (null != jd.getLastPageFooter()) {
            list.add(jd.getLastPageFooter());
        }
        if (null != jd.getSummary()) {
            list.add(jd.getSummary());
        }
        if (null != jd.getNoData()) {
            list.add(jd.getNoData());
        }
        return list;
    }

    public static int getHeaderCellWidth(JRDesignCrosstab crosstab) {
        if (crosstab == null) {
            return 0;
        }
        JRCrosstabRowGroup[] row_groups = crosstab.getRowGroups();
        int tot = 0;
        for (int i = 0; i < row_groups.length; ++i) {
            tot += row_groups[i].getWidth();
        }
        return tot;
    }

    public static int getHeaderCellHeight(JRDesignCrosstab crosstab) {
        if (crosstab == null) {
            return 0;
        }
        JRCrosstabColumnGroup[] col_groups = crosstab.getColumnGroups();
        int tot = 0;
        for (int i = 0; i < col_groups.length; ++i) {
            tot += col_groups[i].getHeight();
        }
        return tot;
    }

    public static int findRowHeight(JRCrosstabCell[][] cells, int rowIndex) {
        for (int i = 0; i < cells[rowIndex].length; ++i) {
            if (cells[rowIndex][i] == null || cells[rowIndex][i].getContents() == null) continue;
            return cells[rowIndex][i].getContents().getHeight();
        }
        return 0;
    }

    public static int findColumnWidth(JRCrosstabCell[][] cells, int colIndex) {
        for (int i = 0; i < cells.length; ++i) {
            if (cells[i][colIndex] == null || cells[i][colIndex].getContents() == null) continue;
            return cells[i][colIndex].getContents().getWidth();
        }
        return 0;
    }

    public static JRDesignCellContents getCellAt(JRDesignCrosstab crosstab, Point point) {
        return ModelUtils.getCellAt(crosstab, point, false);
    }

    public static JRDesignCellContents getCellAt(JRDesignCrosstab crosstab, Point point, boolean createIt) {
        Rectangle rect3;
        Rectangle rect2;
        Rectangle rect1;
        int i;
        int header_width = ModelUtils.getHeaderCellWidth(crosstab);
        int header_height = ModelUtils.getHeaderCellHeight(crosstab);
        JRCrosstabRowGroup[] row_groups = crosstab.getRowGroups();
        JRCrosstabColumnGroup[] col_groups = crosstab.getColumnGroups();
        JRCrosstabCell[][] cells = ModelUtils.normalizeCell(crosstab.getCells(), row_groups, col_groups);
        int x = header_width;
        int y = header_height;
        Rectangle r1 = new Rectangle(0, 0, header_width, header_height);
        if (r1.contains(point)) {
            return (JRDesignCellContents)crosstab.getHeaderCell();
        }
        for (int i2 = cells.length - 1; i2 >= 0; --i2) {
            x = header_width;
            for (int k = cells[i2].length - 1; k >= 0; --k) {
                JRCrosstabCell cell = cells[i2][k];
                if (cell == null) continue;
                Rectangle rect = new Rectangle(x, y, cell.getContents().getWidth(), cell.getContents().getHeight());
                if (rect.contains(point)) {
                    if (cell.getContents() == null && createIt) {
                        ((JRDesignCrosstabCell)cell).setContents(new JRDesignCellContents());
                    }
                    return (JRDesignCellContents)cell.getContents();
                }
                x += ModelUtils.findColumnWidth(cells, k);
            }
            y += ModelUtils.findRowHeight(cells, i2);
        }
        int data_width = x - header_width;
        int data_height = y - header_height;
        x = 0;
        y = header_height;
        for (i = 0; i < row_groups.length; ++i) {
            switch (row_groups[i].getTotalPosition()) {
                case 1: {
                    rect1 = new Rectangle(x, y, row_groups[i].getTotalHeader().getWidth(), row_groups[i].getTotalHeader().getHeight());
                    if (rect1.contains(point)) {
                        if ((JRDesignCellContents)row_groups[i].getTotalHeader() == null && createIt) {
                            ((JRDesignCrosstabGroup)row_groups[i]).setTotalHeader(new JRDesignCellContents());
                        }
                        return (JRDesignCellContents)row_groups[i].getTotalHeader();
                    }
                    data_height -= row_groups[i].getTotalHeader().getHeight();
                    y += row_groups[i].getTotalHeader().getHeight();
                    break;
                }
                case 2: {
                    int y_loc = y + data_height - row_groups[i].getTotalHeader().getHeight();
                    rect2 = new Rectangle(x, y_loc, row_groups[i].getTotalHeader().getWidth(), row_groups[i].getTotalHeader().getHeight());
                    if (rect2.contains(point)) {
                        if ((JRDesignCellContents)row_groups[i].getTotalHeader() == null && createIt) {
                            ((JRDesignCrosstabGroup)row_groups[i]).setTotalHeader(new JRDesignCellContents());
                        }
                        return (JRDesignCellContents)row_groups[i].getTotalHeader();
                    }
                    data_height -= row_groups[i].getTotalHeader().getHeight();
                }
            }
            rect3 = new Rectangle(x, y, row_groups[i].getHeader().getWidth(), row_groups[i].getHeader().getHeight());
            if (rect3.contains(point)) {
                if ((JRDesignCellContents)row_groups[i].getHeader() == null && createIt) {
                    ((JRDesignCrosstabGroup)row_groups[i]).setHeader(new JRDesignCellContents());
                }
                return (JRDesignCellContents)row_groups[i].getHeader();
            }
            x += row_groups[i].getHeader().getWidth();
        }
        x = header_width;
        y = 0;
        for (i = 0; i < col_groups.length; ++i) {
            switch (col_groups[i].getTotalPosition()) {
                case 1: {
                    rect1 = new Rectangle(x, y, col_groups[i].getTotalHeader().getWidth(), col_groups[i].getTotalHeader().getHeight());
                    if (rect1.contains(point)) {
                        if ((JRDesignCellContents)col_groups[i].getTotalHeader() == null && createIt) {
                            ((JRDesignCrosstabGroup)col_groups[i]).setTotalHeader(new JRDesignCellContents());
                        }
                        return (JRDesignCellContents)col_groups[i].getTotalHeader();
                    }
                    data_width -= col_groups[i].getTotalHeader().getWidth();
                    x += col_groups[i].getTotalHeader().getWidth();
                    break;
                }
                case 2: {
                    int x_loc = x + data_width - col_groups[i].getTotalHeader().getWidth();
                    rect2 = new Rectangle(x_loc, y, col_groups[i].getTotalHeader().getWidth(), col_groups[i].getTotalHeader().getHeight());
                    if (rect2.contains(point)) {
                        if ((JRDesignCellContents)col_groups[i].getTotalHeader() == null && createIt) {
                            ((JRDesignCrosstabGroup)col_groups[i]).setTotalHeader(new JRDesignCellContents());
                        }
                        return (JRDesignCellContents)col_groups[i].getTotalHeader();
                    }
                    data_width -= col_groups[i].getTotalHeader().getWidth();
                    break;
                }
            }
            rect3 = new Rectangle(x, y, col_groups[i].getHeader().getWidth(), col_groups[i].getHeader().getHeight());
            if (rect3.contains(point)) {
                if ((JRDesignCellContents)col_groups[i].getHeader() == null && createIt) {
                    ((JRDesignCrosstabGroup)col_groups[i]).setHeader(new JRDesignCellContents());
                }
                return (JRDesignCellContents)col_groups[i].getHeader();
            }
            y += col_groups[i].getHeader().getHeight();
        }
        return null;
    }

    public static Point getCellLocation(JRDesignCrosstab crosstab, JRDesignCellContents content) {
        int i;
        if (content == null || content == crosstab.getHeaderCell()) {
            return new Point(0, 0);
        }
        int header_width = ModelUtils.getHeaderCellWidth(crosstab);
        int header_height = ModelUtils.getHeaderCellHeight(crosstab);
        JRCrosstabRowGroup[] row_groups = crosstab.getRowGroups();
        JRCrosstabColumnGroup[] col_groups = crosstab.getColumnGroups();
        JRCrosstabCell[][] jr_cells = crosstab.getCells();
        JRCrosstabCell baseCell = jr_cells[jr_cells.length - 1][jr_cells[0].length - 1];
        JRCrosstabCell[][] cells = ModelUtils.normalizeCell(jr_cells, row_groups, col_groups);
        int x = header_width;
        int y = header_height;
        for (int i2 = cells.length - 1; i2 >= 0; --i2) {
            x = header_width;
            int height = 0;
            for (int k = cells[i2].length - 1; k >= 0; --k) {
                JRCrosstabCell cell = cells[i2][k];
                if (cell == null) continue;
                if (cell.getContents() == content) {
                    return new Point(x, y);
                }
                x += cell.getContents().getWidth();
                height = cell.getContents().getHeight();
            }
            y += height;
        }
        int data_width = x - header_width;
        int data_height = y - header_height;
        if (content.getOrigin().getType() == 3 || content.getOrigin().getType() == 4) {
            x = 0;
            y = header_height;
            for (i = 0; i < row_groups.length; ++i) {
                switch (row_groups[i].getTotalPosition()) {
                    case 1: {
                        if (row_groups[i].getTotalHeader() == content) {
                            return new Point(x, y);
                        }
                        data_height -= row_groups[i].getTotalHeader().getHeight();
                        y += row_groups[i].getTotalHeader().getHeight();
                        break;
                    }
                    case 2: {
                        int y_loc = y + data_height - row_groups[i].getTotalHeader().getHeight();
                        if (row_groups[i].getTotalHeader() == content) {
                            return new Point(x, y_loc);
                        }
                        data_height -= row_groups[i].getTotalHeader().getHeight();
                    }
                }
                if (row_groups[i].getHeader() == content) {
                    return new Point(x, y);
                }
                x += row_groups[i].getHeader().getWidth();
            }
        }
        x = header_width;
        y = 0;
        if (content.getOrigin().getType() == 5 || content.getOrigin().getType() == 6) {
            for (i = 0; i < col_groups.length; ++i) {
                switch (col_groups[i].getTotalPosition()) {
                    case 1: {
                        if (col_groups[i].getTotalHeader() == content) {
                            return new Point(x, y);
                        }
                        data_width -= col_groups[i].getTotalHeader().getWidth();
                        x += col_groups[i].getTotalHeader().getWidth();
                        break;
                    }
                    case 2: {
                        int x_loc = x + data_width - col_groups[i].getTotalHeader().getWidth();
                        if (col_groups[i].getTotalHeader() == content) {
                            return new Point(x_loc, y);
                        }
                        data_width -= col_groups[i].getTotalHeader().getWidth();
                        break;
                    }
                }
                if (col_groups[i].getHeader() == content) {
                    return new Point(x, y);
                }
                y += col_groups[i].getHeader().getHeight();
            }
        }
        return new Point(0, 0);
    }

    public static boolean isValidNewCrosstabObjectName(JRDesignCrosstab crosstab, String new_name) {
        if (crosstab.getRowGroupIndicesMap().containsKey(new_name)) {
            return false;
        }
        if (crosstab.getColumnGroupIndicesMap().containsKey(new_name)) {
            return false;
        }
        return !crosstab.getMeasureIndicesMap().containsKey(new_name);
    }

    public static String nameOf(JRCrosstabOrigin origin) {
        String title = "unknow";
        if (origin != null) {
            switch (origin.getType()) {
                case 1: {
                    title = "Crosstab header";
                    break;
                }
                case 7: {
                    title = (origin.getRowGroupName() == null ? "Detail" : origin.getRowGroupName()) + " / " + (origin.getColumnGroupName() == null ? "Detail" : origin.getColumnGroupName());
                    break;
                }
                case 5: {
                    title = origin.getColumnGroupName() + " header";
                    break;
                }
                case 6: {
                    title = origin.getColumnGroupName() + " total header";
                    break;
                }
                case 3: {
                    title = origin.getRowGroupName() + " header";
                    break;
                }
                case 4: {
                    title = origin.getRowGroupName() + " total header";
                    break;
                }
                case 2: {
                    title = "When no data";
                }
            }
        }
        return title;
    }

    public static String nameOf(JRDesignCellContents contents) {
        JRCrosstabOrigin origin = contents.getOrigin();
        return ModelUtils.nameOf(origin);
    }

    public static List<JRDesignCellContents> getAllCells(JRDesignCrosstab designCrosstab) {
        ArrayList<JRDesignCellContents> list = new ArrayList<JRDesignCellContents>();
        list.add((JRDesignCellContents)designCrosstab.getHeaderCell());
        List cells = designCrosstab.getCellsList();
        for (int i = 0; i < cells.size(); ++i) {
            JRCrosstabCell cell = (JRCrosstabCell)cells.get(i);
            if (cell == null || (JRDesignCellContents)cell.getContents() == null) continue;
            list.add((JRDesignCellContents)cell.getContents());
        }
        JRCrosstabRowGroup[] row_groups = designCrosstab.getRowGroups();
        for (int i = 0; i < row_groups.length; ++i) {
            switch (row_groups[i].getTotalPosition()) {
                case 1: 
                case 2: {
                    list.add((JRDesignCellContents)row_groups[i].getTotalHeader());
                    break;
                }
            }
            list.add((JRDesignCellContents)row_groups[i].getHeader());
        }
        JRCrosstabColumnGroup[] col_groups = designCrosstab.getColumnGroups();
        for (int i = 0; i < col_groups.length; ++i) {
            switch (col_groups[i].getTotalPosition()) {
                case 1: 
                case 2: {
                    list.add((JRDesignCellContents)col_groups[i].getTotalHeader());
                    break;
                }
            }
            list.add((JRDesignCellContents)col_groups[i].getHeader());
        }
        return list;
    }

    public static JRDesignDataset getElementDataset(JRDesignElement element, JasperDesign jd) {
        JRCrosstabDataset elementDataset;
        JRDesignCellContents cellContent;
        JRDesignDataset dataset = jd.getMainDesignDataset();
        JRElementGroup group = ModelUtils.getTopElementGroup(element);
        if (group instanceof JRDesignCellContents && (cellContent = (JRDesignCellContents)group).getOrigin().getCrosstab().getDataset() != null && (elementDataset = cellContent.getOrigin().getCrosstab().getDataset()).getDatasetRun() != null) {
            String datasetName = elementDataset.getDatasetRun().getDatasetName();
            dataset = (JRDesignDataset)jd.getDatasetMap().get(datasetName);
        }
        return dataset;
    }

    public static JRDesignDataset getCrosstabDataset(JRDesignCrosstab element, JasperDesign jd) {
        JRCrosstabDataset elementDataset = element.getDataset();
        if (elementDataset != null && elementDataset.getDatasetRun() != null) {
            String datasetName = elementDataset.getDatasetRun().getDatasetName();
            return (JRDesignDataset)jd.getDatasetMap().get(datasetName);
        }
        return (JRDesignDataset)jd.getMainDataset();
    }

    public static JRDesignGroup getGroupFromBand(JasperDesign jd, JRDesignBand band) {
        if (band == null || jd == null || band.getOrigin().getGroupName() == null) {
            return null;
        }
        String s = band.getOrigin().getGroupName();
        JRGroup[] groups = jd.getGroups();
        for (int i = 0; i < groups.length; ++i) {
            if (!groups[i].getName().equals(s)) continue;
            return (JRDesignGroup)groups[i];
        }
        return null;
    }

    public static boolean isAncestorElemenetGroup(JRElementGroup parent, JRElementGroup g) {
        while (g != null) {
            if (g instanceof JRDesignBand || g instanceof JRDesignCellContents) {
                return false;
            }
            if (g == parent) {
                return true;
            }
            g = g.getElementGroup();
        }
        return false;
    }

    public static boolean isChildOf(JRDesignElement element, JRElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            if (element == elements[i]) {
                return true;
            }
            if (!(elements[i] instanceof JRDesignFrame) || !ModelUtils.isChildOf(element, ((JRDesignFrame)elements[i]).getElements())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGroupHeader(JRBand b, JasperDesign jd) {
        if (b == null) {
            return false;
        }
        JRGroup[] groups = jd.getGroups();
        for (int i = 0; i < groups.length; ++i) {
            if (b != groups[i].getGroupHeader()) continue;
            return true;
        }
        return false;
    }

    public static boolean isGroupFooter(JRBand b, JasperDesign jd) {
        if (b == null) {
            return false;
        }
        JRGroup[] groups = jd.getGroups();
        for (int i = 0; i < groups.length; ++i) {
            if (b != groups[i].getGroupFooter()) continue;
            return true;
        }
        return false;
    }

    public static String nameOf(JROrigin origin) {
        if (origin != null) {
            switch (origin.getBandType()) {
                case 1: {
                    return "background";
                }
                case 2: {
                    return "title";
                }
                case 3: {
                    return "pageHeader";
                }
                case 4: {
                    return "columnHeader";
                }
                case 6: {
                    return "detail";
                }
                case 8: {
                    return "columnFooter";
                }
                case 9: {
                    return "pageFooter";
                }
                case 10: {
                    return "lastPageFooter";
                }
                case 11: {
                    return "summary";
                }
                case 12: {
                    return "noData";
                }
                case 5: {
                    return origin.getGroupName() + "GroupHeader";
                }
                case 7: {
                    return origin.getGroupName() + "GroupFooter";
                }
            }
        }
        return "unknow";
    }

    public static String nameOf(JRBand b, JasperDesign jd) {
        return ModelUtils.nameOf(((JRDesignBand)b).getOrigin());
    }

    public static JRBand getPreviousBand(JRBand b, JasperDesign jd) {
        if (b == null || jd == null) {
            return null;
        }
        List<JRBand> bands = ModelUtils.getBands(jd);
        JRBand previous = null;
        for (JRBand tmpBand : bands) {
            if (tmpBand == b) {
                return previous;
            }
            previous = tmpBand;
        }
        return previous;
    }

    public static int getBandLocation(JRBand b, JasperDesign jd) {
        int yLocation = jd.getTopMargin();
        List<JRBand> bands = ModelUtils.getBands(jd);
        for (JRBand tmpBand : bands) {
            if (tmpBand == b) {
                return yLocation;
            }
            yLocation += tmpBand.getHeight();
        }
        return yLocation;
    }

    public static int getBandHeight(JRBand b) {
        return b != null ? b.getHeight() : 0;
    }

    public static int getMaxBandHeight(JRDesignBand b, JasperDesign jd) {
        if (b == null || jd == null) {
            return 0;
        }
        JROrigin origin = b.getOrigin();
        int topBottomMargins = jd.getTopMargin() + jd.getBottomMargin();
        if (origin.getBandType() == 2 && jd.isTitleNewPage() || origin.getBandType() == 11 && jd.isSummaryNewPage() || origin.getBandType() == 1 || origin.getBandType() == 12) {
            return jd.getPageHeight() - topBottomMargins;
        }
        int basicBandsHeight = 0;
        int titleHeight = jd.getTitle() != null ? jd.getTitle().getHeight() : 0;
        basicBandsHeight += topBottomMargins;
        basicBandsHeight += jd.getPageHeader() != null ? jd.getPageHeader().getHeight() : 0;
        basicBandsHeight += jd.getColumnHeader() != null ? jd.getColumnHeader().getHeight() : 0;
        basicBandsHeight += jd.getColumnFooter() != null ? jd.getColumnFooter().getHeight() : 0;
        basicBandsHeight += jd.getPageFooter() != null ? jd.getPageFooter().getHeight() : 0;
        if (origin.getBandType() == 7 || origin.getBandType() == 5) {
            return jd.getPageHeight() - basicBandsHeight - (jd.isTitleNewPage() ? 0 : titleHeight);
        }
        int detailHeight = jd.getDetail() != null ? jd.getDetail().getHeight() : 0;
        return jd.getPageHeight() - basicBandsHeight + b.getHeight() - detailHeight;
    }

    public static JRBand bandOfElement(JRElement element, JasperDesign jd) {
        if (element == null || jd == null) {
            return null;
        }
        List<JRBand> bands = ModelUtils.getBands(jd);
        for (JRBand tmpBand : bands) {
            JRElement[] elements = tmpBand.getElements();
            for (int i = 0; i < elements.length; ++i) {
                if (element != elements[i]) continue;
                return tmpBand;
            }
        }
        return null;
    }

    public static int getDesignHeight(JasperDesign jd) {
        int designHeight = 0;
        if (jd != null) {
            designHeight += jd.getTopMargin();
            List<JRBand> bands = ModelUtils.getBands(jd);
            for (JRBand b : bands) {
                designHeight += b.getHeight();
            }
            designHeight += jd.getBottomMargin();
        }
        return designHeight;
    }

    public static int getMaximumDesignHeight(JasperDesign jd) {
        int maxDesignHeight = 3 * jd.getPageHeight();
        if (jd.isTitleNewPage()) {
            maxDesignHeight += jd.getPageHeight();
        }
        if (jd.isSummaryNewPage()) {
            maxDesignHeight += jd.getPageHeight();
        }
        return maxDesignHeight;
    }

    public static Node findElementNode(Node rootNode, JRElement element) {
        if (rootNode instanceof ElementNode && ((ElementNode)rootNode).getElement().equals(element)) {
            return rootNode;
        }
        if (rootNode == null) {
            return null;
        }
        Children children = rootNode.getChildren();
        Node[] nodes = children.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            Node node = ModelUtils.findElementNode(nodes[i], element);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public static JRDesignParameter cloneParameter(JRDesignParameter param) {
        JRDesignParameter newParam = new JRDesignParameter();
        newParam.setName(param.getName());
        newParam.setForPrompting(param.isForPrompting());
        newParam.setSystemDefined(param.isSystemDefined());
        newParam.setValueClassName(param.getValueClassName());
        newParam.setDescription(param.getDescription());
        if (param.getDefaultValueExpression() != null) {
            newParam.setDefaultValueExpression((JRExpression)ModelUtils.cloneExpression((JRExpression)((JRDesignExpression)param.getDefaultValueExpression())));
        }
        ModelUtils.replacePropertiesMap(param.getPropertiesMap(), newParam.getPropertiesMap());
        return newParam;
    }

    public static JRCrosstabCell[][] normalizeCell(JRCrosstabCell[][] cells, JRCrosstabRowGroup[] row_groups, JRCrosstabColumnGroup[] col_groups) {
        int i;
        JRCrosstabCell[][] newCells = new JRCrosstabCell[row_groups.length + 1][col_groups.length + 1];
        int minRow = 0;
        int maxRow = row_groups.length;
        int minCol = 0;
        int maxCol = col_groups.length;
        int[] rowsConversion = new int[row_groups.length + 1];
        int[] colsConversion = new int[col_groups.length + 1];
        for (i = 0; i < row_groups.length; ++i) {
            rowsConversion[i] = row_groups[i].getTotalPosition() == 1 ? maxRow-- : minRow++;
        }
        rowsConversion[row_groups.length] = minRow;
        for (i = 0; i < col_groups.length; ++i) {
            colsConversion[i] = col_groups[i].getTotalPosition() == 1 ? maxCol-- : minCol++;
        }
        colsConversion[col_groups.length] = minCol;
        for (i = 0; i < rowsConversion.length; ++i) {
            for (int j = 0; j < colsConversion.length; ++j) {
                int x = rowsConversion[i];
                int y = colsConversion[j];
                try {
                    JRCrosstabCell cell;
                    newCells[x][y] = cell = cells[i][j];
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return newCells;
    }

    public static void fixElementsExpressions(JasperDesign jd, String oldName, String newName, byte chunckType, String newClassName) {
        List<JRBand> bands = ModelUtils.getBands(jd);
        for (JRBand b : bands) {
            if (b == null || !(b instanceof JRDesignBand)) continue;
            ModelUtils.fixElementsExpressions((JRDesignElementGroup)((JRDesignBand)b), oldName, newName, chunckType, newClassName);
        }
    }

    public static void fixElementsExpressions(JRDesignCrosstab crosstab, String oldName, String newName, byte chunckType, String newClassName) {
        List<JRDesignCellContents> cells = ModelUtils.getAllCells(crosstab);
        for (JRDesignCellContents cell : cells) {
            if (cell == null || !(cell instanceof JRDesignCellContents)) continue;
            ModelUtils.fixElementsExpressions((JRDesignElementGroup)cell, oldName, newName, chunckType, newClassName);
        }
    }

    public static void fixElementsExpressions(JRDesignElementGroup group, String oldName, String newName, byte chunckType, String newClassName) {
        List list = group.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (obj == null) continue;
            if (obj instanceof JRDesignElementGroup) {
                ModelUtils.fixElementsExpressions((JRDesignElementGroup)obj, oldName, newName, chunckType, newClassName);
                continue;
            }
            if (obj instanceof JRDesignTextField) {
                ModelUtils.fixElementExpressionText((JRDesignTextField)obj, oldName, newName, chunckType, newClassName);
                continue;
            }
            if (!(obj instanceof JRDesignImage)) continue;
            ModelUtils.fixElementExpressionImage((JRDesignImage)obj, oldName, newName, chunckType, newClassName);
        }
    }

    public static void fixElementExpressionText(JRDesignTextField textfield, String oldName, String newName, byte chunckType, String newClassName) {
        JRDesignExpression exp = (JRDesignExpression)textfield.getExpression();
        ModelUtils.replaceChunkText(exp, oldName, newName, chunckType, newClassName);
        if (exp != null && exp.getValueClassName() != null && newClassName != null) {
            CreateTextFieldAction.setMatchingClassExpression(exp, newClassName, true);
            textfield.getEventSupport().firePropertyChange("expression", null, (Object)exp);
        }
    }

    public static void fixElementExpressionImage(JRDesignImage imageelement, String oldName, String newName, byte chunckType, String newClassName) {
        JRDesignExpression exp = (JRDesignExpression)imageelement.getExpression();
        ModelUtils.replaceChunkText(exp, oldName, newName, chunckType, newClassName);
        if (exp != null) {
            imageelement.getEventSupport().firePropertyChange("expression", null, (Object)exp);
        }
    }

    public static void replaceChunkText(JRDesignExpression exp, String oldName, String newName, byte chunckType, String newClassName) {
        if (exp == null) {
            return;
        }
        if (oldName == null || newName == null) {
            return;
        }
        if (oldName.equals(newName)) {
            return;
        }
        String oldString = "";
        String pre = "";
        String post = "";
        switch (chunckType) {
            case 3: {
                pre = "$F{";
                post = "}";
                break;
            }
            case 4: {
                pre = "$V{";
                post = "}";
                break;
            }
            case 2: {
                pre = "$P{";
                post = "}";
                break;
            }
            case 5: {
                pre = "$R{";
                post = "}";
                break;
            }
        }
        oldName = pre + oldName + post;
        newName = pre + newName + post;
        if (!exp.getText().contains(oldName)) {
            return;
        }
        exp.setText(Misc.string_replace(newName, oldName, exp.getText()));
        if (exp.getValueClassName() != null && newClassName != null && !exp.getValueClassName().equals(newClassName)) {
            exp.setValueClassName(newClassName);
        }
    }

    public static void replacePropertiesMap(JRPropertiesMap source, JRPropertiesMap dest) {
        int i;
        String[] propertyNames = source.getPropertyNames();
        if (propertyNames != null && propertyNames.length > 0) {
            for (i = 0; i < propertyNames.length; ++i) {
                dest.setProperty(propertyNames[i], source.getProperty(propertyNames[i]));
            }
        }
        if ((propertyNames = dest.getPropertyNames()) != null && propertyNames.length > 0) {
            for (i = 0; i < propertyNames.length; ++i) {
                if (source.containsProperty(propertyNames[i])) continue;
                dest.removeProperty(propertyNames[i]);
            }
        }
    }

    public static JRDesignExpression cloneExpression(JRExpression exp) {
        if (exp == null) {
            return null;
        }
        JRDesignExpression newExp = new JRDesignExpression();
        newExp.setValueClassName(exp.getValueClassName());
        newExp.setText(exp.getText());
        return newExp;
    }

    public static Point getParentLocation(JasperDesign jd, JRDesignElement element) {
        Point base = new Point(0, 0);
        if (element == null) {
            return base;
        }
        for (JRElementGroup grp = element.getElementGroup(); grp != null; grp = grp.getElementGroup()) {
            if (grp instanceof JRDesignBand) {
                JRDesignBand band = (JRDesignBand)grp;
                base.x = jd.getLeftMargin();
                base.y = ModelUtils.getBandLocation((JRBand)band, jd);
                break;
            }
            if (grp instanceof JRDesignCellContents) {
                JRDesignCellContents cell = (JRDesignCellContents)grp;
                base = ModelUtils.getCellLocation(cell.getOrigin().getCrosstab(), cell);
                break;
            }
            if (!(grp instanceof JRDesignFrame)) continue;
            JRDesignFrame frame = (JRDesignFrame)grp;
            base = ModelUtils.getParentLocation(jd, (JRDesignElement)frame);
            base.x += frame.getX();
            base.y += frame.getY();
            break;
        }
        return base;
    }

    public static JRDesignField cloneField(JRDesignField field) throws CloneNotSupportedException {
        return (JRDesignField)field.clone();
    }

    public static JRDesignVariable cloneVariable(JRDesignVariable variable) {
        JRDesignVariable newVariable = new JRDesignVariable();
        newVariable.setName(variable.getName());
        newVariable.setValueClassName(variable.getValueClassName());
        newVariable.setCalculation(variable.getCalculation());
        newVariable.setExpression((JRExpression)ModelUtils.cloneExpression(variable.getExpression()));
        newVariable.setIncrementGroup(variable.getIncrementGroup());
        newVariable.setIncrementType(variable.getIncrementType());
        newVariable.setIncrementerFactoryClassName(variable.getIncrementerFactoryClassName());
        newVariable.setInitialValueExpression((JRExpression)ModelUtils.cloneExpression(variable.getInitialValueExpression()));
        newVariable.setResetGroup(variable.getResetGroup());
        newVariable.setResetType(variable.getResetType());
        newVariable.setSystemDefined(variable.isSystemDefined());
        return newVariable;
    }

    public static boolean containsProperty(Node.PropertySet[] sets, String propertyName) {
        for (int i = 0; i < sets.length; ++i) {
            Node.Property[] pp = sets[i].getProperties();
            for (int j = 0; j < pp.length; ++j) {
                String name = pp[j].getName();
                if (name == null || !name.equals(propertyName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isElementChildOf(JRDesignElement element, JRElementGroup group) {
        for (JRElementGroup g1 = element.getElementGroup(); g1 != null; g1 = g1.getElementGroup()) {
            if (g1 != group) continue;
            return true;
        }
        return false;
    }

    public static boolean isOrphan(JRDesignElement element) {
        return ModelUtils.getTopElementGroup(element) == null;
    }

    public static JRElementGroup getTopElementGroup(JRDesignElement element) {
        for (JRElementGroup g1 = element.getElementGroup(); g1 != null; g1 = g1.getElementGroup()) {
            if (!(g1 instanceof JRDesignBand) && !(g1 instanceof JRDesignCellContents)) continue;
            return g1;
        }
        return null;
    }

    public static JRDesignBand getBandAt(JasperDesign jd, Point p) {
        if (p.x < jd.getLeftMargin()) {
            return null;
        }
        if (p.x > jd.getPageWidth() - jd.getRightMargin()) {
            return null;
        }
        if (p.y < jd.getTopMargin()) {
            return null;
        }
        List<JRBand> bands = ModelUtils.getBands(jd);
        int currentHeight = jd.getTopMargin();
        for (JRBand tmpBand : bands) {
            if (p.y >= (currentHeight += tmpBand.getHeight())) continue;
            return (JRDesignBand)tmpBand;
        }
        return null;
    }

    public static JRDesignDataset getDatasetFromChartDataset(JRDesignChartDataset dataset, JasperDesign jd) {
        JRDesignDataset ds = (JRDesignDataset)jd.getMainDataset();
        if (dataset.getDatasetRun() != null && dataset.getDatasetRun().getDatasetName() != null) {
            ds = (JRDesignDataset)jd.getDatasetMap().get(dataset.getDatasetRun().getDatasetName());
        }
        return ds;
    }

    public static JRDesignDataset getDatasetFromCrosstabDataset(JRDesignCrosstabDataset dataset, JasperDesign jd) {
        JRDesignDataset ds = (JRDesignDataset)jd.getMainDataset();
        if (dataset.getDatasetRun() != null && dataset.getDatasetRun().getDatasetName() != null) {
            ds = (JRDesignDataset)jd.getDatasetMap().get(dataset.getDatasetRun().getDatasetName());
        }
        return ds;
    }

    public static void copyHyperlink(JRHyperlink from, JRHyperlink to) {
        if (from == null || to == null) {
            return;
        }
        try {
            ModelUtils.setHyperlinkAttribute(to, "HyperlinkAnchorExpression", JRExpression.class, from.getHyperlinkAnchorExpression() == null ? null : from.getHyperlinkAnchorExpression().clone());
            ModelUtils.setHyperlinkAttribute(to, "HyperlinkPageExpression", JRExpression.class, from.getHyperlinkPageExpression() == null ? null : from.getHyperlinkPageExpression().clone());
            ModelUtils.setHyperlinkAttribute(to, "HyperlinkReferenceExpression", JRExpression.class, from.getHyperlinkReferenceExpression() == null ? null : from.getHyperlinkReferenceExpression().clone());
            ModelUtils.setHyperlinkAttribute(to, "HyperlinkTarget", Byte.TYPE, from.getHyperlinkTarget());
            ModelUtils.setHyperlinkAttribute(to, "HyperlinkTooltipExpression", JRExpression.class, from.getHyperlinkTooltipExpression() == null ? null : from.getHyperlinkTooltipExpression().clone());
            ModelUtils.setHyperlinkAttribute(to, "LinkType", String.class, from.getLinkType() == null ? null : from.getLinkType());
            JRHyperlinkParameter[] params = from.getHyperlinkParameters();
            List parameters = ModelUtils.getHyperlinkParametersList(to);
            for (int i = 0; i < params.length; ++i) {
                parameters.add(params[0].clone());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static boolean isNephewOf(Node node, JRDesignCrosstab designCrosstab) {
        if (node == null || designCrosstab == null) {
            return false;
        }
        if (node.getLookup().lookup(JRDesignCrosstab.class) == designCrosstab) {
            return true;
        }
        if (node.getParentNode() != null) {
            return ModelUtils.isNephewOf(node.getParentNode(), designCrosstab);
        }
        return false;
    }

    private static List getHyperlinkParametersList(JRHyperlink hyperlink) {
        if (hyperlink == null) {
            return null;
        }
        try {
            Method m = hyperlink.getClass().getMethod("getHyperlinkParametersList", new Class[0]);
            return (List)m.invoke((Object)hyperlink, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static void setHyperlinkAttribute(JRHyperlink hyperlink, String attribute, Class clazz, Object value) {
        if (hyperlink == null) {
            return;
        }
        try {
            Method m = hyperlink.getClass().getMethod("set" + attribute, clazz);
            m.invoke((Object)hyperlink, value);
            IReportManager.getInstance().notifyReportChange();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void applyBoxProperties(JRLineBox to, JRLineBox from) {
        to.setPadding(from.getOwnPadding());
        to.setLeftPadding(from.getOwnLeftPadding());
        to.setRightPadding(from.getOwnRightPadding());
        to.setBottomPadding(from.getOwnBottomPadding());
        to.setTopPadding(from.getOwnTopPadding());
        ModelUtils.applyPenProperties((JRPen)to.getPen(), (JRPen)from.getPen());
        ModelUtils.applyPenProperties((JRPen)to.getTopPen(), (JRPen)from.getTopPen());
        ModelUtils.applyPenProperties((JRPen)to.getLeftPen(), (JRPen)from.getLeftPen());
        ModelUtils.applyPenProperties((JRPen)to.getBottomPen(), (JRPen)from.getBottomPen());
        ModelUtils.applyPenProperties((JRPen)to.getRightPen(), (JRPen)from.getRightPen());
    }

    public static void applyPenProperties(JRPen to, JRPen from) {
        to.setLineColor(from.getOwnLineColor());
        to.setLineWidth(from.getOwnLineWidth());
        to.setLineStyle(from.getOwnLineStyle());
    }

    public static void applyDiff(JRLineBox main, JRLineBox box) {
        if (main.getOwnPadding() != box.getOwnPadding()) {
            main.setPadding(null);
        }
        if (main.getOwnLeftPadding() != box.getOwnLeftPadding()) {
            main.setLeftPadding(null);
        }
        if (main.getOwnRightPadding() != box.getOwnRightPadding()) {
            main.setRightPadding(null);
        }
        if (main.getOwnBottomPadding() != box.getOwnBottomPadding()) {
            main.setBottomPadding(null);
        }
        if (main.getOwnTopPadding() != box.getOwnTopPadding()) {
            main.setTopPadding(null);
        }
        ModelUtils.applyDiff((JRPen)main.getPen(), (JRPen)box.getPen());
        ModelUtils.applyDiff((JRPen)main.getTopPen(), (JRPen)box.getTopPen());
        ModelUtils.applyDiff((JRPen)main.getLeftPen(), (JRPen)box.getLeftPen());
        ModelUtils.applyDiff((JRPen)main.getBottomPen(), (JRPen)box.getBottomPen());
        ModelUtils.applyDiff((JRPen)main.getRightPen(), (JRPen)box.getRightPen());
    }

    public static void applyDiff(JRPen main, JRPen from) {
        if (main.getOwnLineColor() != null && !main.getOwnLineColor().equals(from.getOwnLineColor())) {
            main.setLineColor(null);
        }
        if (main.getOwnLineWidth() != null && !main.getOwnLineWidth().equals(from.getOwnLineWidth())) {
            main.setLineWidth(null);
        }
        if (main.getOwnLineStyle() != null && !main.getOwnLineStyle().equals(from.getOwnLineStyle())) {
            main.setLineStyle(null);
        }
    }
}

