/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.tools.MaskedPlainDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class HexColorChooserPanel
extends AbstractColorChooserPanel {
    private JDialog dialog = null;
    private Color selectedColor = null;
    private boolean init = false;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JTextField jTextField1;

    public HexColorChooserPanel() {
        this.initComponents();
        this.jTextField1.setDocument(new MaskedPlainDocument("(#?)(([0-9]|[a-f]|[A-F]){0,6})"));
        this.jTextField1.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                if (HexColorChooserPanel.this.jTextField1.getText().length() >= 6) {
                    HexColorChooserPanel.this.updateColor();
                }
            }

            public void insertUpdate(DocumentEvent e) {
                if (HexColorChooserPanel.this.jTextField1.getText().length() >= 6) {
                    HexColorChooserPanel.this.updateColor();
                }
            }

            public void removeUpdate(DocumentEvent e) {
            }
        });
        this.jTextField1.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                HexColorChooserPanel.this.updateColor();
            }
        });
    }

    public void updateColor() {
        if (this.isInit()) {
            return;
        }
        Color c = HexColorChooserPanel.parseColorString(this.jTextField1.getText());
        if (c != null) {
            this.setInit(true);
            this.getColorSelectionModel().setSelectedColor(c);
            this.setInit(false);
        }
    }

    public static Color parseColorString(String newValue) {
        if (newValue == null) {
            return null;
        }
        newValue = newValue.trim();
        Color c = null;
        if (newValue.startsWith("#")) {
            newValue = newValue.substring(1);
        }
        if (newValue.length() == 6) {
            try {
                int hr = Integer.parseInt(newValue.substring(0, 2), 16);
                int hg = Integer.parseInt(newValue.substring(2, 4), 16);
                int hb = Integer.parseInt(newValue.substring(4, 6), 16);
                c = new Color(hr, hg, hb);
                return c;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText("Hex 0x");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jTextField1.setText("000000");
        this.jTextField1.setMinimumSize(new Dimension(100, 19));
        this.jTextField1.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 2, 4, 4);
        this.add((Component)this.jTextField1, gridBagConstraints);
        this.jPanel1.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    public static String getEncodedColor(Color c) {
        String nums = "0123456789ABCDEF";
        String s = "#";
        s = s + nums.charAt(c.getRed() / 16);
        s = s + nums.charAt(c.getRed() % 16);
        s = s + nums.charAt(c.getGreen() / 16);
        s = s + nums.charAt(c.getGreen() % 16);
        s = s + nums.charAt(c.getBlue() / 16);
        s = s + nums.charAt(c.getBlue() % 16);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChooser() {
        if (this.isInit()) {
            return;
        }
        Color c = this.getColorFromModel();
        if (c != null) {
            boolean oldValue = this.isInit();
            this.setInit(true);
            try {
                this.jTextField1.setText(HexColorChooserPanel.getEncodedColor(c));
            }
            finally {
                this.setInit(oldValue);
            }
        }
    }

    protected void buildChooser() {
    }

    public String getDisplayName() {
        return "Hex Value";
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public static Color showDialog(Component c, String title, Color defColor) {
        final JColorChooser jcc = new JColorChooser();
        final HexColorChooserPanel hcp = new HexColorChooserPanel();
        AbstractColorChooserPanel[] current_panels = jcc.getChooserPanels();
        AbstractColorChooserPanel[] panels = new AbstractColorChooserPanel[current_panels.length + 1];
        for (int i = 0; i < current_panels.length; ++i) {
            panels[i] = current_panels[i];
        }
        panels[i] = hcp;
        jcc.setChooserPanels(panels);
        JDialog theDialog = JColorChooser.createDialog(c, title, true, jcc, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                hcp.setSelectedColor(jcc.getColor());
                hcp.getDialog().setVisible(false);
                hcp.getDialog().dispose();
            }
        }, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                hcp.setSelectedColor(null);
                hcp.getDialog().setVisible(false);
                hcp.getDialog().dispose();
            }
        });
        hcp.setDialog(theDialog);
        theDialog.setVisible(true);
        return hcp.getSelectedColor();
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color selectedColor) {
        this.selectedColor = selectedColor;
    }

    private JDialog getDialog() {
        return this.dialog;
    }

    private void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }
}

