/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ParameterCompilable;
import mondrian.calc.ParameterSlot;
import mondrian.calc.impl.GenericCalc;
import mondrian.mdx.MemberExpr;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Literal;
import mondrian.olap.Parameter;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.Type;

public class ParameterImpl
implements Parameter,
ParameterCompilable {
    private final String name;
    private String description;
    private Exp defaultExp;
    private Type type;
    private ParameterSlot slot = new ParameterSlot(){
        Object value;

        public Object getCachedDefaultValue() {
            throw new UnsupportedOperationException();
        }

        public Calc getDefaultValueCalc() {
            throw new UnsupportedOperationException();
        }

        public int getIndex() {
            throw new UnsupportedOperationException();
        }

        public Parameter getParameter() {
            return ParameterImpl.this;
        }

        public Object getParameterValue() {
            return this.value;
        }

        public void setCachedDefaultValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public void setParameterValue(Object value) {
            this.value = value;
        }
    };

    public ParameterImpl(String name, Exp defaultExp, String description, Type type) {
        this.name = name;
        this.defaultExp = defaultExp;
        this.description = description;
        this.type = type;
        assert (defaultExp != null);
        assert (type instanceof StringType || type instanceof NumericType || type instanceof MemberType);
    }

    public Parameter.Scope getScope() {
        return Parameter.Scope.Statement;
    }

    public Type getType() {
        return this.type;
    }

    public Exp getDefaultExp() {
        return this.defaultExp;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        if (this.slot == null) {
            return null;
        }
        return this.slot.getParameterValue();
    }

    public void setValue(Object value) {
        if (value instanceof MemberExpr) {
            this.slot.setParameterValue(((MemberExpr)value).getMember());
        } else if (value instanceof Literal) {
            this.slot.setParameterValue(((Literal)value).getValue());
        } else {
            this.slot.setParameterValue(value);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Object[] getChildren() {
        return null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ParameterImpl)) {
            return false;
        }
        ParameterImpl that = (ParameterImpl)other;
        return that.getName().equals(this.getName()) && that.defaultExp.equals(this.defaultExp);
    }

    public boolean isModifiable() {
        return true;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(Type type) {
        assert (type instanceof StringType || type instanceof NumericType || type instanceof MemberType);
        this.type = type;
    }

    public void setDefaultExp(Exp defaultExp) {
        assert (defaultExp != null);
        this.defaultExp = defaultExp;
    }

    public Calc compile(ExpCompiler compiler) {
        ParameterSlot slot = compiler.registerParameter(this);
        if (this.slot != null) {
            slot.setParameterValue(this.slot.getParameterValue());
        }
        this.slot = slot;
        return new ParameterCalc(slot);
    }

    private static class ParameterCalc
    extends GenericCalc {
        private final ParameterSlot slot;

        public ParameterCalc(ParameterSlot slot) {
            super(new DummyExp(slot.getParameter().getType()));
            this.slot = slot;
        }

        public Calc[] getCalcs() {
            return new Calc[0];
        }

        public Object evaluate(Evaluator evaluator) {
            Object value = evaluator.getParameterValue(this.slot);
            if (this.slot.getParameterValue() == null) {
                this.slot.setParameterValue(value);
            }
            return value;
        }
    }
}

