/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ConstantPool;
import org.netbeans.modules.classfile.InvalidClassFormatException;

public final class LocalVariableTableEntry {
    int startPC;
    int length;
    String name;
    String description;
    int index;

    static LocalVariableTableEntry[] loadLocalVariableTable(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        LocalVariableTableEntry[] localVariableTableEntryArray = new LocalVariableTableEntry[n];
        for (int i = 0; i < n; ++i) {
            localVariableTableEntryArray[i] = new LocalVariableTableEntry(dataInputStream, constantPool);
        }
        return localVariableTableEntryArray;
    }

    LocalVariableTableEntry(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this.loadLocalVariableEntry(dataInputStream, constantPool);
    }

    private void loadLocalVariableEntry(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this.startPC = dataInputStream.readUnsignedShort();
        this.length = dataInputStream.readUnsignedShort();
        CPEntry cPEntry = constantPool.get(dataInputStream.readUnsignedShort());
        if (!(cPEntry instanceof CPUTF8Info)) {
            throw new InvalidClassFormatException();
        }
        CPUTF8Info cPUTF8Info = (CPUTF8Info)cPEntry;
        this.name = cPUTF8Info.getName();
        cPEntry = constantPool.get(dataInputStream.readUnsignedShort());
        if (!(cPEntry instanceof CPUTF8Info)) {
            throw new InvalidClassFormatException();
        }
        cPUTF8Info = (CPUTF8Info)cPEntry;
        this.description = cPUTF8Info.getName();
        this.index = dataInputStream.readUnsignedShort();
    }

    public final int getStartPC() {
        return this.startPC;
    }

    public final int getLength() {
        return this.length;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final int getIndex() {
        return this.index;
    }
}

