/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.beans.Beans;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertySupport<T>
extends Node.Property<T> {
    private boolean canR;
    private boolean canW;

    public PropertySupport(String string, Class<T> clazz, String string2, String string3, boolean bl, boolean bl2) {
        super(clazz);
        this.setName(string);
        this.setDisplayName(string2);
        this.setShortDescription(string3);
        this.canR = bl;
        this.canW = bl2;
    }

    @Override
    public boolean canRead() {
        return this.canR;
    }

    @Override
    public boolean canWrite() {
        return this.canW;
    }

    static <T> T cast(Class<T> clazz, Object object) {
        if (clazz.isPrimitive()) {
            return (T)object;
        }
        return clazz.cast(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Name
    extends PropertySupport<String> {
        private final Node node;

        public Name(Node node) {
            this(node, NbBundle.getBundle(PropertySupport.class).getString("CTL_StandardName"), NbBundle.getBundle(PropertySupport.class).getString("CTL_StandardHint"));
        }

        public Name(Node node, String string, String string2) {
            super("name", String.class, string, string2, true, node.canRename());
            this.node = node;
        }

        @Override
        public String getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.node.getName();
        }

        @Override
        public void setValue(String string) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            String string2 = this.node.getName();
            this.node.setName(string);
            this.node.firePropertyChange("name", string2, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ReadOnly<T>
    extends PropertySupport<T> {
        public ReadOnly(String string, Class<T> clazz, String string2, String string3) {
            super(string, clazz, string2, string3, true, false);
        }

        @Override
        public void setValue(T t) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new IllegalAccessException("Cannot write to ReadOnly property");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ReadWrite<T>
    extends PropertySupport<T> {
        public ReadWrite(String string, Class<T> clazz, String string2, String string3) {
            super(string, clazz, string2, string3, true, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reflection<T>
    extends Node.Property<T> {
        protected Object instance;
        private Method setter;
        private Method getter;
        private Class<? extends PropertyEditor> propertyEditorClass;

        public Reflection(Object object, Class<T> clazz, Method method, Method method2) {
            super(clazz);
            if (method != null && !Modifier.isPublic(method.getModifiers())) {
                throw new IllegalArgumentException("Cannot use a non-public getter " + method);
            }
            if (method2 != null && !Modifier.isPublic(method2.getModifiers())) {
                throw new IllegalArgumentException("Cannot use a non-public setter " + method2);
            }
            this.instance = object;
            this.setter = method2;
            this.getter = method;
        }

        public Reflection(Object object, Class<T> clazz, String string, String string2) throws NoSuchMethodException {
            this(object, clazz, string == null ? null : Reflection.findAccessibleClass(object.getClass()).getMethod(string, new Class[0]), string2 == null ? null : Reflection.findAccessibleClass(object.getClass()).getMethod(string2, clazz));
        }

        public Reflection(Object object, Class<T> clazz, String string) throws NoSuchMethodException {
            this(object, clazz, Reflection.findGetter(object, clazz, string), Reflection.findAccessibleClass(object.getClass()).getMethod(Reflection.firstLetterToUpperCase(string, "set"), clazz));
        }

        private static <C> Class<? super C> findAccessibleClass(Class<C> clazz) {
            if (Modifier.isPublic(clazz.getModifiers())) {
                return clazz;
            }
            Class<C> clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                return Object.class;
            }
            return Reflection.findAccessibleClass(clazz2);
        }

        private static String firstLetterToUpperCase(String string, String string2) {
            switch (string.length()) {
                case 0: {
                    return string2;
                }
                case 1: {
                    return string2 + Character.toUpperCase(string.charAt(0));
                }
            }
            return string2 + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }

        private static Method findGetter(Object object, Class clazz, String string) throws NoSuchMethodException {
            try {
                return Reflection.findAccessibleClass(object.getClass()).getMethod(Reflection.firstLetterToUpperCase(string, "get"), new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (clazz != Boolean.TYPE) {
                    throw noSuchMethodException;
                }
                NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
                return Reflection.findAccessibleClass(object.getClass()).getMethod(Reflection.firstLetterToUpperCase(string, "is"), new Class[0]);
            }
        }

        @Override
        public boolean canRead() {
            return this.getter != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.getter == null) {
                throw new IllegalAccessException();
            }
            Object object = Beans.getInstanceOf(this.instance, this.getter.getDeclaringClass());
            try {
                return PropertySupport.cast(this.getValueType(), this.getter.invoke(object, new Object[0]));
            }
            catch (IllegalAccessException illegalAccessException) {
                Object t;
                try {
                    this.getter.setAccessible(true);
                    t = PropertySupport.cast(this.getValueType(), this.getter.invoke(object, new Object[0]));
                    this.getter.setAccessible(false);
                }
                catch (Throwable throwable) {
                    try {
                        this.getter.setAccessible(false);
                        throw throwable;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        StringBuffer stringBuffer = new StringBuffer("Attempted to invoke method ");
                        stringBuffer.append(this.getter.getName());
                        stringBuffer.append(" from class ");
                        stringBuffer.append(this.getter.getDeclaringClass().getName());
                        stringBuffer.append(" on an instance of ");
                        stringBuffer.append(object.getClass().getName());
                        stringBuffer.append(" Problem:");
                        stringBuffer.append(illegalArgumentException.getMessage());
                        throw (IllegalArgumentException)new IllegalArgumentException(stringBuffer.toString()).initCause(illegalArgumentException);
                    }
                }
                return t;
            }
        }

        @Override
        public boolean canWrite() {
            return this.setter != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(T t) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.setter == null) {
                throw new IllegalAccessException();
            }
            Object object = Beans.getInstanceOf(this.instance, this.setter.getDeclaringClass());
            try {
                this.setter.invoke(object, t);
            }
            catch (IllegalAccessException illegalAccessException) {
                try {
                    this.setter.setAccessible(true);
                    this.setter.invoke(object, t);
                }
                finally {
                    this.setter.setAccessible(false);
                }
            }
        }

        @Override
        public PropertyEditor getPropertyEditor() {
            if (this.propertyEditorClass != null) {
                try {
                    return this.propertyEditorClass.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    Exceptions.printStackTrace((Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Exceptions.printStackTrace((Throwable)illegalAccessException);
                }
            }
            return super.getPropertyEditor();
        }

        public void setPropertyEditorClass(Class<? extends PropertyEditor> clazz) {
            this.propertyEditorClass = clazz;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class WriteOnly<T>
    extends PropertySupport<T> {
        public WriteOnly(String string, Class<T> clazz, String string2, String string3) {
            super(string, clazz, string2, string3, false, true);
        }

        @Override
        public T getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new IllegalAccessException("Cannod read from WriteOnly property");
        }
    }
}

