/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.crosstab.wizard;

import com.jaspersoft.ireport.designer.crosstab.wizard.LayoutPreviewPanel;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.utils.ColorSchemaGenerator;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;

public final class CrosstabVisualPanel5
extends JPanel {
    private JCheckBox jCheckBoxColumnGroupTotals;
    private JCheckBox jCheckBoxRowGroupTotals;
    private JCheckBox jCheckBoxShowGrid;
    private JCheckBox jCheckBoxWhiteGrid;
    private JComboBox jComboBoxColors;
    private JComboBox jComboBoxVariations;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private LayoutPreviewPanel layoutPreviewPanel1;

    public CrosstabVisualPanel5() {
        this.initComponents();
        List<String> colors = ColorSchemaGenerator.getColors();
        for (int i = 0; i < colors.size(); ++i) {
            this.jComboBoxColors.addItem(colors.get(i));
        }
        List<Tag> variants = ColorSchemaGenerator.getVariants();
        for (int i = 0; i < variants.size(); ++i) {
            this.jComboBoxVariations.addItem(variants.get(i));
        }
        this.updatePreview();
    }

    public String getName() {
        return "Layout";
    }

    public void readSettings(WizardDescriptor settings) {
        String variant;
        this.jCheckBoxRowGroupTotals.setSelected(settings.getProperty("rowGroupTotals") == null ? Boolean.TRUE : (Boolean)settings.getProperty("rowGroupTotals"));
        this.jCheckBoxColumnGroupTotals.setSelected(settings.getProperty("columnGroupTotals") == null ? Boolean.TRUE : (Boolean)settings.getProperty("columnGroupTotals"));
        this.jCheckBoxShowGrid.setSelected(settings.getProperty("showGrid") == null ? Boolean.TRUE : (Boolean)settings.getProperty("showGrid"));
        this.jCheckBoxWhiteGrid.setSelected(settings.getProperty("whiteGrid") == null ? Boolean.FALSE : (Boolean)settings.getProperty("whiteGrid"));
        String schema = (String)settings.getProperty("schemaColor");
        if (schema != null) {
            this.jComboBoxColors.setSelectedItem(schema);
        }
        if ((variant = (String)settings.getProperty("schemaVariant")) != null) {
            Misc.setComboboxSelectedTagValue(this.jComboBoxColors, variant);
        }
    }

    public void storeSettings(WizardDescriptor settings) {
        settings.putProperty("rowGroupTotals", (Object)this.jCheckBoxRowGroupTotals.isSelected());
        settings.putProperty("columnGroupTotals", (Object)this.jCheckBoxColumnGroupTotals.isSelected());
        settings.putProperty("showGrid", (Object)this.jCheckBoxShowGrid.isSelected());
        settings.putProperty("whiteGrid", (Object)this.jCheckBoxWhiteGrid.isSelected());
        settings.putProperty("schemaColor", this.jComboBoxColors.getSelectedItem());
        if (this.jComboBoxVariations.getSelectedItem() != null) {
            settings.putProperty("schemaVariant", ((Tag)this.jComboBoxVariations.getSelectedItem()).getValue());
        }
    }

    private void initComponents() {
        this.jCheckBoxRowGroupTotals = new JCheckBox();
        this.jCheckBoxColumnGroupTotals = new JCheckBox();
        this.jCheckBoxShowGrid = new JCheckBox();
        this.layoutPreviewPanel1 = new LayoutPreviewPanel();
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.jComboBoxColors = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBoxVariations = new JComboBox();
        this.jCheckBoxWhiteGrid = new JCheckBox();
        this.jCheckBoxRowGroupTotals.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxRowGroupTotals, (String)"Add row group totals");
        this.jCheckBoxRowGroupTotals.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabVisualPanel5.this.jCheckBoxRowGroupTotalsActionPerformed(evt);
            }
        });
        this.jCheckBoxColumnGroupTotals.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxColumnGroupTotals, (String)"Add column group totals");
        this.jCheckBoxColumnGroupTotals.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabVisualPanel5.this.jCheckBoxColumnGroupTotalsActionPerformed(evt);
            }
        });
        this.jCheckBoxShowGrid.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxShowGrid, (String)"Show grid lines (adding cell border)");
        this.jCheckBoxShowGrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabVisualPanel5.this.jCheckBoxShowGridActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)"Color scheme");
        this.jComboBoxColors.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabVisualPanel5.this.jComboBoxColorsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)"Variations");
        this.jComboBoxVariations.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabVisualPanel5.this.jComboBoxVariationsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxWhiteGrid, (String)"Use a white grid");
        this.jCheckBoxWhiteGrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabVisualPanel5.this.jCheckBoxWhiteGridActionPerformed(evt);
            }
        });
        this.jCheckBoxWhiteGrid.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                CrosstabVisualPanel5.this.jCheckBoxWhiteGridStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(126, 126, 126).add((Component)this.layoutPreviewPanel1, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jCheckBoxRowGroupTotals, -1, 275, Short.MAX_VALUE).add(90, 90, 90)).add(2, (Component)this.jCheckBoxColumnGroupTotals, -1, 365, Short.MAX_VALUE).add((Component)this.jCheckBoxShowGrid, -1, 365, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jSeparator1, -1, 361, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1, -2, 102, -2).add((Component)this.jLabel2, -2, 102, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jComboBoxVariations, 0, 255, Short.MAX_VALUE).add((Component)this.jComboBoxColors, 0, 255, Short.MAX_VALUE)))).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jCheckBoxWhiteGrid, -1, 188, Short.MAX_VALUE).add(187, 187, 187)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.layoutPreviewPanel1, -2, -1, -2).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxColors, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jComboBoxVariations, -2, -1, -2)).addPreferredGap(1).add((Component)this.jCheckBoxWhiteGrid).addPreferredGap(0, 17, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jCheckBoxRowGroupTotals).addPreferredGap(0).add((Component)this.jCheckBoxColumnGroupTotals).addPreferredGap(0).add((Component)this.jCheckBoxShowGrid).addContainerGap(57, Short.MAX_VALUE)));
    }

    private void jCheckBoxRowGroupTotalsActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxColumnGroupTotalsActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxShowGridActionPerformed(ActionEvent evt) {
    }

    private void jComboBoxColorsActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void jComboBoxVariationsActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void jCheckBoxWhiteGridActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxWhiteGridStateChanged(ChangeEvent evt) {
        this.updatePreview();
    }

    public void updatePreview() {
        Tag var;
        String s = "" + this.jComboBoxColors.getSelectedItem();
        Color c = ColorSchemaGenerator.getColor(s);
        if (c != null) {
            this.layoutPreviewPanel1.setColor(c);
        }
        if ((var = (Tag)this.jComboBoxVariations.getSelectedItem()) != null) {
            this.layoutPreviewPanel1.setVariant((String)var.getValue());
        }
        this.layoutPreviewPanel1.setWhiteGrid(this.jCheckBoxWhiteGrid.isSelected());
    }
}

