/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data;

import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditorPane;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.EditorKit;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import org.openide.text.CloneableEditorSupport;

public class FilterExpressionDialog
extends JDialog {
    private String filterExpression = "";
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private ExpressionEditorPane jEditorPaneFilterExpression;
    private int dialogResult;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_EXPRESSION = 1;

    public FilterExpressionDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public FilterExpressionDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        EditorKit kit = CloneableEditorSupport.getEditorKit((String)"text/jrxml-expression");
        this.jEditorPaneFilterExpression.setEditorKit(kit);
        this.pack();
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FilterExpressionDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jEditorPaneFilterExpression = new ExpressionEditorPane();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify field");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FilterExpressionDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Filter expression");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jEditorPaneFilterExpression.setBorder(BorderFactory.createEtchedBorder());
        this.jEditorPaneFilterExpression.setMinimumSize(new Dimension(657, 50));
        this.jEditorPaneFilterExpression.setPreferredSize(new Dimension(600, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.getContentPane().add((Component)this.jEditorPaneFilterExpression, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setText("OK");
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilterExpressionDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FilterExpressionDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.filterExpression = this.jEditorPaneFilterExpression.getText();
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(String filterExpression) {
        this.setFilterExpression(filterExpression, null);
    }

    public void setFilterExpression(String filterExpression, JRDesignDataset subDataset) {
        this.filterExpression = filterExpression;
        this.jEditorPaneFilterExpression.setText(filterExpression);
        if (subDataset != null) {
            this.jEditorPaneFilterExpression.setExpressionContext(new ExpressionContext(subDataset));
        }
    }

    public void setFocusedExpression(int expID) {
        switch (expID) {
            case 1: {
                Misc.selectTextAndFocusArea(this.jEditorPaneFilterExpression);
            }
        }
    }
}

