/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.ddl.util;

import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.lib.ddl.DDLCommand;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.util.CommandBufferExceptionHandler;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class CommandBuffer {
    Vector commands;
    CommandBufferExceptionHandler handler;
    boolean debugmode;
    boolean executionWithException;

    public void add(DDLCommand cmd) {
        if (this.commands == null) {
            this.commands = new Vector();
        }
        this.commands.add(cmd);
    }

    public void setExceptionHandler(CommandBufferExceptionHandler hand) {
        this.handler = hand;
    }

    public boolean isDebugMode() {
        return this.debugmode;
    }

    public void setDebugMode(boolean flag) {
        this.debugmode = flag;
    }

    public String getCommands() throws DDLException {
        String cmds = "";
        Enumeration cmd_e = this.commands.elements();
        while (cmd_e.hasMoreElements()) {
            DDLCommand e_cmd = (DDLCommand)cmd_e.nextElement();
            cmds = cmds + e_cmd.getCommand() + "\n";
        }
        return cmds;
    }

    public void execute() throws DDLException {
        boolean opencon = false;
        this.executionWithException = false;
        DatabaseSpecification spec = null;
        Enumeration cmd_e = this.commands.elements();
        while (cmd_e.hasMoreElements()) {
            DDLCommand e_cmd = (DDLCommand)cmd_e.nextElement();
            try {
                if (spec == null && (spec = e_cmd.getSpecification()).getJDBCConnection() == null) {
                    opencon = true;
                    spec.openJDBCConnection();
                }
                if (this.debugmode) {
                    System.out.println(e_cmd);
                }
                e_cmd.execute();
                this.executionWithException = e_cmd.wasException();
            }
            catch (Exception e) {
                this.executionWithException = true;
                boolean exres = false;
                if (this.handler != null) {
                    exres = this.handler.shouldContinueAfterException(e);
                }
                if (exres) continue;
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
            }
        }
        if (opencon) {
            spec.closeJDBCConnection();
        }
    }

    public boolean wasException() {
        return this.executionWithException;
    }
}

