/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.openide.explorer.view.NodeModel;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.VisualizerEvent;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.Mutex;

public class NodeTreeModel
extends DefaultTreeModel {
    static final long serialVersionUID = 1900670294524747212L;
    private transient Listener listener;
    private CopyOnWriteArrayList<TreeView> views = new CopyOnWriteArrayList();

    void addView(TreeView treeView) {
        this.views.add(treeView);
    }

    public NodeTreeModel() {
        super(VisualizerNode.EMPTY, true);
    }

    public NodeTreeModel(Node node) {
        super(VisualizerNode.EMPTY, true);
        this.setNode(node);
    }

    public void setNode(final Node node) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                VisualizerNode visualizerNode;
                VisualizerNode visualizerNode2 = (VisualizerNode)NodeTreeModel.this.getRoot();
                if (visualizerNode2 == (visualizerNode = VisualizerNode.getVisualizer(null, node))) {
                    return;
                }
                visualizerNode2.removeNodeModel(NodeTreeModel.this.listener());
                visualizerNode.addNodeModel(NodeTreeModel.this.listener());
                NodeTreeModel.this.setRoot(visualizerNode);
            }
        });
    }

    private Listener listener() {
        if (this.listener == null) {
            this.listener = new Listener(this);
        }
        return this.listener;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        if (treePath == null) {
            return;
        }
        Object object2 = treePath.getLastPathComponent();
        if (object2 instanceof VisualizerNode) {
            this.nodeChanged((VisualizerNode)object2);
            return;
        }
        MutableTreeNode mutableTreeNode = (MutableTreeNode)object2;
        mutableTreeNode.setUserObject(object);
        this.nodeChanged(mutableTreeNode);
    }

    private static final class Listener
    implements NodeModel {
        private Reference<NodeTreeModel> model;

        public Listener(NodeTreeModel nodeTreeModel) {
            this.model = new WeakReference<NodeTreeModel>(nodeTreeModel);
        }

        private NodeTreeModel get(VisualizerEvent visualizerEvent) {
            NodeTreeModel nodeTreeModel = this.model.get();
            if (nodeTreeModel == null && visualizerEvent != null) {
                visualizerEvent.getVisualizer().removeNodeModel(this);
                return null;
            }
            return nodeTreeModel;
        }

        public void added(VisualizerEvent.Added added) {
            NodeTreeModel nodeTreeModel = this.get(added);
            if (nodeTreeModel == null) {
                return;
            }
            nodeTreeModel.nodesWereInserted(added.getVisualizer(), added.getArray());
        }

        public void removed(VisualizerEvent.Removed removed) {
            NodeTreeModel nodeTreeModel = this.get(removed);
            if (nodeTreeModel == null) {
                return;
            }
            for (TreeView treeView : nodeTreeModel.views) {
                treeView.removedNodes(removed.removed);
            }
            nodeTreeModel.nodesWereRemoved(removed.getVisualizer(), removed.getArray(), removed.removed.toArray());
        }

        public void reordered(VisualizerEvent.Reordered reordered) {
            NodeTreeModel nodeTreeModel = this.get(reordered);
            if (nodeTreeModel == null) {
                return;
            }
            nodeTreeModel.nodeStructureChanged(reordered.getVisualizer());
        }

        public void update(VisualizerNode visualizerNode) {
            NodeTreeModel nodeTreeModel = this.get(null);
            if (nodeTreeModel == null) {
                return;
            }
            nodeTreeModel.nodeChanged(visualizerNode);
        }

        public void structuralChange(VisualizerNode visualizerNode) {
            NodeTreeModel nodeTreeModel = this.get(null);
            if (nodeTreeModel == null) {
                return;
            }
            nodeTreeModel.nodeStructureChanged(visualizerNode);
        }
    }
}

