/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.builtin.Hunk;
import org.netbeans.modules.diff.builtin.visualizer.TextDiffVisualizer;

final class UnifiedDiff {
    private final TextDiffVisualizer.TextDiffInfo diffInfo;
    private BufferedReader baseReader;
    private BufferedReader modifiedReader;
    private final String newline;
    private boolean baseEndsWithNewline;
    private boolean modifiedEndsWithNewline;
    private int currentBaseLine;
    private int currentModifiedLine;

    public UnifiedDiff(TextDiffVisualizer.TextDiffInfo textDiffInfo) {
        this.diffInfo = textDiffInfo;
        this.currentBaseLine = 1;
        this.currentModifiedLine = 1;
        this.newline = System.getProperty("line.separator");
    }

    public String computeDiff() throws IOException {
        this.baseReader = this.checkEndingNewline(this.diffInfo.createFirstReader(), true);
        this.modifiedReader = this.checkEndingNewline(this.diffInfo.createSecondReader(), false);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("--- ");
        stringBuilder.append(this.diffInfo.getName1());
        stringBuilder.append(this.newline);
        stringBuilder.append("+++ ");
        stringBuilder.append(this.diffInfo.getName2());
        stringBuilder.append(this.newline);
        Difference[] differenceArray = this.diffInfo.getDifferences();
        int n = 0;
        while (n < differenceArray.length) {
            int n2 = this.getLastIndex(n);
            Hunk hunk = this.computeHunk(n, n2);
            this.dumpHunk(stringBuilder, hunk);
            n = n2;
        }
        return stringBuilder.toString();
    }

    private BufferedReader checkEndingNewline(Reader reader, boolean bl) throws IOException {
        char c;
        StringWriter stringWriter = new StringWriter();
        UnifiedDiff.copyStreamsCloseAll(stringWriter, reader);
        String string = stringWriter.toString();
        char c2 = c = string.length() == 0 ? (char)'\u0000' : string.charAt(string.length() - 1);
        if (bl) {
            this.baseEndsWithNewline = c == '\n' || c == '\r';
        } else {
            this.modifiedEndsWithNewline = c == '\n' || c == '\r';
        }
        return new BufferedReader(new StringReader(string));
    }

    private Hunk computeHunk(int n, int n2) throws IOException {
        int n3;
        Hunk hunk = new Hunk();
        Difference difference = this.diffInfo.getDifferences()[n];
        int n4 = this.diffInfo.getContextNumLines();
        if (difference.getType() == 1) {
            if (n4 > difference.getFirstStart()) {
                n4 = difference.getFirstStart();
            }
            n3 = difference.getFirstStart() - n4 - this.currentBaseLine + 1;
        } else {
            if (n4 >= difference.getFirstStart()) {
                n4 = difference.getFirstStart() - 1;
            }
            n3 = difference.getFirstStart() - n4 - this.currentBaseLine;
        }
        while (n3-- > 0) {
            this.readLine(this.baseReader);
            this.readLine(this.modifiedReader);
        }
        hunk.baseStart = this.currentBaseLine;
        hunk.modifiedStart = this.currentModifiedLine;
        for (int i = n; i < n2; ++i) {
            int n5;
            Difference difference2 = this.diffInfo.getDifferences()[i];
            this.writeContextLines(hunk, difference2.getFirstStart() - this.currentBaseLine + (difference2.getType() == 1 ? 1 : 0));
            if (difference2.getFirstEnd() > 0) {
                n5 = difference2.getFirstEnd() - difference2.getFirstStart() + 1;
                this.outputLines(hunk, this.baseReader, "-", n5);
                hunk.baseCount += n5;
                if (!this.baseEndsWithNewline && i == this.diffInfo.getDifferences().length - 1 && difference2.getFirstEnd() == this.currentBaseLine - 1) {
                    hunk.lines.add("\\ No newline at end of file");
                }
            }
            if (difference2.getSecondEnd() <= 0) continue;
            n5 = difference2.getSecondEnd() - difference2.getSecondStart() + 1;
            this.outputLines(hunk, this.modifiedReader, "+", n5);
            hunk.modifiedCount += n5;
            if (this.modifiedEndsWithNewline || i != this.diffInfo.getDifferences().length - 1 || difference2.getSecondEnd() != this.currentModifiedLine - 1) continue;
            hunk.lines.add("\\ No newline at end of file");
        }
        this.writeContextLines(hunk, this.diffInfo.getContextNumLines());
        if (hunk.modifiedCount == 0) {
            hunk.modifiedStart = 0;
        }
        if (hunk.baseCount == 0) {
            hunk.baseStart = 0;
        }
        return hunk;
    }

    private void writeContextLines(Hunk hunk, int n) throws IOException {
        while (n-- > 0) {
            String string = this.readLine(this.baseReader);
            if (string == null) {
                return;
            }
            hunk.lines.add(" " + string);
            this.readLine(this.modifiedReader);
            ++hunk.baseCount;
            ++hunk.modifiedCount;
        }
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string != null) {
            if (bufferedReader == this.baseReader) {
                ++this.currentBaseLine;
            }
            if (bufferedReader == this.modifiedReader) {
                ++this.currentModifiedLine;
            }
        }
        return string;
    }

    private void outputLines(Hunk hunk, BufferedReader bufferedReader, String string, int n) throws IOException {
        while (n-- > 0) {
            String string2 = this.readLine(bufferedReader);
            hunk.lines.add(string + string2);
        }
    }

    private int getLastIndex(int n) {
        int n2 = this.diffInfo.getContextNumLines() * 2;
        Difference[] differenceArray = this.diffInfo.getDifferences();
        ++n;
        while (n < differenceArray.length) {
            int n3;
            Difference difference = differenceArray[n - 1];
            Difference difference2 = differenceArray[n];
            int n4 = 1 + (difference.getType() == 1 ? difference.getFirstStart() : difference.getFirstEnd());
            int n5 = n3 = difference2.getType() == 1 ? difference2.getFirstStart() + 1 : difference2.getFirstStart();
            if (n3 - n4 > n2) break;
            ++n;
        }
        return n;
    }

    private void dumpHunk(StringBuilder stringBuilder, Hunk hunk) {
        stringBuilder.append("@@ -");
        stringBuilder.append(Integer.toString(hunk.baseStart));
        if (hunk.baseCount != 1) {
            stringBuilder.append(",");
            stringBuilder.append(Integer.toString(hunk.baseCount));
        }
        stringBuilder.append(" +");
        stringBuilder.append(Integer.toString(hunk.modifiedStart));
        if (hunk.modifiedCount != 1) {
            stringBuilder.append(",");
            stringBuilder.append(Integer.toString(hunk.modifiedCount));
        }
        stringBuilder.append(" @@");
        stringBuilder.append(this.newline);
        for (String string : hunk.lines) {
            stringBuilder.append(string);
            stringBuilder.append(this.newline);
        }
    }

    private static void copyStreamsCloseAll(Writer writer, Reader reader) throws IOException {
        int n;
        char[] cArray = new char[4096];
        while ((n = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n);
        }
        writer.close();
        reader.close();
    }
}

