/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.animator;

import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.visual.animator.AnimatorEvent;
import org.netbeans.api.visual.animator.AnimatorListener;
import org.netbeans.api.visual.animator.SceneAnimator;
import org.netbeans.api.visual.widget.Scene;

public abstract class Animator {
    private CopyOnWriteArrayList<AnimatorListener> listeners = new CopyOnWriteArrayList();
    private SceneAnimator sceneAnimator;
    private boolean reset;

    protected Animator(SceneAnimator sceneAnimator) {
        assert (sceneAnimator != null);
        this.sceneAnimator = sceneAnimator;
    }

    protected final Scene getScene() {
        return this.sceneAnimator.getScene();
    }

    protected final void start() {
        if (!this.listeners.isEmpty()) {
            AnimatorEvent animatorEvent = new AnimatorEvent(this);
            for (AnimatorListener animatorListener : this.listeners) {
                animatorListener.animatorStarted(animatorEvent);
            }
        }
        this.sceneAnimator.start(this);
    }

    public final boolean isRunning() {
        return this.sceneAnimator.isRunning(this);
    }

    final void reset() {
        if (!this.listeners.isEmpty()) {
            AnimatorEvent animatorEvent = new AnimatorEvent(this);
            for (AnimatorListener animatorListener : this.listeners) {
                animatorListener.animatorReset(animatorEvent);
            }
        }
        this.reset = true;
    }

    final void performTick(double d) {
        AnimatorEvent animatorEvent;
        if (this.reset) {
            this.reset = false;
            return;
        }
        if (!this.listeners.isEmpty()) {
            animatorEvent = new AnimatorEvent(this, d);
            for (AnimatorListener animatorListener : this.listeners) {
                animatorListener.animatorPreTick(animatorEvent);
            }
        }
        this.tick(d);
        if (!this.listeners.isEmpty()) {
            animatorEvent = new AnimatorEvent(this, d);
            for (AnimatorListener animatorListener : this.listeners) {
                animatorListener.animatorPostTick(animatorEvent);
            }
        }
        if (d >= 1.0 && !this.listeners.isEmpty()) {
            animatorEvent = new AnimatorEvent(this);
            for (AnimatorListener animatorListener : this.listeners) {
                animatorListener.animatorFinished(animatorEvent);
            }
        }
    }

    protected abstract void tick(double var1);

    public void addAnimatorListener(AnimatorListener animatorListener) {
        this.listeners.add(animatorListener);
    }

    public void removeAnimatorListener(AnimatorListener animatorListener) {
        this.listeners.remove(animatorListener);
    }
}

