/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.options;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.fonts.CheckBoxList;
import com.jaspersoft.ireport.designer.fonts.CheckBoxListEntry;
import com.jaspersoft.ireport.designer.options.IReportOptionsPanelController;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.tools.LocaleSelectorDialog;
import com.jaspersoft.ireport.designer.tools.TimeZoneDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.utils.Unit;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IReportPanel
extends JPanel {
    private final IReportOptionsPanelController controller;
    private Locale currentReportLocale = null;
    private String currentReportTimeZoneId = null;
    private JButton jButtonAddClasspathItem;
    private JButton jButtonAddClasspathItem1;
    private JButton jButtonDeselectAllFonts;
    private JButton jButtonMoveDownClasspathItem;
    private JButton jButtonMoveUpClasspathItem;
    private JButton jButtonRemoveClasspathItem;
    private JButton jButtonReportLocale;
    private JButton jButtonSelectAllFonts;
    private JButton jButtonTimeZone;
    private JCheckBox jCheckBoxIgnorePagination;
    private JCheckBox jCheckBoxLimitRecordNumber;
    private JComboBox jComboBoxUnits;
    private JLabel jLabel1;
    private JLabel jLabelClasspath;
    private JLabel jLabelFontspath;
    private JLabel jLabelMaxNumber;
    private JLabel jLabelReportLocale;
    private JLabel jLabelTimeZone;
    private JList jListClassPath;
    private CheckBoxList jListFontspath;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSpinner jSpinnerMaxRecordNumber;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldReportLocale;
    private JTextField jTextFieldTimeZone;

    IReportPanel(IReportOptionsPanelController ctlr) {
        this.controller = ctlr;
        this.initComponents();
        Unit[] units = Unit.getStandardUnits();
        for (int i = 0; i < units.length; ++i) {
            this.jComboBoxUnits.addItem(new Tag(units[i].getKeyName(), units[i].getUnitName()));
        }
        this.jListClassPath.setModel(new DefaultListModel());
        this.jListFontspath.setModel(new DefaultListModel());
        this.jListFontspath.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                IReportPanel.this.controller.changed();
            }
        });
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBoxUnits = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jCheckBoxLimitRecordNumber = new JCheckBox();
        this.jLabelMaxNumber = new JLabel();
        this.jSpinnerMaxRecordNumber = new JSpinner();
        this.jTextFieldReportLocale = new JTextField();
        this.jButtonReportLocale = new JButton();
        this.jLabelReportLocale = new JLabel();
        this.jLabelTimeZone = new JLabel();
        this.jTextFieldTimeZone = new JTextField();
        this.jButtonTimeZone = new JButton();
        this.jCheckBoxIgnorePagination = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jLabelClasspath = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListClassPath = new JList();
        this.jPanel5 = new JPanel();
        this.jButtonAddClasspathItem = new JButton();
        this.jButtonAddClasspathItem1 = new JButton();
        this.jButtonRemoveClasspathItem = new JButton();
        this.jButtonMoveUpClasspathItem = new JButton();
        this.jButtonMoveDownClasspathItem = new JButton();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLabelFontspath = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jListFontspath = new CheckBoxList();
        this.jPanel8 = new JPanel();
        this.jButtonSelectAllFonts = new JButton();
        this.jButtonDeselectAllFonts = new JButton();
        this.jPanel9 = new JPanel();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Units"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)I18n.getString("IReportPanel.Label.DefaultUnit"));
        this.jComboBoxUnits.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IReportPanel.this.jComboBoxUnitsActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jComboBoxUnits, -2, 72, -2).addContainerGap(334, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jComboBoxUnits, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Report execution options"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxLimitRecordNumber, (String)I18n.getString("IReportPanel.CheckBox.LimitRecords"));
        this.jCheckBoxLimitRecordNumber.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                IReportPanel.this.jCheckBoxLimitRecordNumberStateChanged(evt);
            }
        });
        this.jCheckBoxLimitRecordNumber.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IReportPanel.this.jCheckBoxLimitRecordNumberActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabelMaxNumber, (String)I18n.getString("IReportPanel.Label.MaxReports"));
        this.jLabelMaxNumber.setEnabled(false);
        this.jSpinnerMaxRecordNumber.setModel(new SpinnerNumberModel((Number)5000, Integer.valueOf(1), null, (Number)1));
        this.jSpinnerMaxRecordNumber.setEnabled(false);
        this.jSpinnerMaxRecordNumber.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                IReportPanel.this.jSpinnerMaxRecordNumberStateChanged(evt);
            }
        });
        this.jTextFieldReportLocale.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonReportLocale, (String)I18n.getString("IReportPanel.Button.Select"));
        this.jButtonReportLocale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IReportPanel.this.jButtonReportLocaleActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabelReportLocale, (String)I18n.getString("IReportPanel.Label.ReportLocale"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelTimeZone, (String)I18n.getString("IReportPanel.Label.ReportTimeZone"));
        this.jTextFieldTimeZone.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonTimeZone, (String)I18n.getString("IReportPanel.Button.Select"));
        this.jButtonTimeZone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IReportPanel.this.jButtonTimeZoneActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxIgnorePagination, (String)I18n.getString("IReportPanel.CheckBox.IgnorePagination"));
        this.jCheckBoxIgnorePagination.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                IReportPanel.this.jCheckBoxIgnorePaginationStateChanged(evt);
            }
        });
        this.jCheckBoxIgnorePagination.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IReportPanel.this.jCheckBoxIgnorePaginationActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(27, 27, 27).add((Component)this.jLabelMaxNumber).add(18, 18, 18).add((Component)this.jSpinnerMaxRecordNumber, -2, 83, -2)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jCheckBoxLimitRecordNumber, -1, 460, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jTextFieldReportLocale, -1, 377, Short.MAX_VALUE).add((Component)this.jLabelReportLocale, -1, 377, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jButtonReportLocale)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jTextFieldTimeZone, -1, 377, Short.MAX_VALUE).add((Component)this.jLabelTimeZone, -1, 377, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jButtonTimeZone)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jCheckBoxIgnorePagination, -1, 460, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jCheckBoxLimitRecordNumber).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabelMaxNumber).add((Component)this.jSpinnerMaxRecordNumber, -2, -1, -2)).add(31, 31, 31).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jTextFieldReportLocale, -2, -1, -2).add((Component)this.jButtonReportLocale))).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(63, 63, 63).add((Component)this.jLabelReportLocale))).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(13, 13, 13).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jTextFieldTimeZone, -2, -1, -2).add((Component)this.jButtonTimeZone))).add((Component)this.jLabelTimeZone)).addPreferredGap(1).add((Component)this.jCheckBoxIgnorePagination)));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 508, Short.MAX_VALUE).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap())));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 327, Short.MAX_VALUE).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addContainerGap(49, Short.MAX_VALUE))));
        this.jTabbedPane1.addTab("General", this.jPanel3);
        this.jLabelClasspath.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.jLabelClasspath, (String)I18n.getString("IReportPanel.Label.Classpath"));
        this.jScrollPane1.setViewportView(this.jListClassPath);
        this.jPanel5.setMinimumSize(new Dimension(120, 10));
        this.jPanel5.setPreferredSize(new Dimension(120, 10));
        this.jPanel5.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAddClasspathItem, (String)I18n.getString("IReportPanel.Button.AddJAR"));
        this.jButtonAddClasspathItem.setMaximumSize(new Dimension(200, 26));
        this.jButtonAddClasspathItem.setMinimumSize(new Dimension(90, 26));
        this.jButtonAddClasspathItem.setPreferredSize(new Dimension(120, 26));
        this.jButtonAddClasspathItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IReportPanel.this.jButtonAddClasspathItemActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel5.add((Component)this.jButtonAddClasspathItem, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAddClasspathItem1, (String)I18n.getString("IReportPanel.Button.AddFolder"));
        this.jButtonAddClasspathItem1.setMaximumSize(new Dimension(200, 26));
        this.jButtonAddClasspathItem1.setMinimumSize(new Dimension(90, 26));
        this.jButtonAddClasspathItem1.setPreferredSize(new Dimension(120, 26));
        this.jButtonAddClasspathItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IReportPanel.this.jButtonAddClasspathItem1jButtonAddActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel5.add((Component)this.jButtonAddClasspathItem1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonRemoveClasspathItem, (String)I18n.getString("Global.Button.Remove"));
        this.jButtonRemoveClasspathItem.setMaximumSize(new Dimension(200, 26));
        this.jButtonRemoveClasspathItem.setMinimumSize(new Dimension(90, 26));
        this.jButtonRemoveClasspathItem.setPreferredSize(new Dimension(120, 26));
        this.jButtonRemoveClasspathItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IReportPanel.this.jButtonRemoveClasspathItemActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel5.add((Component)this.jButtonRemoveClasspathItem, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonMoveUpClasspathItem, (String)I18n.getString("Global.Button.MoveUp"));
        this.jButtonMoveUpClasspathItem.setMaximumSize(new Dimension(200, 26));
        this.jButtonMoveUpClasspathItem.setMinimumSize(new Dimension(90, 26));
        this.jButtonMoveUpClasspathItem.setPreferredSize(new Dimension(120, 26));
        this.jButtonMoveUpClasspathItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IReportPanel.this.jButtonMoveUpClasspathItemActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel5.add((Component)this.jButtonMoveUpClasspathItem, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonMoveDownClasspathItem, (String)I18n.getString("Global.Button.MoveDown"));
        this.jButtonMoveDownClasspathItem.setMaximumSize(new Dimension(200, 26));
        this.jButtonMoveDownClasspathItem.setMinimumSize(new Dimension(90, 26));
        this.jButtonMoveDownClasspathItem.setPreferredSize(new Dimension(120, 26));
        this.jButtonMoveDownClasspathItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IReportPanel.this.jButtonMoveDownClasspathItemActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel5.add((Component)this.jButtonMoveDownClasspathItem, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.jPanel6, gridBagConstraints);
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jLabelClasspath, -1, 488, Short.MAX_VALUE).add(2, (GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 360, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel5, -2, 122, -2))).addContainerGap()));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabelClasspath).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jPanel5, -1, 285, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 285, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab(I18n.getString("IReportPanel.Label.Classpath"), this.jPanel4);
        this.jLabelFontspath.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.jLabelFontspath, (String)I18n.getString("IReportPanel.Label.FontsPath"));
        this.jListFontspath.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.jListFontspath);
        this.jPanel8.setMinimumSize(new Dimension(120, 10));
        this.jPanel8.setPreferredSize(new Dimension(120, 10));
        this.jPanel8.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectAllFonts, (String)I18n.getString("Global.Button.SelectAll"));
        this.jButtonSelectAllFonts.setMaximumSize(new Dimension(200, 26));
        this.jButtonSelectAllFonts.setMinimumSize(new Dimension(90, 26));
        this.jButtonSelectAllFonts.setPreferredSize(new Dimension(120, 26));
        this.jButtonSelectAllFonts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IReportPanel.this.jButtonSelectAllFontsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel8.add((Component)this.jButtonSelectAllFonts, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonDeselectAllFonts, (String)I18n.getString("Global.Button.DeselectAll"));
        this.jButtonDeselectAllFonts.setMaximumSize(new Dimension(200, 26));
        this.jButtonDeselectAllFonts.setMinimumSize(new Dimension(90, 26));
        this.jButtonDeselectAllFonts.setPreferredSize(new Dimension(120, 26));
        this.jButtonDeselectAllFonts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IReportPanel.this.jButtonDeselectAllFontsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel8.add((Component)this.jButtonDeselectAllFonts, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel8.add((Component)this.jPanel9, gridBagConstraints);
        GroupLayout jPanel7Layout = new GroupLayout((Container)this.jPanel7);
        this.jPanel7.setLayout((LayoutManager)jPanel7Layout);
        jPanel7Layout.setHorizontalGroup((GroupLayout.Group)jPanel7Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel7Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel7Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel7Layout.createSequentialGroup().add((Component)this.jScrollPane2, -1, 362, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel8, -2, -1, -2)).add((Component)this.jLabelFontspath, -1, 488, Short.MAX_VALUE)).addContainerGap()));
        jPanel7Layout.setVerticalGroup((GroupLayout.Group)jPanel7Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel7Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabelFontspath, -2, 14, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel7Layout.createParallelGroup(2).add((Component)this.jPanel8, -1, 285, Short.MAX_VALUE).add((Component)this.jScrollPane2, -1, 285, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab("Fontpath", this.jPanel7);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTabbedPane1, -1, 513, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTabbedPane1, -1, 355, Short.MAX_VALUE));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName("General");
    }

    private void jComboBoxUnitsActionPerformed(ActionEvent evt) {
        this.controller.changed();
    }

    private void jCheckBoxLimitRecordNumberActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxLimitRecordNumberStateChanged(ChangeEvent evt) {
        this.jLabelMaxNumber.setEnabled(this.jCheckBoxLimitRecordNumber.isSelected());
        this.jSpinnerMaxRecordNumber.setEnabled(this.jCheckBoxLimitRecordNumber.isSelected());
        this.controller.changed();
    }

    private void jSpinnerMaxRecordNumberStateChanged(ChangeEvent evt) {
        this.controller.changed();
    }

    private void jCheckBoxIgnorePaginationStateChanged(ChangeEvent evt) {
    }

    private void jCheckBoxIgnorePaginationActionPerformed(ActionEvent evt) {
    }

    private void jButtonReportLocaleActionPerformed(ActionEvent evt) {
        LocaleSelectorDialog selectorDialog = null;
        Window w = SwingUtilities.getWindowAncestor(this);
        selectorDialog = w instanceof Dialog ? new LocaleSelectorDialog((Dialog)w, true) : new LocaleSelectorDialog((Frame)w, true);
        if (this.getCurrentReportLocale() != null) {
            selectorDialog.setSelectedLocale(this.getCurrentReportLocale());
        }
        selectorDialog.setVisible(true);
        if (selectorDialog.getDialogResult() == 0) {
            this.setCurrentReportLocale(selectorDialog.getSelectedLocale());
        }
        this.controller.changed();
    }

    private void jButtonTimeZoneActionPerformed(ActionEvent evt) {
        TimeZoneDialog selectorDialog = null;
        Window w = SwingUtilities.getWindowAncestor(this);
        selectorDialog = w instanceof Dialog ? new TimeZoneDialog((Dialog)w, true) : new TimeZoneDialog((Frame)w, true);
        if (this.getCurrentReportTimeZoneId() != null) {
            selectorDialog.setReportTimeZoneId(this.getCurrentReportTimeZoneId());
        }
        selectorDialog.setVisible(true);
        if (selectorDialog.getDialogResult() == 0) {
            this.setCurrentReportTimeZoneId(selectorDialog.getReportTimeZoneId());
        }
        this.controller.changed();
    }

    private void jButtonAddClasspathItemActionPerformed(ActionEvent evt) {
        String fileName = "";
        JFileChooser jfc = new JFileChooser(IReportManager.getInstance().getCurrentDirectory());
        jfc.setDialogTitle(I18n.getString("IReportPanel.Title.Dialog"));
        jfc.setDialogTitle(I18n.getString("IReportPanel.Title.Dialog"));
        jfc.setAcceptAllFileFilterUsed(true);
        jfc.setFileSelectionMode(0);
        jfc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.toLowerCase().endsWith(".jar") || file.isDirectory() || filename.toLowerCase().endsWith(".zip");
            }

            public String getDescription() {
                return "*.jar, *.zip";
            }
        });
        jfc.setMultiSelectionEnabled(true);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            File[] files = jfc.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                ((DefaultListModel)this.jListClassPath.getModel()).addElement(files[i]);
            }
            IReportManager.getInstance().setCurrentDirectory(jfc.getSelectedFile(), true);
            this.controller.changed();
            this.classpathChanged();
        }
    }

    private void jButtonAddClasspathItem1jButtonAddActionPerformed1(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser(IReportManager.getInstance().getCurrentDirectory());
        jfc.setDialogTitle(I18n.getString("IReportPanel.Title.Dialog"));
        jfc.setDialogTitle(I18n.getString("IReportPanel.Title.Dialog"));
        jfc.setAcceptAllFileFilterUsed(true);
        jfc.setFileSelectionMode(1);
        jfc.setMultiSelectionEnabled(true);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            File[] files = jfc.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                ((DefaultListModel)this.jListClassPath.getModel()).addElement(files[i]);
            }
            IReportManager.getInstance().setCurrentDirectory(jfc.getSelectedFile(), true);
            this.controller.changed();
            this.classpathChanged();
        }
    }

    private void jButtonRemoveClasspathItemActionPerformed(ActionEvent evt) {
        if (this.jListClassPath.getSelectedValues() != null) {
            Object[] values = this.jListClassPath.getSelectedValues();
            for (int i = 0; i < values.length; ++i) {
                ((DefaultListModel)this.jListClassPath.getModel()).removeElement(values[i]);
            }
            this.controller.changed();
            this.classpathChanged();
        }
    }

    private void jButtonMoveUpClasspathItemActionPerformed(ActionEvent evt) {
        if (this.jListClassPath.getSelectedValues() != null) {
            int[] indices = this.jListClassPath.getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                if (indices[i] == 0) continue;
                Object val = ((DefaultListModel)this.jListClassPath.getModel()).remove(indices[i]);
                ((DefaultListModel)this.jListClassPath.getModel()).insertElementAt(val, indices[i] - 1);
                int n = i;
                indices[n] = indices[n] - 1;
            }
            this.jListClassPath.setSelectedIndices(indices);
            this.controller.changed();
        }
    }

    private void jButtonMoveDownClasspathItemActionPerformed(ActionEvent evt) {
        if (this.jListClassPath.getSelectedValues() != null) {
            int[] indices = this.jListClassPath.getSelectedIndices();
            for (int i = indices.length - 1; i >= 0; --i) {
                if (indices[i] >= ((DefaultListModel)this.jListClassPath.getModel()).size() - 1) continue;
                Object val = ((DefaultListModel)this.jListClassPath.getModel()).remove(indices[i]);
                ((DefaultListModel)this.jListClassPath.getModel()).insertElementAt(val, indices[i] + 1);
                int n = i;
                indices[n] = indices[n] + 1;
            }
            this.jListClassPath.setSelectedIndices(indices);
            this.controller.changed();
        }
    }

    private void jButtonSelectAllFontsActionPerformed(ActionEvent evt) {
        DefaultListModel dlm = (DefaultListModel)this.jListFontspath.getModel();
        for (int i = 0; i < dlm.size(); ++i) {
            Object obj = dlm.getElementAt(i);
            if (!(obj instanceof JCheckBox)) continue;
            JCheckBox checkbox = (JCheckBox)obj;
            checkbox.setSelected(true);
        }
        this.jListFontspath.updateUI();
    }

    private void jButtonDeselectAllFontsActionPerformed(ActionEvent evt) {
        DefaultListModel dlm = (DefaultListModel)this.jListFontspath.getModel();
        for (int i = 0; i < dlm.size(); ++i) {
            Object obj = dlm.getElementAt(i);
            if (!(obj instanceof JCheckBox)) continue;
            JCheckBox checkbox = (JCheckBox)obj;
            checkbox.setSelected(false);
        }
        this.jListFontspath.updateUI();
    }

    void load() {
        Preferences pref = IReportManager.getPreferences();
        String unit = pref.get(I18n.getString("IReportPanel.Value.Unit"), I18n.getString("IReportPanel.Measure.inches"));
        Misc.setComboboxSelectedTagValue(this.jComboBoxUnits, unit);
        this.jCheckBoxLimitRecordNumber.setSelected(pref.getBoolean("limitRecordNumber", false));
        ((SpinnerNumberModel)this.jSpinnerMaxRecordNumber.getModel()).setValue(pref.getInt("maxRecordNumber", 1));
        this.jCheckBoxIgnorePagination.setSelected(pref.getBoolean("isIgnorePagination", false));
        String locName = pref.get("reportLocale", null);
        if (locName != null) {
            this.setCurrentReportLocale(Misc.getLocaleFromString(locName));
        } else {
            this.setCurrentReportLocale(null);
        }
        String timeZoneId = pref.get("reportTimeZone", null);
        if (timeZoneId != null) {
            this.setCurrentReportTimeZoneId(timeZoneId);
        } else {
            this.setCurrentReportTimeZoneId(null);
        }
        ((DefaultListModel)this.jListClassPath.getModel()).clear();
        List<String> cp = IReportManager.getInstance().getClasspath();
        for (String path : cp) {
            if (path == null || path.length() <= 0) continue;
            ((DefaultListModel)this.jListClassPath.getModel()).addElement(path);
        }
        this.setFontspath(IReportManager.getInstance().getFontpath(), cp);
    }

    void store() {
        Preferences pref = IReportManager.getPreferences();
        if (this.jComboBoxUnits.getSelectedIndex() >= 0) {
            String unit = "" + ((Tag)this.jComboBoxUnits.getSelectedItem()).getValue();
            pref.put(I18n.getString("IReportPanel.Value.Unit"), unit);
        }
        pref.putBoolean("limitRecordNumber", this.jCheckBoxLimitRecordNumber.isSelected());
        pref.putInt("maxRecordNumber", ((SpinnerNumberModel)this.jSpinnerMaxRecordNumber.getModel()).getNumber().intValue());
        pref.putBoolean("isIgnorePagination", this.jCheckBoxIgnorePagination.isSelected());
        if (this.getCurrentReportLocale() != null) {
            pref.put("reportLocale", this.getCurrentReportLocale().toString());
        } else {
            pref.remove("reportLocale");
        }
        if (this.getCurrentReportTimeZoneId() != null) {
            pref.put("reportTimeZone", this.getCurrentReportTimeZoneId());
        } else {
            pref.remove("reportTimeZone");
        }
        IReportManager.getInstance().setClasspath(this.getClasspath());
        IReportManager.getInstance().setFontpath(this.getFontspath());
    }

    private List<String> getClasspath() {
        ArrayList<String> cp = new ArrayList<String>();
        for (int i = 0; i < ((DefaultListModel)this.jListClassPath.getModel()).size(); ++i) {
            cp.add("" + ((DefaultListModel)this.jListClassPath.getModel()).elementAt(i));
        }
        return cp;
    }

    boolean valid() {
        return true;
    }

    public Locale getCurrentReportLocale() {
        return this.currentReportLocale;
    }

    public void setCurrentReportLocale(Locale currentReportLocale) {
        this.currentReportLocale = currentReportLocale;
        if (currentReportLocale == null) {
            this.jTextFieldReportLocale.setText("Default - " + Locale.getDefault().getDisplayName() + "");
        } else {
            this.jTextFieldReportLocale.setText(currentReportLocale.getDisplayName());
        }
    }

    public String getCurrentReportTimeZoneId() {
        return this.currentReportTimeZoneId;
    }

    public void setCurrentReportTimeZoneId(String timeZoneId) {
        this.currentReportTimeZoneId = timeZoneId;
        if (this.currentReportTimeZoneId == null) {
            this.jTextFieldTimeZone.setText("Default - " + TimeZone.getDefault().getDisplayName() + "");
        } else {
            this.jTextFieldTimeZone.setText(TimeZone.getTimeZone(timeZoneId).getDisplayName());
        }
    }

    private void setFontspath(List<String> fontsPaths, List<String> cp) {
        ArrayList<String> newcp = new ArrayList<String>();
        newcp.addAll(cp);
        ArrayList cp_old = new ArrayList();
        for (String s : fontsPaths) {
            if (newcp.contains(s)) continue;
            newcp.add(s);
        }
        Object[] allStrings = new Object[newcp.size()];
        allStrings = newcp.toArray(allStrings);
        Arrays.sort(allStrings);
        ((DefaultListModel)this.jListFontspath.getModel()).clear();
        for (int i = 0; i < allStrings.length; ++i) {
            String s = "" + allStrings[i];
            if (s.trim().length() == 0) continue;
            CheckBoxListEntry cble = new CheckBoxListEntry((Object)s, fontsPaths.contains(s));
            if (!cp.contains(s) && !cp_old.contains(s)) {
                cble.setRed(true);
            }
            ((DefaultListModel)this.jListFontspath.getModel()).addElement(cble);
        }
    }

    private List<String> getFontspath() {
        ArrayList<String> cp = new ArrayList<String>();
        List list = this.jListFontspath.getCheckedItems();
        for (int i = 0; i < list.size(); ++i) {
            CheckBoxListEntry cble = (CheckBoxListEntry)list.get(i);
            cp.add(cble.getValue() + "");
        }
        return cp;
    }

    private void classpathChanged() {
        this.setFontspath(this.getFontspath(), this.getClasspath());
    }
}

