/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.dnd.ReportObjectPaletteTransferable;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.properties.ByteProperty;
import com.jaspersoft.ireport.designer.sheet.properties.ExpressionProperty;
import com.jaspersoft.ireport.designer.sheet.properties.StringListProperty;
import com.jaspersoft.ireport.designer.sheet.properties.StringProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class CrosstabMeasureNode
extends IRAbstractNode
implements PropertyChangeListener {
    JasperDesign jd = null;
    private JRDesignCrosstab crosstab = null;
    private JRDesignCrosstabMeasure measure = null;

    public CrosstabMeasureNode(JasperDesign jd, JRDesignCrosstab crosstab, JRDesignCrosstabMeasure measure, Lookup doLkp) {
        super(Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, crosstab, measure})}));
        this.jd = jd;
        this.measure = measure;
        this.crosstab = crosstab;
        this.setDisplayName(measure.getName());
        super.setName(measure.getName());
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/crosstabmeasures-16.png");
        measure.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new NameProperty(this.getMeasure(), this.jd, this.getCrosstab()));
        set.put((Node.Property)new ValueClassNameProperty(this.getMeasure()));
        set.put((Node.Property)new ValueExpressionProperty(this.getMeasure(), this.getCrosstab(), this.jd));
        set.put((Node.Property)new CalculationProperty(this.getMeasure(), this.getCrosstab()));
        set.put((Node.Property)new IncrementerFactoryClassNameProperty(this.getMeasure()));
        set.put((Node.Property)new PercentageOfTypeProperty(this.getMeasure()));
        set.put((Node.Property)new PercentageCalculatorClassNameProperty(this.getMeasure()));
        sheet.put(set);
        return sheet;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        super.destroy();
        this.getCrosstab().removeMeasure((JRCrosstabMeasure)this.measure);
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)4);
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)1);
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), SystemAction.get(RenameAction.class), SystemAction.get(ReorderAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        tras.put((ExTransferable.Single)new ReportObjectPaletteTransferable("com.jaspersoft.ireport.designer.palette.actions.CreateTextFieldFromCrosstabMeasureNodeAction", this));
        return tras;
    }

    public void setName(String s) {
        if (s.equals("")) {
            throw new IllegalArgumentException("Measure name not valid.");
        }
        List<JRCrosstabMeasure> currentMeasures = Arrays.asList(this.getCrosstab().getMeasures());
        for (JRCrosstabMeasure p : currentMeasures) {
            if (p == this.getMeasure() || !p.getName().equals(s)) continue;
            throw new IllegalArgumentException("Measure name already in use.");
        }
        String oldName = this.getMeasure().getName();
        this.getMeasure().setName(s);
        ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getMeasure(), "Name", String.class, oldName, s);
        IReportManager.getInstance().addUndoableEdit(opue);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("name")) {
            super.setName(this.getMeasure().getName());
            this.setDisplayName(this.getMeasure().getName());
        }
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public JRDesignCrosstab getCrosstab() {
        return this.crosstab;
    }

    public JRDesignCrosstabMeasure getMeasure() {
        return this.measure;
    }

    private static final class PercentageCalculatorClassNameProperty
    extends PropertySupport {
        private final JRDesignCrosstabMeasure measure;

        public JRDesignCrosstabMeasure getMeasure() {
            return this.measure;
        }

        public PercentageCalculatorClassNameProperty(JRDesignCrosstabMeasure measure) {
            super("percentageCalculatorClassName", String.class, "Percentage calculator", "The class to use to calculate the percentage", true, true);
            this.measure = measure;
            this.setValue("oneline", Boolean.TRUE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.getMeasure().getPercentageCalculatorClassName() == null ? "" : this.getMeasure().getPercentageCalculatorClassName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof String) {
                String oldValue = this.getMeasure().getPercentageCalculatorClassName();
                String newValue = val == null || ((String)val).trim().length() == 0 ? null : ((String)val).trim();
                this.getMeasure().setPercentageCalculatorClassName(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.getMeasure(), "PercentageCalculatorClassName", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    public static final class PercentageOfTypeProperty
    extends ByteProperty {
        private final JRDesignCrosstabMeasure measure;

        public JRDesignCrosstabMeasure getMeasure() {
            return this.measure;
        }

        public PercentageOfTypeProperty(JRDesignCrosstabMeasure measure) {
            super(measure);
            this.setName("percentageOfType");
            this.setDisplayName("Percentage of type");
            this.setShortDescription("The percentage calculation type performed on this measure");
            this.measure = measure;
        }

        public List getTagList() {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tags.add(new Tag(new Byte(0), "None"));
            tags.add(new Tag(new Byte(1), "Grand Total"));
            return tags;
        }

        public Byte getByte() {
            return this.measure.getPercentageOfType();
        }

        public Byte getOwnByte() {
            return this.measure.getPercentageOfType();
        }

        public Byte getDefaultByte() {
            return (byte)0;
        }

        public void setByte(Byte b) {
            this.measure.setPercentageOfType(b.byteValue());
        }
    }

    public static final class ValueExpressionProperty
    extends ExpressionProperty {
        private final JRDesignCrosstabMeasure measure;
        private final JRDesignCrosstab crosstab;
        private final JasperDesign jd;

        public JRDesignCrosstabMeasure getMeasure() {
            return this.measure;
        }

        public ValueExpressionProperty(JRDesignCrosstabMeasure measure, JRDesignCrosstab crosstab, JasperDesign jd) {
            super((Object)measure, new ExpressionContext(ModelUtils.getCrosstabDataset(crosstab, jd)));
            this.setName("expression");
            this.setDisplayName("Value Expression");
            this.setShortDescription("The expression of the measure.");
            this.crosstab = crosstab;
            this.measure = measure;
            this.jd = jd;
            crosstab.getEventSupport().addPropertyChangeListener("dataset", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ValueExpressionProperty.this.setValue("EXPRESSION_CONTEXT", ModelUtils.getElementDataset((JRDesignElement)ValueExpressionProperty.this.getCrosstab(), ValueExpressionProperty.this.getJasperDesign()));
                }
            });
        }

        public JasperDesign getJasperDesign() {
            return this.jd;
        }

        public String getDefaultExpressionClassName() {
            return "java.lang.Integer";
        }

        public JRDesignExpression getExpression() {
            return (JRDesignExpression)this.measure.getValueExpression();
        }

        public void setExpression(JRDesignExpression expression) {
            expression.setValueClassName(this.measure.getValueClassName());
            this.measure.setValueExpression((JRExpression)expression);
        }

        public JRDesignCrosstab getCrosstab() {
            return this.crosstab;
        }
    }

    private static final class IncrementerFactoryClassNameProperty
    extends PropertySupport {
        private final JRDesignCrosstabMeasure measure;

        public JRDesignCrosstabMeasure getMeasure() {
            return this.measure;
        }

        public IncrementerFactoryClassNameProperty(JRDesignCrosstabMeasure measure) {
            super("incrementerFactoryClassName", String.class, "Incrementer Factory", "The class to use as Factory for the Incrementer.", true, true);
            this.measure = measure;
            this.setValue("oneline", Boolean.TRUE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.getMeasure().getIncrementerFactoryClassName() == null ? "" : this.getMeasure().getIncrementerFactoryClassName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof String) {
                String oldValue = this.getMeasure().getIncrementerFactoryClassName();
                String newValue = val == null || ((String)val).trim().length() == 0 ? null : ((String)val).trim();
                this.getMeasure().setIncrementerFactoryClassName(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.getMeasure(), "IncrementerFactoryClassName", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    public class ValueClassNameProperty
    extends StringListProperty {
        private final JRDesignCrosstabMeasure measure;

        public JRDesignCrosstabMeasure getMeasure() {
            return this.measure;
        }

        public ValueClassNameProperty(JRDesignCrosstabMeasure measure) {
            super(measure);
            this.setName("valueClassName");
            this.setDisplayName("Measure Class");
            this.setShortDescription("Measure Class");
            this.measure = measure;
        }

        public List getTagList() {
            ArrayList<Tag> classes = new ArrayList<Tag>();
            classes.add(new Tag("java.lang.Boolean"));
            classes.add(new Tag("java.lang.Byte"));
            classes.add(new Tag("java.util.Date"));
            classes.add(new Tag("java.sql.Timestamp"));
            classes.add(new Tag("java.sql.Time"));
            classes.add(new Tag("java.lang.Double"));
            classes.add(new Tag("java.lang.Float"));
            classes.add(new Tag("java.lang.Integer"));
            classes.add(new Tag("java.lang.Long"));
            classes.add(new Tag("java.lang.Short"));
            classes.add(new Tag("java.math.BigDecimal"));
            classes.add(new Tag("java.lang.Number"));
            classes.add(new Tag("java.lang.String"));
            classes.add(new Tag("java.lang.Object"));
            return classes;
        }

        public String getString() {
            return this.getMeasure().getValueClassName();
        }

        public String getOwnString() {
            return this.getMeasure().getValueClassName();
        }

        public String getDefaultString() {
            return "java.lang.Integer";
        }

        public void setString(String value) {
            this.getMeasure().setValueClassName(value);
            if (this.getMeasure().getValueExpression() != null) {
                ((JRDesignExpression)this.getMeasure().getValueExpression()).setValueClassName(value);
            }
        }
    }

    public static final class CalculationProperty
    extends ByteProperty {
        private final JRDesignCrosstabMeasure measure;
        private final JRDesignCrosstab crosstab;

        public CalculationProperty(JRDesignCrosstabMeasure measure, JRDesignCrosstab crosstab) {
            super(measure);
            this.setName("calculation");
            this.setDisplayName("Calculation");
            this.setShortDescription("The calculation type which will be performed on the measure values");
            this.crosstab = crosstab;
            this.measure = measure;
        }

        public List getTagList() {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tags.add(new Tag(new Byte(0), "Nothing"));
            tags.add(new Tag(new Byte(1), "Count"));
            tags.add(new Tag(new Byte(10), "Distinct Count"));
            tags.add(new Tag(new Byte(2), "Sum"));
            tags.add(new Tag(new Byte(3), "Average"));
            tags.add(new Tag(new Byte(4), "Lowest"));
            tags.add(new Tag(new Byte(5), "Highest"));
            tags.add(new Tag(new Byte(6), "Standard Deviation"));
            tags.add(new Tag(new Byte(7), "Variance"));
            tags.add(new Tag(new Byte(9), "First"));
            return tags;
        }

        public Byte getByte() {
            return this.measure.getCalculation();
        }

        public Byte getOwnByte() {
            return this.measure.getCalculation();
        }

        public Byte getDefaultByte() {
            return (byte)1;
        }

        public void setByte(Byte b) {
            this.measure.setCalculation(b.byteValue());
        }

        public JRDesignCrosstab getCrosstab() {
            return this.crosstab;
        }

        public JRDesignCrosstabMeasure getMeasure() {
            return this.measure;
        }
    }

    public static final class NameProperty
    extends StringProperty {
        private JRDesignCrosstabMeasure measure = null;
        private JRDesignCrosstab crosstab = null;
        private JasperDesign jd = null;

        public NameProperty(JRDesignCrosstabMeasure measure, JasperDesign jd, JRDesignCrosstab crosstab) {
            super(measure);
            this.setName("name");
            this.setDisplayName("Name");
            this.setShortDescription("Name of the measure");
            this.measure = measure;
            this.crosstab = crosstab;
            this.jd = jd;
            this.setValue("oneline", Boolean.TRUE);
        }

        public JRDesignCrosstab getCrosstab() {
            return this.crosstab;
        }

        public JRDesignCrosstabMeasure getMeasure() {
            return this.measure;
        }

        public String getString() {
            return this.measure.getName();
        }

        public String getOwnString() {
            return this.measure.getName();
        }

        public String getDefaultString() {
            return this.measure.getName();
        }

        public boolean supportsDefaultValue() {
            return false;
        }

        public void validate(Object value) {
            super.validate(value);
            if (value == null || value.equals("")) {
                IllegalArgumentException iae = this.annotateException("Measure name not valid.");
                throw iae;
            }
            String s = value + "";
            if (s.equals(this.getMeasure().getName())) {
                return;
            }
            if (!ModelUtils.isValidNewCrosstabObjectName(this.crosstab, s)) {
                IllegalArgumentException iae = this.annotateException("Measure name already in use.");
                throw iae;
            }
        }

        public void setString(String newName) {
            String oldName = this.getMeasure().getName();
            int index = this.crosstab.getMesuresList().indexOf(this.getMeasure());
            this.crosstab.removeMeasure(this.getMeasure().getName());
            this.getMeasure().setName(newName);
            try {
                this.crosstab.addMeasure(this.getMeasure());
                this.crosstab.getMesuresList().remove(this.getMeasure());
                this.crosstab.getMesuresList().add(index, this.getMeasure());
                this.crosstab.getEventSupport().firePropertyChange("measures", 0, 1);
                IReportManager.getInstance().setSelectedObject(this.getMeasure());
            }
            catch (JRException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            ModelUtils.fixElementsExpressions(this.crosstab, oldName, newName, (byte)4, this.getMeasure().getValueClassName());
            List expressions = JRExpressionCollector.collectExpressions((JRReport)this.jd, (JRCrosstab)this.crosstab);
            for (int i = 0; i < expressions.size(); ++i) {
                JRDesignExpression exp = (JRDesignExpression)expressions.get(i);
                ModelUtils.replaceChunkText(exp, oldName, newName, (byte)4, this.getMeasure().getValueClassName());
            }
        }
    }
}

