/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openidex.search.CompoundSearchIterator;
import org.openidex.search.SearchInfo;
import org.openidex.search.SimpleSearchInfo;
import org.openidex.search.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SubnodesSearchInfo
implements SearchInfo {
    private final Node node;

    public SubnodesSearchInfo(Node node) {
        this.node = node;
    }

    @Override
    public boolean canSearch() {
        Node[] nodeArray = this.node.getChildren().getNodes(true);
        for (int i = 0; i < nodeArray.length; ++i) {
            SearchInfo searchInfo = Utils.getSearchInfo(nodeArray[i]);
            if (searchInfo == null || !searchInfo.canSearch()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<DataObject> objectsToSearch() {
        int n;
        Node[] nodeArray = this.node.getChildren().getNodes(true);
        if (nodeArray.length == 0) {
            return SimpleSearchInfo.EMPTY_SEARCH_INFO.objectsToSearch();
        }
        ArrayList<SearchInfo> arrayList = new ArrayList<SearchInfo>(nodeArray.length);
        for (n = 0; n < nodeArray.length; ++n) {
            SearchInfo searchInfo = Utils.getSearchInfo(nodeArray[n]);
            if (searchInfo == null || !searchInfo.canSearch()) continue;
            arrayList.add(searchInfo);
        }
        n = arrayList.size();
        switch (n) {
            case 0: {
                return Collections.emptyList().iterator();
            }
            case 1: {
                return ((SearchInfo)arrayList.get(0)).objectsToSearch();
            }
        }
        return new CompoundSearchIterator(arrayList.toArray(new SearchInfo[n]));
    }
}

