/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.IdentifierGenerator;

public class GUIDGenerator
implements IdentifierGenerator {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$id$GUIDGenerator == null ? (class$org$hibernate$id$GUIDGenerator = GUIDGenerator.class$("org.hibernate.id.GUIDGenerator")) : class$org$hibernate$id$GUIDGenerator));
    static /* synthetic */ Class class$org$hibernate$id$GUIDGenerator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable generate(SessionImplementor session, Object obj) throws HibernateException {
        String string;
        String sql = session.getFactory().getDialect().getSelectGUIDString();
        PreparedStatement st = session.getBatcher().prepareSelectStatement(sql);
        try {
            String result;
            ResultSet rs = st.executeQuery();
            try {
                rs.next();
                result = rs.getString(1);
            }
            finally {
                rs.close();
            }
            log.debug((Object)("GUID identifier generated: " + result));
            string = result;
        }
        catch (Throwable throwable) {
            try {
                session.getBatcher().closeStatement(st);
                throw throwable;
            }
            catch (SQLException sqle) {
                throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not retrieve GUID", sql);
            }
        }
        session.getBatcher().closeStatement(st);
        return string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

