/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import mondrian.olap.Util;
import mondrian.rolap.RolapUtil;

public class SqlStatement {
    private final DataSource dataSource;
    private Connection jdbcConnection;
    private ResultSet resultSet;
    private final String sql;
    private final int maxRows;
    private final String component;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final RolapUtil.Semaphore querySemaphore = RolapUtil.getQuerySemaphore();
    private final String message;
    private boolean haveSemaphore;
    public int rowCount;
    private long startTime;
    private final PrintWriter trace;

    SqlStatement(DataSource dataSource, String sql, int maxRows, String component, String message, int resultSetType, int resultSetConcurrency) {
        this.dataSource = dataSource;
        this.sql = sql;
        this.maxRows = maxRows;
        this.component = component;
        this.message = message;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.trace = RolapUtil.checkTracing();
    }

    public void execute() throws SQLException {
        RolapUtil.ExecuteQueryHook hook;
        this.jdbcConnection = this.dataSource.getConnection();
        this.querySemaphore.enter();
        this.haveSemaphore = true;
        Statement statement = null;
        String status = "failed";
        if (this.trace != null) {
            this.trace.print(this.component + ": executing sql [");
            if (this.sql.indexOf(10) >= 0) {
                this.trace.println();
            }
            this.trace.print(this.sql);
            this.trace.print(']');
            this.trace.flush();
        }
        if ((hook = RolapUtil.threadHooks.get()) != null) {
            hook.onExecuteQuery(this.sql);
        }
        try {
            this.startTime = System.currentTimeMillis();
            statement = this.resultSetType < 0 || this.resultSetConcurrency < 0 ? this.jdbcConnection.createStatement() : this.jdbcConnection.createStatement(this.resultSetType, this.resultSetConcurrency);
            if (this.maxRows > 0) {
                statement.setMaxRows(this.maxRows);
            }
            this.resultSet = statement.executeQuery(this.sql);
            long time = System.currentTimeMillis();
            long execMs = time - this.startTime;
            Util.addDatabaseTime(execMs);
            status = ", exec " + execMs + " ms";
        }
        catch (SQLException e) {
            status = ", failed (" + e + ")";
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            throw this.handle(e);
        }
        finally {
            if (this.trace != null) {
                this.trace.print(status);
            }
            if (RolapUtil.LOGGER.isDebugEnabled()) {
                RolapUtil.LOGGER.debug((Object)(this.component + ": executing sql [" + this.sql + "]" + status));
            }
        }
    }

    public void close() {
        if (this.haveSemaphore) {
            this.haveSemaphore = false;
            this.querySemaphore.leave();
        }
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                throw Util.newError(this.message + "; sql=[" + this.sql + "]");
            }
            finally {
                this.resultSet = null;
            }
        }
        if (this.jdbcConnection != null) {
            try {
                this.jdbcConnection.close();
            }
            catch (SQLException e) {
                throw Util.newError(this.message + "; sql=[" + this.sql + "]");
            }
            finally {
                this.jdbcConnection = null;
            }
        }
        long time = System.currentTimeMillis();
        long totalMs = time - this.startTime;
        if (this.trace != null) {
            this.trace.println(", exec+fetch " + totalMs + " ms, " + this.rowCount + " rows");
        }
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public RuntimeException handle(Exception e) {
        RuntimeException runtimeException = Util.newError(e, this.message + "; sql=[" + this.sql + "]");
        try {
            this.close();
        }
        catch (RuntimeException runtimeException2) {
            // empty catch block
        }
        return runtimeException;
    }
}

