/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.Collections;
import java.util.List;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractColumnPredicate
implements StarColumnPredicate {
    private final RolapStar.Column constrainedColumn;

    protected AbstractColumnPredicate(RolapStar.Column constrainedColumn) {
        this.constrainedColumn = constrainedColumn;
    }

    @Override
    public RolapStar.Column getConstrainedColumn() {
        return this.constrainedColumn;
    }

    @Override
    public List<RolapStar.Column> getConstrainedColumnList() {
        return Collections.singletonList(this.constrainedColumn);
    }

    @Override
    public boolean evaluate(List<Object> valueList) {
        assert (valueList.size() == 1);
        return this.evaluate(valueList.get(0));
    }

    @Override
    public boolean equalConstraint(StarPredicate that) {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory {
        public static StarColumnPredicate equal(RolapStar.Column column, Object value) {
            return new ValueColumnPredicate(column, value);
        }

        public static StarColumnPredicate or(RolapStar.Column column, List<StarColumnPredicate> list) {
            return new ListColumnPredicate(column, list);
        }

        public static LiteralStarPredicate bool(boolean b) {
            return b ? LiteralStarPredicate.TRUE : LiteralStarPredicate.FALSE;
        }

        public static StarColumnPredicate equal(ValueColumnPredicate predicate) {
            return Factory.equal(predicate.getConstrainedColumn(), predicate.getValue());
        }
    }
}

